/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.io.Serializable;
import java.util.HashSet;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;

@Immutable
class DeferredAllocationPool
implements Serializable {
    private static final long serialVersionUID = -6957524864610223235L;
    private final PersistentList<String> pointerVariables;
    private final boolean isZeroing;
    private final CIntegerLiteralExpression size;
    private final PersistentList<String> baseVariables;

    private DeferredAllocationPool(PersistentList<String> pointerVariables, boolean isZeroing, CIntegerLiteralExpression size, PersistentList<String> baseVariables) {
        this.pointerVariables = pointerVariables;
        this.isZeroing = isZeroing;
        this.size = size;
        this.baseVariables = baseVariables;
    }

    DeferredAllocationPool(String pointerVariable, boolean isZeroing, CIntegerLiteralExpression size, String baseVariable) {
        this((PersistentList<String>)PersistentLinkedList.of((Object)pointerVariable), isZeroing, size, (PersistentList<String>)PersistentLinkedList.of((Object)baseVariable));
    }

    private DeferredAllocationPool(DeferredAllocationPool predecessor, PersistentList<String> pointerVariables) {
        this(pointerVariables, predecessor.isZeroing, predecessor.size, predecessor.baseVariables);
    }

    public PersistentList<String> getPointerVariables() {
        return this.pointerVariables;
    }

    public PersistentList<String> getBaseVariables() {
        return this.baseVariables;
    }

    public boolean wasAllocationZeroing() {
        return this.isZeroing;
    }

    public CIntegerLiteralExpression getSize() {
        return this.size;
    }

    DeferredAllocationPool addPointerVariable(String pointerVariable) {
        assert (!this.pointerVariables.contains((Object)pointerVariable)) : "Pointer variable " + pointerVariable + " added twice to deferred allocation pool.";
        return new DeferredAllocationPool(this, (PersistentList<String>)this.pointerVariables.with((Object)pointerVariable));
    }

    DeferredAllocationPool removePointerVariable(String pointerVariable) {
        return new DeferredAllocationPool(this, (PersistentList<String>)this.pointerVariables.without((Object)pointerVariable));
    }

    DeferredAllocationPool mergeWith(DeferredAllocationPool other) {
        return new DeferredAllocationPool(DeferredAllocationPool.mergeLists(this.pointerVariables, other.pointerVariables), this.isZeroing && other.isZeroing, this.size != null && other.size != null ? (this.size.getValue().equals(other.size.getValue()) ? this.size : null) : (this.size != null ? this.size : other.size), DeferredAllocationPool.mergeLists(this.baseVariables, other.baseVariables));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeferredAllocationPool)) {
            return false;
        }
        DeferredAllocationPool otherPool = (DeferredAllocationPool)other;
        return this.pointerVariables.containsAll(otherPool.pointerVariables) && otherPool.pointerVariables.containsAll(this.pointerVariables);
    }

    public int hashCode() {
        int result = 0;
        for (String s : this.pointerVariables) {
            result += s.hashCode();
        }
        return result;
    }

    static <T> PersistentList<T> mergeLists(PersistentList<T> list1, PersistentList<T> list2) {
        PersistentList biggerList;
        PersistentList<T> smallerList;
        int size2;
        if (list1 == list2) {
            return list1;
        }
        int size1 = list1.size();
        if (size1 == (size2 = list2.size()) && list1.equals(list2)) {
            return list1;
        }
        if (size1 > size2) {
            smallerList = list2;
            biggerList = list1;
        } else {
            smallerList = list1;
            biggerList = list2;
        }
        HashSet<T> fromBigger = new HashSet<T>(biggerList);
        PersistentList result = biggerList;
        for (Object target : FluentIterable.from(smallerList).filter(Predicates.not((Predicate)Predicates.in(fromBigger)))) {
            result = result.with(target);
        }
        return result;
    }
}

