/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ErrorConditions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.Constraints;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.AssignmentHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CExpressionVisitorWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocationPool;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.Expression;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetPattern;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;

class DynamicMemoryHandler {
    private static final String CALLOC_FUNCTION = "calloc";
    private static final String MALLOC_INDEX_SEPARATOR = "#";
    private static final UniqueIdGenerator dynamicAllocationCounter = new UniqueIdGenerator();
    private final CToFormulaConverterWithPointerAliasing conv;
    private final CFAEdge edge;
    private final SSAMap.SSAMapBuilder ssa;
    private final PointerTargetSetBuilder pts;
    private final Constraints constraints;
    private final ErrorConditions errorConditions;

    DynamicMemoryHandler(CToFormulaConverterWithPointerAliasing pConv, CFAEdge pEdge, SSAMap.SSAMapBuilder pSsa, PointerTargetSetBuilder pPts, Constraints pConstraints, ErrorConditions pErrorConditions) {
        this.conv = pConv;
        this.edge = pEdge;
        this.ssa = pSsa;
        this.pts = pPts;
        this.constraints = pConstraints;
        this.errorConditions = pErrorConditions;
    }

    Expression.Value handleDynamicMemoryFunction(CFunctionCallExpression e, String functionName, CExpressionVisitorWithPointerAliasing expressionVisitor) throws UnrecognizedCCodeException, InterruptedException {
        if (this.conv.options.isSuccessfulAllocFunctionName(functionName) || this.conv.options.isSuccessfulZallocFunctionName(functionName)) {
            return Expression.Value.ofValue(this.handleSucessfulMemoryAllocation(functionName, e.getParameterExpressions(), e));
        }
        if (this.conv.options.isMemoryAllocationFunction(functionName) || this.conv.options.isMemoryAllocationFunctionWithZeroing(functionName)) {
            return Expression.Value.ofValue(this.handleMemoryAllocation(e, functionName));
        }
        if (this.conv.options.isMemoryFreeFunction(functionName)) {
            return this.handleMemoryFree(e, expressionVisitor);
        }
        throw new AssertionError((Object)("Unknown memory allocation function " + functionName));
    }

    private Formula handleMemoryAllocation(CFunctionCallExpression e, String functionName) throws UnrecognizedCCodeException, InterruptedException {
        String delegateFunctionName;
        boolean isZeroing = this.conv.options.isMemoryAllocationFunctionWithZeroing(functionName);
        List<CExpression> parameters = e.getParameterExpressions();
        if (functionName.equals(CALLOC_FUNCTION) && parameters.size() == 2) {
            CExpression param0 = parameters.get(0);
            CExpression param1 = parameters.get(1);
            CBinaryExpressionBuilder builder = new CBinaryExpressionBuilder(this.conv.machineModel, (LogManager)this.conv.logger);
            CBinaryExpression multiplication = builder.buildBinaryExpression(param0, param1, CBinaryExpression.BinaryOperator.MULTIPLY);
            Integer value0 = DynamicMemoryHandler.tryEvaluateExpression(param0);
            Integer value1 = DynamicMemoryHandler.tryEvaluateExpression(param1);
            if (value0 != null && value1 != null) {
                long result = ExpressionValueVisitor.calculateBinaryOperation(new NumericValue(value0.longValue()), new NumericValue(value1.longValue()), multiplication, this.conv.machineModel, this.conv.logger).asLong(multiplication.getExpressionType());
                CIntegerLiteralExpression newParam = new CIntegerLiteralExpression(param0.getFileLocation(), multiplication.getExpressionType(), BigInteger.valueOf(result));
                parameters = Collections.singletonList(newParam);
            } else {
                parameters = Collections.singletonList(multiplication);
            }
        } else if (parameters.size() != 1) {
            if (parameters.size() > 1 && this.conv.options.hasSuperfluousParameters(functionName)) {
                parameters = Collections.singletonList(parameters.get(0));
            } else {
                throw new UnrecognizedCCodeException(String.format("Memory allocation function %s() called with %d parameters instead of 1", functionName, parameters.size()), this.edge, e);
            }
        }
        String string = delegateFunctionName = !isZeroing ? this.conv.options.getSuccessfulAllocFunctionName() : this.conv.options.getSuccessfulZallocFunctionName();
        if (!this.conv.options.makeMemoryAllocationsAlwaysSucceed()) {
            Formula nondet = this.conv.makeFreshVariable(functionName, CPointerType.POINTER_TO_VOID, this.ssa);
            return this.conv.bfmgr.ifThenElse(this.conv.bfmgr.not(this.conv.fmgr.makeEqual(nondet, this.conv.nullPointer)), this.handleSucessfulMemoryAllocation(delegateFunctionName, parameters, e), this.conv.nullPointer);
        }
        return this.handleSucessfulMemoryAllocation(delegateFunctionName, parameters, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Formula handleSucessfulMemoryAllocation(String functionName, List<CExpression> parameters, CFunctionCallExpression e) throws UnrecognizedCCodeException, InterruptedException {
        Formula address;
        String newBase;
        CType newType;
        if (parameters.size() != 1) {
            if (parameters.size() <= 1 || !this.conv.options.hasSuperfluousParameters(functionName)) throw new UnrecognizedCCodeException(String.format("Memory allocation function %s() called with %d parameters instead of 1", functionName, parameters.size()), this.edge, e);
            parameters = Collections.singletonList(parameters.get(0));
        }
        CExpression parameter = parameters.get(0);
        Integer size = null;
        if (DynamicMemoryHandler.isSizeof(parameter)) {
            newType = DynamicMemoryHandler.getSizeofType(parameter);
        } else if (DynamicMemoryHandler.isSizeofMultilple(parameter)) {
            CBinaryExpression product = (CBinaryExpression)parameter;
            CType operand1Type = DynamicMemoryHandler.getSizeofType(product.getOperand1());
            CType operand2Type = DynamicMemoryHandler.getSizeofType(product.getOperand2());
            if (operand1Type != null) {
                newType = new CArrayType(false, false, operand1Type, product.getOperand2());
            } else {
                if (operand2Type == null) throw new UnrecognizedCCodeException("Can't determine type for internal memory allocation", this.edge, e);
                newType = new CArrayType(false, false, operand2Type, product.getOperand1());
            }
        } else {
            size = DynamicMemoryHandler.tryEvaluateExpression(parameter);
            if (!this.conv.options.revealAllocationTypeFromLHS() && !this.conv.options.deferUntypedAllocations()) {
                CExpression length;
                if (size == null) {
                    size = this.conv.options.defaultAllocationSize();
                    length = new CIntegerLiteralExpression(parameter.getFileLocation(), parameter.getExpressionType(), BigInteger.valueOf(size.intValue()));
                } else {
                    length = parameter;
                }
                newType = new CArrayType(false, false, CVoidType.VOID, length);
            } else {
                newType = null;
            }
        }
        if (newType != null) {
            newBase = DynamicMemoryHandler.makeAllocVariableName(functionName, newType);
            address = this.makeAllocation(this.conv.options.isSuccessfulZallocFunctionName(functionName), newType, newBase);
        } else {
            newBase = DynamicMemoryHandler.makeAllocVariableName(functionName, CVoidType.VOID);
            this.pts.addTemporaryDeferredAllocation(this.conv.options.isSuccessfulZallocFunctionName(functionName), size != null ? new CIntegerLiteralExpression(parameter.getFileLocation(), parameter.getExpressionType(), BigInteger.valueOf(size.intValue())) : null, newBase);
            address = this.conv.makeConstant(PointerTargetSet.getBaseName(newBase), CPointerType.POINTER_TO_VOID);
        }
        if (!this.errorConditions.isEnabled()) return address;
        this.constraints.addConstraint(this.conv.fmgr.makeEqual(this.conv.makeBaseAddressOfTerm(address), address));
        return address;
    }

    private Expression.Value handleMemoryFree(CFunctionCallExpression e, CExpressionVisitorWithPointerAliasing expressionVisitor) throws UnrecognizedCCodeException {
        List<CExpression> parameters = e.getParameterExpressions();
        if (parameters.size() != 1) {
            throw new UnrecognizedCCodeException(String.format("free() called with %d parameters", parameters.size()), this.edge, e);
        }
        if (this.errorConditions.isEnabled()) {
            Formula operand = expressionVisitor.asValueFormula(parameters.get(0).accept(expressionVisitor), CTypeUtils.simplifyType(parameters.get(0).getExpressionType()));
            BooleanFormula validFree = this.conv.fmgr.makeEqual(operand, this.conv.nullPointer);
            for (String base : this.pts.getAllBases()) {
                Formula baseF = this.conv.makeConstant(PointerTargetSet.getBaseName(base), CPointerType.POINTER_TO_VOID);
                validFree = this.conv.bfmgr.or(validFree, this.conv.fmgr.makeEqual(operand, baseF));
            }
            this.errorConditions.addInvalidFreeCondition(this.conv.bfmgr.not(validFree));
        }
        return Expression.Value.nondetValue();
    }

    private Formula makeAllocation(boolean isZeroing, CType type, String base) throws UnrecognizedCCodeException, InterruptedException {
        CType baseType = CTypeUtils.getBaseType(type);
        Formula result = this.conv.makeConstant(PointerTargetSet.getBaseName(base), baseType);
        if (isZeroing) {
            AssignmentHandler assignmentHandler = new AssignmentHandler(this.conv, this.edge, base, this.ssa, this.pts, this.constraints, this.errorConditions);
            BooleanFormula initialization = assignmentHandler.makeAssignment(type, CNumericTypes.SIGNED_CHAR, Expression.Location.AliasedLocation.ofAddress(result), Expression.Value.ofValue(this.conv.fmgr.makeNumber(this.conv.getFormulaTypeFromCType(CNumericTypes.SIGNED_CHAR), 0L)), PointerTargetPattern.forBase(base), true, null);
            this.constraints.addConstraint(initialization);
        }
        this.conv.addPreFilledBase(base, type, false, isZeroing, this.constraints, this.pts);
        return result;
    }

    static String makeAllocVariableName(String functionName, CType type) {
        return functionName + "_" + CToFormulaConverterWithPointerAliasing.getUFName(type) + MALLOC_INDEX_SEPARATOR + dynamicAllocationCounter.getFreshId();
    }

    private static Integer tryEvaluateExpression(CExpression e) {
        if (e instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)e).getValue().intValue();
        }
        return null;
    }

    private static boolean isSizeof(CExpression e) {
        return e instanceof CUnaryExpression && ((CUnaryExpression)e).getOperator() == CUnaryExpression.UnaryOperator.SIZEOF || e instanceof CTypeIdExpression && ((CTypeIdExpression)e).getOperator() == CTypeIdExpression.TypeIdOperator.SIZEOF;
    }

    private static boolean isSizeofMultilple(CExpression e) {
        return e instanceof CBinaryExpression && ((CBinaryExpression)e).getOperator() == CBinaryExpression.BinaryOperator.MULTIPLY && (DynamicMemoryHandler.isSizeof(((CBinaryExpression)e).getOperand1()) || DynamicMemoryHandler.isSizeof(((CBinaryExpression)e).getOperand2()));
    }

    private static CType getSizeofType(CExpression e) {
        if (e instanceof CUnaryExpression && ((CUnaryExpression)e).getOperator() == CUnaryExpression.UnaryOperator.SIZEOF) {
            return CTypeUtils.simplifyType(((CUnaryExpression)e).getOperand().getExpressionType());
        }
        if (e instanceof CTypeIdExpression && ((CTypeIdExpression)e).getOperator() == CTypeIdExpression.TypeIdOperator.SIZEOF) {
            return CTypeUtils.simplifyType(((CTypeIdExpression)e).getType());
        }
        return null;
    }

    private CType refineType(@Nonnull CType type, @Nonnull CIntegerLiteralExpression sizeLiteral) {
        assert (sizeLiteral.getValue() != null);
        int size = sizeLiteral.getValue().intValue();
        int typeSize = this.conv.getSizeof(type);
        if (type instanceof CArrayType) {
            if (typeSize != size) {
                this.conv.logger.logf(Level.WARNING, "Array size of the revealed type differs form the allocation size: %s : %d != %d", new Object[]{type, typeSize, size});
            }
            return type;
        }
        int n = size / typeSize;
        int remainder = size % typeSize;
        if (n == 0 || remainder != 0) {
            this.conv.logger.logf(Level.WARNING, "Can't refine allocation type, but the sizes differ: %s : %d != %d", new Object[]{type, typeSize, size});
            return type;
        }
        return new CArrayType(false, false, type, new CIntegerLiteralExpression(sizeLiteral.getFileLocation(), sizeLiteral.getExpressionType(), BigInteger.valueOf(n)));
    }

    private CType getAllocationType(@Nonnull CType type, @Nullable CIntegerLiteralExpression sizeLiteral) {
        if (type instanceof CPointerType) {
            return sizeLiteral != null ? this.refineType(((CPointerType)type).getType(), sizeLiteral) : ((CPointerType)type).getType();
        }
        if (type instanceof CArrayType) {
            return sizeLiteral != null ? this.refineType(type, sizeLiteral) : type;
        }
        throw new IllegalArgumentException("Either pointer or array type expected");
    }

    private void handleDeferredAllocationTypeRevelation(@Nonnull String pointerVariable, @Nonnull CType type) throws UnrecognizedCCodeException, InterruptedException {
        DeferredAllocationPool deferredAllocationPool = this.pts.removeDeferredAllocation(pointerVariable);
        for (String baseVariable : deferredAllocationPool.getBaseVariables()) {
            this.makeAllocation(deferredAllocationPool.wasAllocationZeroing(), this.getAllocationType(type, deferredAllocationPool.getSize()), baseVariable);
        }
    }

    private void handleDeferredAllocationPointerEscape(String pointerVariable) throws UnrecognizedCCodeException, InterruptedException {
        DeferredAllocationPool deferredAllocationPool = this.pts.removeDeferredAllocation(pointerVariable);
        CIntegerLiteralExpression size = deferredAllocationPool.getSize() != null ? deferredAllocationPool.getSize() : new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.SIGNED_CHAR, BigInteger.valueOf(this.conv.options.defaultAllocationSize()));
        this.conv.logger.logfOnce(Level.WARNING, "The void * pointer %s to a deferred allocation escaped form tracking! Allocating array void[%d]. (in the following line(s):\n %s)", new Object[]{pointerVariable, size.getValue(), this.edge});
        for (String baseVariable : deferredAllocationPool.getBaseVariables()) {
            this.makeAllocation(deferredAllocationPool.wasAllocationZeroing(), new CArrayType(false, false, CVoidType.VOID, size), baseVariable);
        }
    }

    void handleDeferredAllocationsInAssignment(CLeftHandSide lhs, CRightHandSide rhs, Expression.Location lhsLocation, Expression rhsExpression, CType lhsType, Map<String, CType> lhsUsedDeferredAllocationPointers, Map<String, CType> rhsUsedDeferredAllocationPointers) throws UnrecognizedCCodeException, InterruptedException {
        boolean isAllocation = false;
        if ((this.conv.options.revealAllocationTypeFromLHS() || this.conv.options.deferUntypedAllocations()) && rhs instanceof CFunctionCallExpression && !rhsExpression.isNondetValue() && rhsExpression.isValue()) {
            Set<String> rhsVariables = this.conv.fmgr.extractVariableNames(rhsExpression.asValue().getValue());
            for (String variable : rhsVariables) {
                if (PointerTargetSet.isBaseName(variable)) {
                    variable = PointerTargetSet.getBase(variable);
                }
                if (!this.pts.isTemporaryDeferredAllocationPointer(variable)) continue;
                if (!isAllocation) {
                    if (CExpressionVisitorWithPointerAliasing.isRevealingType(lhsType)) {
                        this.handleDeferredAllocationTypeRevelation(variable, lhsType);
                    } else if (lhsType.equals(CPointerType.POINTER_TO_VOID) && CExpressionVisitorWithPointerAliasing.isUnaliasedLocation(lhs) && lhsLocation.isUnaliasedLocation()) {
                        String variableName = lhsLocation.asUnaliasedLocation().getVariableName();
                        if (this.pts.isDeferredAllocationPointer(variableName)) {
                            this.handleDeferredAllocationPointerRemoval(variableName, false);
                        }
                        this.pts.addDeferredAllocationPointer(variableName, variable);
                        this.handleDeferredAllocationPointerRemoval(variable, false);
                    } else {
                        this.handleDeferredAllocationPointerEscape(variable);
                    }
                    isAllocation = true;
                    continue;
                }
                throw new UnrecognizedCCodeException("Can't handle ambiguous allocation", this.edge, rhs);
            }
        }
        if (this.conv.options.deferUntypedAllocations() && !isAllocation) {
            this.handleDeferredAllocationsInAssignment(lhs, rhs, lhsLocation, rhsExpression, lhsUsedDeferredAllocationPointers, rhsUsedDeferredAllocationPointers);
        }
    }

    private void handleDeferredAllocationsInAssignment(CLeftHandSide lhs, CRightHandSide rhs, Expression.Location lhsLocation, Expression rhsExpression, Map<String, CType> lhsUsedDeferredAllocationPointers, Map<String, CType> rhsUsedDeferredAllocationPointers) throws UnrecognizedCCodeException, InterruptedException {
        boolean passed = false;
        for (Map.Entry<String, CType> usedPointer : rhsUsedDeferredAllocationPointers.entrySet()) {
            boolean handled = false;
            if (CExpressionVisitorWithPointerAliasing.isRevealingType(usedPointer.getValue())) {
                this.handleDeferredAllocationTypeRevelation(usedPointer.getKey(), usedPointer.getValue());
                handled = true;
            } else if (rhs instanceof CExpression && rhsExpression.isUnaliasedLocation()) {
                assert (CExpressionVisitorWithPointerAliasing.isUnaliasedLocation((CExpression)rhs)) : "Wrong assumptions on deferred allocations tracking: rhs " + rhsExpression + " is not unaliased";
                assert (rhsExpression.asUnaliasedLocation().getVariableName().equals(usedPointer.getKey())) : "Wrong assumptions on deferred allocations tracking: rhs " + rhsExpression + " does not match " + usedPointer;
                assert (rhsUsedDeferredAllocationPointers.size() == 1) : "Wrong assumptions on deferred allocations tracking: rhs is not a single pointer, rhsUsedDeferredAllocationPointers.size() is " + rhsUsedDeferredAllocationPointers.size();
                CType lhsType = CTypeUtils.simplifyType(lhs.getExpressionType());
                if (lhsType.equals(CPointerType.POINTER_TO_VOID) && !lhsLocation.isAliased()) {
                    Map.Entry<String, CType> lhsUsedPointer;
                    assert (CExpressionVisitorWithPointerAliasing.isUnaliasedLocation(lhs)) : "Wrong assumptions on deferred allocations tracking: lhs " + lhsLocation + " is not unaliased";
                    Map.Entry<String, CType> entry = lhsUsedPointer = !lhsUsedDeferredAllocationPointers.isEmpty() ? lhsUsedDeferredAllocationPointers.entrySet().iterator().next() : null;
                    assert (lhsUsedDeferredAllocationPointers.size() <= 1) : "Wrong assumptions on deferred allocations tracking: lhsUsedDeferredAllocationPointers.size() is " + lhsUsedDeferredAllocationPointers.size();
                    assert (lhsUsedPointer == null || lhsLocation.asUnaliased().getVariableName().equals(lhsUsedPointer.getKey())) : "Wrong assumptions on deferred allocations tracking: lhs " + lhsUsedPointer + " does not match rhs " + rhsExpression;
                    if (lhsUsedPointer != null) {
                        this.handleDeferredAllocationPointerRemoval(lhsUsedPointer.getKey(), false);
                    }
                    this.pts.addDeferredAllocationPointer(lhsLocation.asUnaliased().getVariableName(), usedPointer.getKey());
                    passed = true;
                    handled = true;
                } else if (CExpressionVisitorWithPointerAliasing.isRevealingType(lhsType)) {
                    this.handleDeferredAllocationTypeRevelation(usedPointer.getKey(), lhsType);
                    handled = true;
                }
            }
            if (handled) continue;
            this.handleDeferredAllocationPointerEscape(usedPointer.getKey());
        }
        for (Map.Entry<String, CType> usedPointer : lhsUsedDeferredAllocationPointers.entrySet()) {
            if (rhsUsedDeferredAllocationPointers.containsKey(usedPointer.getKey())) continue;
            if (CExpressionVisitorWithPointerAliasing.isRevealingType(usedPointer.getValue())) {
                this.handleDeferredAllocationTypeRevelation(usedPointer.getKey(), usedPointer.getValue());
                continue;
            }
            if (!lhsLocation.isAliased()) {
                assert (CExpressionVisitorWithPointerAliasing.isUnaliasedLocation(lhs)) : "Wrong assumptions on deferred allocations tracking: lhs " + lhsLocation + " is aliased";
                assert (lhsLocation.asUnaliased().getVariableName().equals(usedPointer.getKey())) : "Wrong assumptions on deferred allocations tracking: lhs " + lhsLocation + " does not match " + usedPointer;
                assert (lhsUsedDeferredAllocationPointers.size() == 1) : "Wrong assumptions on deferred allocations tracking: lhs is not a single pointer, lhsUsedDeferredAllocationPointers.size() is " + lhsUsedDeferredAllocationPointers.size();
                if (passed) continue;
                this.handleDeferredAllocationPointerRemoval(usedPointer.getKey(), false);
                continue;
            }
            this.handleDeferredAllocationPointerEscape(usedPointer.getKey());
        }
    }

    void handleDeferredAllocationsInAssume(CExpression e, Map<String, CType> usedDeferredAllocationPointers) throws UnrecognizedCCodeException, InterruptedException {
        block3: for (Map.Entry<String, CType> usedPointer : usedDeferredAllocationPointers.entrySet()) {
            if (!usedPointer.getValue().equals(CPointerType.POINTER_TO_VOID)) {
                this.handleDeferredAllocationTypeRevelation(usedPointer.getKey(), usedPointer.getValue());
                continue;
            }
            if (!(e instanceof CBinaryExpression)) continue;
            CBinaryExpression binaryExpression = (CBinaryExpression)e;
            switch (binaryExpression.getOperator()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case LESS_EQUAL: 
                case LESS_THAN: {
                    CType operand1Type = CTypeUtils.simplifyType(binaryExpression.getOperand1().getExpressionType());
                    CType operand2Type = CTypeUtils.simplifyType(binaryExpression.getOperand2().getExpressionType());
                    CType type = null;
                    if (CExpressionVisitorWithPointerAliasing.isRevealingType(operand1Type)) {
                        type = operand1Type;
                    } else if (CExpressionVisitorWithPointerAliasing.isRevealingType(operand2Type)) {
                        type = operand2Type;
                    }
                    if (type == null) continue block3;
                    this.handleDeferredAllocationTypeRevelation(usedPointer.getKey(), type);
                    continue block3;
                }
            }
            throw new UnrecognizedCCodeException("unexpected binary operator in assume", e);
        }
    }

    private void handleDeferredAllocationPointerRemoval(String pointerVariable, boolean isReturn) {
        if (this.pts.removeDeferredAllocatinPointer(pointerVariable)) {
            this.conv.logger.logfOnce(Level.WARNING, (!isReturn ? "Assignment to the" : "Destroying the") + " void * pointer  %s produces garbage! (in the following line(s):\n %s)", new Object[]{pointerVariable, this.edge});
        }
    }

    void handleDeferredAllocationInFunctionExit(String function) {
        SortedSet<String> localVariables = CFAUtils.filterVariablesOfFunction(this.pts.getDeferredAllocationVariables(), function);
        for (String variable : localVariables) {
            this.handleDeferredAllocationPointerRemoval(variable, true);
        }
    }
}

