/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;

abstract class Expression {
    Expression() {
    }

    public static Value ofValue(@Nullable Formula value) {
        return value != null ? new Value(value) : null;
    }

    public static Value nondetValue() {
        return Value.nondet;
    }

    public boolean isLocation() {
        return this instanceof Location;
    }

    public boolean isValue() {
        return this instanceof Value;
    }

    public boolean isNondetValue() {
        return this == Value.nondet;
    }

    public boolean isAliasedLocation() {
        return this.isLocation() && this.asLocation().isAliased();
    }

    public boolean isUnaliasedLocation() {
        return this.isLocation() && !this.asLocation().isAliased();
    }

    public Location asLocation() {
        if (this instanceof Location) {
            return (Location)this;
        }
        return null;
    }

    public Location.AliasedLocation asAliasedLocation() {
        if (this.isLocation()) {
            return this.asLocation().asAliased();
        }
        return null;
    }

    public Location.UnaliasedLocation asUnaliasedLocation() {
        if (this.isLocation()) {
            return this.asLocation().asUnaliased();
        }
        return null;
    }

    public Value asValue() {
        if (this instanceof Value) {
            return (Value)this;
        }
        return null;
    }

    public abstract Kind getKind();

    static enum Kind {
        ALIASED_LOCATION,
        UNALIASED_LOCATION,
        DET_VALUE,
        NONDET;

    }

    static class Value
    extends Expression {
        private final Formula value;
        private static final Value nondet = new Nondet();

        private Value(Formula value) {
            this.value = value;
        }

        public Formula getValue() {
            return this.value;
        }

        public boolean isNondet() {
            return false;
        }

        @Override
        public Kind getKind() {
            return Kind.DET_VALUE;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }

        static class Nondet
        extends Value {
            private Nondet() {
                super(null);
            }

            @Override
            public Formula getValue() {
                return null;
            }

            @Override
            public boolean isNondet() {
                return true;
            }

            @Override
            public Kind getKind() {
                return Kind.NONDET;
            }

            @Override
            public String toString() {
                return MoreObjects.toStringHelper((Object)this).toString();
            }
        }
    }

    static abstract class Location
    extends Expression {
        Location() {
        }

        public static AliasedLocation ofAddress(@Nonnull Formula address) {
            return new AliasedLocation(address);
        }

        public static UnaliasedLocation ofVariableName(@Nonnull String variableName) {
            return new UnaliasedLocation(variableName);
        }

        public boolean isAliased() {
            return this instanceof AliasedLocation;
        }

        public AliasedLocation asAliased() {
            if (this instanceof AliasedLocation) {
                return (AliasedLocation)this;
            }
            return null;
        }

        public UnaliasedLocation asUnaliased() {
            if (this instanceof UnaliasedLocation) {
                return (UnaliasedLocation)this;
            }
            return null;
        }

        static class UnaliasedLocation
        extends Location {
            private final String variableName;

            private UnaliasedLocation(String variableName) {
                this.variableName = variableName;
            }

            public String getVariableName() {
                return this.variableName;
            }

            @Override
            public Kind getKind() {
                return Kind.UNALIASED_LOCATION;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("variable", (Object)this.variableName).toString();
            }
        }

        static class AliasedLocation
        extends Location {
            private final Formula address;

            private AliasedLocation(Formula address) {
                this.address = address;
            }

            public Formula getAddress() {
                return this.address;
            }

            @Override
            public Kind getKind() {
                return Kind.ALIASED_LOCATION;
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
            }
        }
    }
}

