/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.collect.ImmutableSet;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;

@Options(prefix="cpa.predicate")
public class FormulaEncodingWithPointerAliasingOptions
extends FormulaEncodingOptions {
    @Option(secure=true, description="Memory allocation functions of which all parameters but the first should be ignored.")
    private ImmutableSet<String> memoryAllocationFunctionsWithSuperfluousParameters = ImmutableSet.of((Object)"__kmalloc", (Object)"kmalloc", (Object)"kzalloc");
    @Option(secure=true, description="The function used to model successful heap object allocation. This is only used, when pointer analysis with UFs is enabled.")
    private String successfulAllocFunctionName = "__VERIFIER_successful_alloc";
    @Option(secure=true, description="The function used to model successful heap object allocation with zeroing. This is only used, when pointer analysis with UFs is enabled.")
    private String successfulZallocFunctionName = "__VERIFIER_successful_zalloc";
    @Option(secure=true, description="Setting this to true makes memoryAllocationFunctions always return a valid pointer.")
    private boolean memoryAllocationsAlwaysSucceed = false;
    @Option(secure=true, description="Enable the option to allow detecting the allocation type by type of the LHS of the assignment, e.g. char *arr = malloc(size) is detected as char[size]")
    private boolean revealAllocationTypeFromLhs = true;
    @Option(secure=true, description="Use deferred allocation heuristic that tracks void * variables until the actual type of the allocation is figured out.")
    private boolean deferUntypedAllocations = true;
    @Option(secure=true, description="Maximum size of allocations for which all structure fields are regarded always essential, regardless of whether they were ever really used in code.")
    private int maxPreFilledAllocationSize = 0;
    @Option(secure=true, description="The default size in bytes for memory allocations when the value cannot be determined.")
    private int defaultAllocationSize = 4;
    @Option(secure=true, description="The default length for arrays when the real length cannot be determined.")
    private int defaultArrayLength = 20;
    @Option(secure=true, description="The maximum length for arrays (elements beyond this will be ignored).")
    private int maxArrayLength = 20;
    @Option(secure=true, description="Function that is used to free allocated memory.")
    private String memoryFreeFunctionName = "free";
    @Option(secure=true, description="When a string literal initializer is encountered, initialize the contents of the char array with the contents of the string literal instead of just assigning a fresh non-det address to it")
    private boolean handleStringLiteralInitializers = false;
    @Option(secure=true, description="If disabled, all implicitly initialized fields and elements are treated as non-dets")
    private boolean handleImplicitInitialization = true;

    public FormulaEncodingWithPointerAliasingOptions(Configuration config) throws InvalidConfigurationException {
        super(config);
        config.inject((Object)this, FormulaEncodingWithPointerAliasingOptions.class);
    }

    boolean hasSuperfluousParameters(String name) {
        return this.memoryAllocationFunctionsWithSuperfluousParameters.contains((Object)name);
    }

    boolean isDynamicMemoryFunction(String name) {
        return this.isSuccessfulAllocFunctionName(name) || this.isSuccessfulZallocFunctionName(name) || this.isMemoryAllocationFunction(name) || this.isMemoryAllocationFunctionWithZeroing(name) || this.isMemoryFreeFunction(name);
    }

    boolean isSuccessfulAllocFunctionName(String name) {
        return this.successfulAllocFunctionName.equals(name);
    }

    boolean isSuccessfulZallocFunctionName(String name) {
        return this.successfulZallocFunctionName.equals(name);
    }

    boolean isDynamicAllocVariableName(String name) {
        return this.isSuccessfulAllocFunctionName(name) || this.isSuccessfulZallocFunctionName(name);
    }

    String getSuccessfulAllocFunctionName() {
        return this.successfulAllocFunctionName;
    }

    String getSuccessfulZallocFunctionName() {
        return this.successfulZallocFunctionName;
    }

    boolean makeMemoryAllocationsAlwaysSucceed() {
        return this.memoryAllocationsAlwaysSucceed;
    }

    boolean revealAllocationTypeFromLHS() {
        return this.revealAllocationTypeFromLhs;
    }

    boolean deferUntypedAllocations() {
        return this.deferUntypedAllocations;
    }

    int maxPreFilledAllocationSize() {
        return this.maxPreFilledAllocationSize;
    }

    int defaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    int defaultArrayLength() {
        return this.defaultArrayLength;
    }

    int maxArrayLength() {
        return this.maxArrayLength;
    }

    boolean isMemoryFreeFunction(String name) {
        return this.memoryFreeFunctionName.equals(name);
    }

    boolean handleStringLiteralInitializers() {
        return this.handleStringLiteralInitializers;
    }

    boolean handleImplicitInitialization() {
        return this.handleImplicitInitialization;
    }
}

