/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetPattern;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;

class LvalueToPointerTargetPatternVisitor
extends DefaultCExpressionVisitor<PointerTargetPattern, UnrecognizedCCodeException> {
    private final CtoFormulaTypeHandler typeHandler;
    private final PointerTargetSetManager ptsMgr;
    private final PointerTargetSetBuilder pts;
    private final CFAEdge cfaEdge;

    LvalueToPointerTargetPatternVisitor(CtoFormulaTypeHandler pTypeHandler, PointerTargetSetManager pPtsMgr, CFAEdge pCfaEdge, PointerTargetSetBuilder pPts) {
        this.typeHandler = pTypeHandler;
        this.ptsMgr = pPtsMgr;
        this.cfaEdge = pCfaEdge;
        this.pts = pPts;
    }

    @Override
    protected PointerTargetPattern visitDefault(CExpression e) throws UnrecognizedCCodeException {
        throw new UnrecognizedCCodeException("Illegal expression in lhs", this.cfaEdge, e);
    }

    @Override
    public PointerTargetPattern visit(CArraySubscriptExpression e) throws UnrecognizedCCodeException {
        CType containerType;
        CExpression arrayExpression = e.getArrayExpression();
        PointerTargetPattern result = arrayExpression.accept(new PointerTargetEvaluatingVisitor());
        if (result == null) {
            result = PointerTargetPattern.any();
        }
        if ((containerType = CTypeUtils.simplifyType(arrayExpression.getExpressionType())) instanceof CArrayType || containerType instanceof CPointerType) {
            CType elementType;
            if (containerType instanceof CPointerType) {
                elementType = ((CPointerType)containerType).getType();
                containerType = new CArrayType(containerType.isConst(), containerType.isVolatile(), elementType, null);
            } else {
                elementType = ((CArrayType)containerType).getType();
            }
            result.shift(containerType);
            Integer index = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(e.getSubscriptExpression());
            if (index != null) {
                result.setProperOffset(index * this.typeHandler.getSizeof(elementType));
            }
            return result;
        }
        throw new UnrecognizedCCodeException("Array expression has incompatible type", this.cfaEdge, e);
    }

    @Override
    public PointerTargetPattern visit(CCastExpression e) throws UnrecognizedCCodeException {
        return e.getOperand().accept(this);
    }

    @Override
    public PointerTargetPattern visit(CFieldReference e) throws UnrecognizedCCodeException {
        CExpression ownerExpression = (e = CToFormulaConverterWithPointerAliasing.eliminateArrow(e, this.cfaEdge)).getFieldOwner();
        PointerTargetPattern result = ownerExpression.accept(this);
        if (result != null) {
            CType containerType = CTypeUtils.simplifyType(ownerExpression.getExpressionType());
            if (containerType instanceof CCompositeType) {
                assert (((CCompositeType)containerType).getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composites!";
                result.shift(containerType, this.ptsMgr.getOffset((CCompositeType)containerType, e.getFieldName()));
                return result;
            }
            throw new UnrecognizedCCodeException("Field owner expression has incompatible type", this.cfaEdge, e);
        }
        return null;
    }

    @Override
    public PointerTargetPattern visit(CIdExpression e) throws UnrecognizedCCodeException {
        CType expressionType = CTypeUtils.simplifyType(e.getExpressionType());
        String name = e.getDeclaration().getQualifiedName();
        if (!this.pts.isActualBase(name) && !CTypeUtils.containsArray(expressionType)) {
            return null;
        }
        return PointerTargetPattern.forBase(name);
    }

    @Override
    public PointerTargetPattern visit(CUnaryExpression e) throws UnrecognizedCCodeException {
        switch (e.getOperator()) {
            case AMPER: 
            case MINUS: 
            case TILDE: 
            case SIZEOF: {
                throw new UnrecognizedCCodeException("Illegal unary operator", this.cfaEdge, e);
            }
        }
        throw new UnrecognizedCCodeException("Unhandled unary operator", this.cfaEdge, e);
    }

    @Override
    public PointerTargetPattern visit(CPointerExpression e) throws UnrecognizedCCodeException {
        CExpression operand = e.getOperand();
        CType type = CTypeUtils.simplifyType(operand.getExpressionType());
        PointerTargetPattern result = e.getOperand().accept(new PointerTargetEvaluatingVisitor());
        if (type instanceof CPointerType) {
            if (result != null) {
                result.clear();
                return result;
            }
            return PointerTargetPattern.any();
        }
        if (type instanceof CArrayType) {
            if (result != null) {
                result.shift(type, 0);
                return result;
            }
            return PointerTargetPattern.any();
        }
        throw new UnrecognizedCCodeException("Dereferencing non-pointer expression", this.cfaEdge, e);
    }

    private static Integer tryEvaluateExpression(CExpression e) {
        if (e instanceof CIntegerLiteralExpression) {
            return ((CIntegerLiteralExpression)e).getValue().intValue();
        }
        return null;
    }

    private class PointerTargetEvaluatingVisitor
    extends DefaultCExpressionVisitor<PointerTargetPattern, UnrecognizedCCodeException> {
        private PointerTargetEvaluatingVisitor() {
        }

        @Override
        protected PointerTargetPattern visitDefault(CExpression e) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public PointerTargetPattern visit(CBinaryExpression e) throws UnrecognizedCCodeException {
            CExpression operand1 = e.getOperand1();
            CExpression operand2 = e.getOperand2();
            switch (e.getOperator()) {
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: 
                case DIVIDE: 
                case EQUALS: 
                case GREATER_EQUAL: 
                case GREATER_THAN: 
                case LESS_EQUAL: 
                case LESS_THAN: 
                case MODULO: 
                case MULTIPLY: 
                case NOT_EQUALS: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: {
                    return null;
                }
                case MINUS: {
                    PointerTargetPattern result = operand1.accept(this);
                    if (result != null) {
                        Integer offset = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(operand2);
                        Integer oldOffset = result.getProperOffset();
                        if (offset != null && oldOffset != null && offset < oldOffset) {
                            result.setProperOffset(oldOffset - offset);
                        } else {
                            result.retainBase();
                        }
                        return result;
                    }
                    return null;
                }
                case PLUS: {
                    Integer offset;
                    PointerTargetPattern result = operand1.accept(this);
                    if (result == null) {
                        result = operand2.accept(this);
                        offset = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(operand1);
                    } else {
                        offset = LvalueToPointerTargetPatternVisitor.tryEvaluateExpression(operand2);
                    }
                    if (result != null) {
                        Integer remaining = result.getRemainingOffset(LvalueToPointerTargetPatternVisitor.this.ptsMgr);
                        if (offset != null && remaining != null && offset < remaining) {
                            assert (result.getProperOffset() != null) : "Unexpected nondet proper offset";
                            result.setProperOffset(result.getProperOffset() + offset);
                        } else {
                            result.retainBase();
                        }
                        return result;
                    }
                    return null;
                }
            }
            throw new UnrecognizedCCodeException("Unhandled binary operator", LvalueToPointerTargetPatternVisitor.this.cfaEdge, e);
        }

        @Override
        public PointerTargetPattern visit(CCastExpression e) throws UnrecognizedCCodeException {
            return e.getOperand().accept(this);
        }

        @Override
        public PointerTargetPattern visit(CIdExpression e) throws UnrecognizedCCodeException {
            CType expressionType = CTypeUtils.simplifyType(e.getExpressionType());
            String name = e.getDeclaration().getQualifiedName();
            if (!LvalueToPointerTargetPatternVisitor.this.pts.isBase(name, expressionType) && !CTypeUtils.containsArray(expressionType)) {
                return null;
            }
            return PointerTargetPattern.forBase(name);
        }

        @Override
        public PointerTargetPattern visit(CUnaryExpression e) throws UnrecognizedCCodeException {
            CExpression operand = e.getOperand();
            switch (e.getOperator()) {
                case AMPER: {
                    return operand.accept(LvalueToPointerTargetPatternVisitor.this);
                }
                case MINUS: 
                case TILDE: {
                    return null;
                }
                case SIZEOF: {
                    throw new UnrecognizedCCodeException("Illegal unary operator", LvalueToPointerTargetPatternVisitor.this.cfaEdge, e);
                }
            }
            throw new UnrecognizedCCodeException("Unrecognized unary operator", LvalueToPointerTargetPatternVisitor.this.cfaEdge, e);
        }

        @Override
        public PointerTargetPattern visit(CPointerExpression e) throws UnrecognizedCCodeException {
            return null;
        }
    }
}

