/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import java.io.Serializable;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

public class PointerTarget
implements Serializable {
    final String base;
    final CType containerType;
    final int properOffset;
    final int containerOffset;
    private static final long serialVersionUID = -1258065871533686442L;

    PointerTarget(String base) {
        this.base = base;
        this.containerType = null;
        this.properOffset = 0;
        this.containerOffset = 0;
    }

    PointerTarget(String base, CType containerType, int properOffset) {
        this.base = base;
        this.containerType = containerType;
        this.properOffset = properOffset;
        this.containerOffset = 0;
    }

    PointerTarget(String base, CType containerType, int properOffset, int containerOffset) {
        this.base = base;
        this.containerType = containerType;
        this.properOffset = properOffset;
        this.containerOffset = containerOffset;
    }

    public String getBase() {
        return this.base;
    }

    public String getBaseName() {
        return PointerTargetSet.getBaseName(this.base);
    }

    public int getOffset() {
        return this.containerOffset + this.properOffset;
    }

    public int getProperOffset() {
        assert (this.containerType != null) : "The target's offset is ill-defined";
        return this.properOffset;
    }

    public boolean isBase() {
        return this.containerType == null;
    }

    public CType getContainerType() {
        return this.containerType;
    }

    public int getContainerOffset() {
        assert (this.containerType != null) : "The target's container offset is ill-defined";
        return this.containerOffset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PointerTarget)) {
            return false;
        }
        PointerTarget o = (PointerTarget)other;
        return this.properOffset == o.properOffset && this.containerOffset == o.containerOffset && this.base.equals(o.base) && (this.containerType != null ? o.containerType != null && this.containerType.getCanonicalType().equals(o.containerType.getCanonicalType()) : o.containerType == null);
    }

    public int hashCode() {
        return 31 * this.base.hashCode() + 17 * this.containerOffset + this.properOffset;
    }
}

