/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Predicate;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.LvalueToPointerTargetPatternVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;

class PointerTargetPattern
implements Serializable,
Predicate<PointerTarget> {
    private String base = null;
    private CType containerType = null;
    private Integer properOffset = null;
    private Integer containerOffset = null;
    private boolean matchRange = false;
    private static final long serialVersionUID = -2918663736813010025L;

    private PointerTargetPattern() {
        this.matchRange = false;
    }

    private PointerTargetPattern(String base) {
        this.base = base;
        this.containerOffset = 0;
        this.properOffset = 0;
        this.matchRange = false;
    }

    public static PointerTargetPattern any() {
        return new PointerTargetPattern();
    }

    public static PointerTargetPattern forBase(String base) {
        return new PointerTargetPattern(base);
    }

    public static PointerTargetPattern forLeftHandSide(CLeftHandSide lhs, CtoFormulaTypeHandler pTypeHandler, PointerTargetSetManager pPtsMgr, CFAEdge pCfaEdge, PointerTargetSetBuilder pPts) throws UnrecognizedCCodeException {
        LvalueToPointerTargetPatternVisitor v = new LvalueToPointerTargetPatternVisitor(pTypeHandler, pPtsMgr, pCfaEdge, pPts);
        return lhs.accept(v);
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setRange(int startOffset, int size) {
        this.containerOffset = startOffset;
        this.properOffset = startOffset + size;
        this.matchRange = true;
        this.containerType = null;
    }

    public void setRange(int size) {
        assert (this.containerOffset != null && this.properOffset != null) : "Strating address is inexact";
        PointerTargetPattern pointerTargetPattern = this;
        pointerTargetPattern.containerOffset = pointerTargetPattern.containerOffset + this.properOffset;
        this.properOffset = this.containerOffset + size;
        this.matchRange = true;
        this.containerType = null;
    }

    void setProperOffset(int properOffset) {
        assert (!this.matchRange) : "Contradiction in target pattern: properOffset";
        this.properOffset = properOffset;
    }

    public Integer getProperOffset() {
        assert (!this.matchRange) : "Contradiction in target pattern: properOffset";
        return this.properOffset;
    }

    public Integer getRemainingOffset(PointerTargetSetManager ptsMgr) {
        assert (!this.matchRange) : "Contradiction in target pattern: remaining offset";
        if (this.containerType != null && this.containerOffset != null && this.properOffset != null) {
            return ptsMgr.getSize(this.containerType) - this.properOffset;
        }
        return null;
    }

    void shift(CType containerType) {
        assert (!this.matchRange) : "Contradiction in target pattern: shift";
        this.containerType = containerType;
        if (this.containerOffset != null) {
            this.containerOffset = this.properOffset != null ? Integer.valueOf(this.containerOffset + this.properOffset) : null;
        }
        this.properOffset = null;
    }

    void shift(CType containerType, int properOffset) {
        this.shift(containerType);
        this.properOffset = properOffset;
    }

    void retainBase() {
        assert (!this.matchRange) : "Contradiction in target pattern: retainBase";
        this.containerType = null;
        this.properOffset = null;
        this.containerOffset = null;
    }

    void clear() {
        assert (!this.matchRange) : "Contradiction in target pattern: clear";
        this.base = null;
        this.containerType = null;
        this.properOffset = null;
        this.containerOffset = null;
    }

    public boolean matches(@Nonnull PointerTarget target) {
        if (!this.matchRange) {
            if (this.properOffset != null && this.properOffset != target.properOffset) {
                return false;
            }
            if (this.containerOffset != null && this.containerOffset != target.containerOffset) {
                return false;
            }
            if (this.base != null && !this.base.equals(target.base)) {
                return false;
            }
            if (this.containerType != null && !this.containerType.equals(target.containerType)) {
                if (!(this.containerType instanceof CArrayType) || !(target.containerType instanceof CArrayType)) {
                    return false;
                }
                return ((CArrayType)this.containerType).getType().equals(((CArrayType)target.containerType).getType());
            }
        } else {
            int offset = target.containerOffset + target.properOffset;
            if (offset < this.containerOffset || offset >= this.properOffset) {
                return false;
            }
            if (this.base != null && !this.base.equals(target.base)) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public boolean apply(PointerTarget pInput) {
        return this.matches(pInput);
    }

    public boolean isExact() {
        return this.base != null && this.containerOffset != null && this.properOffset != null;
    }

    public boolean isSemiexact() {
        return this.containerOffset != null && this.properOffset != null;
    }
}

