/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocationPool;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;

@Immutable
public final class PointerTargetSet
implements Serializable {
    private static final PointerTargetSet EMPTY_INSTANCE = new PointerTargetSet((PersistentSortedMap<String, CType>)PathCopyingPersistentTreeMap.of(), null, (PersistentSortedMap<CompositeField, Boolean>)PathCopyingPersistentTreeMap.of(), (PersistentSortedMap<String, DeferredAllocationPool>)PathCopyingPersistentTreeMap.of(), (PersistentSortedMap<String, PersistentList<PointerTarget>>)PathCopyingPersistentTreeMap.of());
    private static final Joiner joiner = Joiner.on((String)" ");
    final PersistentSortedMap<String, CType> bases;
    final String lastBase;
    final PersistentSortedMap<CompositeField, Boolean> fields;
    final PersistentSortedMap<String, DeferredAllocationPool> deferredAllocations;
    final PersistentSortedMap<String, PersistentList<PointerTarget>> targets;
    private static final String BASE_PREFIX = "__ADDRESS_OF_";
    private static final long serialVersionUID = 2102505458322248624L;

    public static String getBaseName(String name) {
        return BASE_PREFIX + name;
    }

    static boolean isBaseName(String name) {
        return name.startsWith(BASE_PREFIX);
    }

    static String getBase(String baseName) {
        return baseName.replaceFirst(BASE_PREFIX, "");
    }

    public PersistentList<PointerTarget> getAllTargets(CType type) {
        return (PersistentList)MoreObjects.firstNonNull((Object)this.targets.get((Object)CTypeUtils.typeToString(type)), (Object)PersistentLinkedList.of());
    }

    public static final PointerTargetSet emptyPointerTargetSet() {
        return EMPTY_INSTANCE;
    }

    public boolean isEmpty() {
        return this.bases.isEmpty() && this.fields.isEmpty() && this.lastBase == null && this.deferredAllocations.isEmpty();
    }

    public String toString() {
        return joiner.join((Iterable)this.bases.entrySet()) + " " + joiner.join((Iterable)this.fields.entrySet());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bases.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + Objects.hashCode(this.lastBase);
        result = 31 * result + this.deferredAllocations.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointerTargetSet)) {
            return false;
        }
        PointerTargetSet other = (PointerTargetSet)obj;
        return Objects.equals(this.lastBase, other.lastBase) && this.bases.equals(other.bases) && this.fields.equals(other.fields) && this.deferredAllocations.equals(other.deferredAllocations);
    }

    PointerTargetSet(PersistentSortedMap<String, CType> bases, String lastBase, PersistentSortedMap<CompositeField, Boolean> fields, PersistentSortedMap<String, DeferredAllocationPool> deferredAllocations, PersistentSortedMap<String, PersistentList<PointerTarget>> targets) {
        this.bases = bases;
        this.lastBase = lastBase;
        this.fields = fields;
        this.deferredAllocations = deferredAllocations;
        this.targets = targets;
        if (this.isEmpty()) assert (targets.isEmpty());
    }

    @Immutable
    public static class CompositeField
    implements Comparable<CompositeField>,
    Serializable {
        private static final long serialVersionUID = -5194535211223682619L;
        private final String compositeType;
        private final String fieldName;

        private CompositeField(String compositeType, String fieldName) {
            this.compositeType = compositeType;
            this.fieldName = fieldName;
        }

        public static CompositeField of(@Nonnull String compositeType, @Nonnull String fieldName) {
            return new CompositeField(compositeType, fieldName);
        }

        public String toString() {
            return this.compositeType + "." + this.fieldName;
        }

        @Override
        public int compareTo(CompositeField other) {
            int result = this.compositeType.compareTo(other.compositeType);
            if (result != 0) {
                return result;
            }
            return this.fieldName.compareTo(other.fieldName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompositeField)) {
                return false;
            }
            CompositeField other = (CompositeField)obj;
            return this.compositeType.equals(other.compositeType) && this.fieldName.equals(other.fieldName);
        }

        public int hashCode() {
            return this.compositeType.hashCode() * 17 + this.fieldName.hashCode();
        }
    }
}

