/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocationPool;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetPattern;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetManager;

public interface PointerTargetSetBuilder {
    public BooleanFormula prepareBase(String var1, CType var2);

    public void shareBase(String var1, CType var2);

    public BooleanFormula addBase(String var1, CType var2);

    public boolean tracksField(CCompositeType var1, String var2);

    public boolean addField(CCompositeType var1, String var2);

    public void addEssentialFields(List<Pair<CCompositeType, String>> var1);

    public void addTemporaryDeferredAllocation(boolean var1, CIntegerLiteralExpression var2, String var3);

    public void addDeferredAllocationPointer(String var1, String var2);

    public boolean removeDeferredAllocatinPointer(String var1);

    public DeferredAllocationPool removeDeferredAllocation(String var1);

    public SortedSet<String> getDeferredAllocationVariables();

    public boolean isTemporaryDeferredAllocationPointer(String var1);

    public boolean isDeferredAllocationPointer(String var1);

    public boolean isActualBase(String var1);

    public boolean isPreparedBase(String var1);

    public boolean isBase(String var1, CType var2);

    public SortedSet<String> getAllBases();

    public PersistentList<PointerTarget> getAllTargets(CType var1);

    public Iterable<PointerTarget> getMatchingTargets(CType var1, PointerTargetPattern var2);

    public Iterable<PointerTarget> getSpuriousTargets(CType var1, PointerTargetPattern var2);

    public PointerTargetSet build();

    public static enum DummyPointerTargetSetBuilder implements PointerTargetSetBuilder
    {
        INSTANCE;


        @Override
        public BooleanFormula prepareBase(String pName, CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shareBase(String pName, CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BooleanFormula addBase(String pName, CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tracksField(CCompositeType pCompositeType, String pFieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addField(CCompositeType pComposite, String pFieldName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addEssentialFields(List<Pair<CCompositeType, String>> pFields) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addTemporaryDeferredAllocation(boolean pIsZeroing, CIntegerLiteralExpression pSize, String pBaseVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDeferredAllocationPointer(String pNewPointerVariable, String pOriginalPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeDeferredAllocatinPointer(String pOldPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DeferredAllocationPool removeDeferredAllocation(String pAllocatedPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<String> getDeferredAllocationVariables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTemporaryDeferredAllocationPointer(String pPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDeferredAllocationPointer(String pPointerVariable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActualBase(String pName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPreparedBase(String pName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBase(String pName, CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<String> getAllBases() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PersistentList<PointerTarget> getAllTargets(CType pType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<PointerTarget> getMatchingTargets(CType pType, PointerTargetPattern pPattern) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterable<PointerTarget> getSpuriousTargets(CType pType, PointerTargetPattern pPattern) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PointerTargetSet build() {
            return PointerTargetSet.emptyPointerTargetSet();
        }
    }

    public static final class RealPointerTargetSetBuilder
    implements PointerTargetSetBuilder {
        private final FormulaManagerView formulaManager;
        private final PointerTargetSetManager ptsMgr;
        private final FormulaEncodingWithPointerAliasingOptions options;
        private PersistentSortedMap<String, CType> bases;
        private String lastBase;
        private PersistentSortedMap<PointerTargetSet.CompositeField, Boolean> fields;
        private PersistentSortedMap<String, DeferredAllocationPool> deferredAllocations;
        private PersistentSortedMap<String, PersistentList<PointerTarget>> targets;
        private final Predicate<Pair<CCompositeType, String>> isNewFieldPredicate = new Predicate<Pair<CCompositeType, String>>(){

            public boolean apply(Pair<CCompositeType, String> field) {
                String type = CTypeUtils.typeToString((CType)field.getFirst());
                PointerTargetSet.CompositeField compositeField = PointerTargetSet.CompositeField.of(type, (String)field.getSecond());
                return !RealPointerTargetSetBuilder.this.fields.containsKey((Object)compositeField);
            }
        };
        private static final Function<Pair<CCompositeType, String>, Triple<CCompositeType, String, CType>> typeFieldFunction = new Function<Pair<CCompositeType, String>, Triple<CCompositeType, String, CType>>(){

            public Triple<CCompositeType, String, CType> apply(Pair<CCompositeType, String> field) {
                CCompositeType fieldComposite = (CCompositeType)field.getFirst();
                String fieldName = (String)field.getSecond();
                for (CCompositeType.CCompositeTypeMemberDeclaration declaration : fieldComposite.getMembers()) {
                    if (!declaration.getName().equals(fieldName)) continue;
                    return Triple.of((Object)fieldComposite, (Object)fieldName, (Object)CTypeUtils.simplifyType(declaration.getType()));
                }
                throw new AssertionError((Object)("Tried to start tracking for a non-existent field " + fieldName + " in composite type " + fieldComposite));
            }
        };
        private static final Comparator<Triple<CCompositeType, String, CType>> simpleTypedFieldsFirstComparator = new Comparator<Triple<CCompositeType, String, CType>>(){

            @Override
            public int compare(Triple<CCompositeType, String, CType> field1, Triple<CCompositeType, String, CType> field2) {
                int isField1Simple = field1.getThird() instanceof CCompositeType ? 1 : 0;
                int isField2Simple = field2.getThird() instanceof CCompositeType ? 1 : 0;
                return isField1Simple - isField2Simple;
            }
        };

        RealPointerTargetSetBuilder(PointerTargetSet pointerTargetSet, FormulaManagerView pFormulaManager, PointerTargetSetManager pPtsMgr, FormulaEncodingWithPointerAliasingOptions pOptions) {
            this.bases = pointerTargetSet.bases;
            this.lastBase = pointerTargetSet.lastBase;
            this.fields = pointerTargetSet.fields;
            this.deferredAllocations = pointerTargetSet.deferredAllocations;
            this.targets = pointerTargetSet.targets;
            this.formulaManager = pFormulaManager;
            this.ptsMgr = pPtsMgr;
            this.options = pOptions;
        }

        private void addTargets(String name, CType type) {
            this.targets = this.ptsMgr.addToTargets(name, type, null, 0, 0, this.targets, this.fields);
        }

        @Override
        public BooleanFormula prepareBase(String name, CType type) {
            type = CTypeUtils.simplifyType(type);
            if (this.bases.containsKey((Object)name)) {
                return this.formulaManager.getBooleanFormulaManager().makeBoolean(true);
            }
            this.bases = this.bases.putAndCopy((Object)name, (Object)type);
            BooleanFormula nextInequality = this.ptsMgr.getNextBaseAddressInequality(name, this.bases, this.lastBase);
            this.bases = this.bases.putAndCopy((Object)name, (Object)PointerTargetSetManager.getFakeBaseType(this.ptsMgr.getSize(type)));
            this.lastBase = name;
            return nextInequality;
        }

        @Override
        public void shareBase(String name, CType type) {
            if ((type = CTypeUtils.simplifyType(type)) instanceof CElaboratedType) {
                assert (((CElaboratedType)type).getRealType() == null) : "Elaborated type " + type + " that was not simplified but could have been.";
            } else {
                this.addTargets(name, type);
            }
            this.bases = this.bases.putAndCopy((Object)name, (Object)type);
        }

        @Override
        public BooleanFormula addBase(String name, CType type) {
            type = CTypeUtils.simplifyType(type);
            if (this.bases.containsKey((Object)name)) {
                return this.formulaManager.getBooleanFormulaManager().makeBoolean(true);
            }
            this.addTargets(name, type);
            this.bases = this.bases.putAndCopy((Object)name, (Object)type);
            BooleanFormula nextInequality = this.ptsMgr.getNextBaseAddressInequality(name, this.bases, this.lastBase);
            this.lastBase = name;
            return nextInequality;
        }

        @Override
        public boolean tracksField(CCompositeType compositeType, String fieldName) {
            return this.fields.containsKey((Object)PointerTargetSet.CompositeField.of(CTypeUtils.typeToString(compositeType), fieldName));
        }

        private void addTargets(String base, CType currentType, @Nullable CType containerType, int properOffset, int containerOffset, String composite, String memberName) {
            block8: {
                CType cType;
                block9: {
                    cType = CTypeUtils.simplifyType(currentType);
                    if (cType instanceof CElaboratedType) break block8;
                    if (!(cType instanceof CArrayType)) break block9;
                    CArrayType arrayType = (CArrayType)cType;
                    Integer length = CTypeUtils.getArrayLength(arrayType);
                    if (length == null) {
                        length = this.options.defaultArrayLength();
                    } else if (length > this.options.maxArrayLength()) {
                        length = this.options.maxArrayLength();
                    }
                    int offset = 0;
                    for (int i = 0; i < length; ++i) {
                        this.addTargets(base, arrayType.getType(), arrayType, offset, containerOffset + properOffset, composite, memberName);
                        offset += this.ptsMgr.getSize(arrayType.getType());
                    }
                    break block8;
                }
                if (!(cType instanceof CCompositeType)) break block8;
                CCompositeType compositeType = (CCompositeType)cType;
                assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
                String type = CTypeUtils.typeToString(compositeType);
                int offset = 0;
                boolean isTargetComposite = type.equals(composite);
                for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                    if (this.fields.containsKey((Object)PointerTargetSet.CompositeField.of(type, memberDeclaration.getName()))) {
                        this.addTargets(base, memberDeclaration.getType(), compositeType, offset, containerOffset + properOffset, composite, memberName);
                    }
                    if (isTargetComposite && memberDeclaration.getName().equals(memberName)) {
                        this.targets = this.ptsMgr.addToTargets(base, memberDeclaration.getType(), compositeType, offset, containerOffset + properOffset, this.targets, this.fields);
                    }
                    if (compositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
                    offset += this.ptsMgr.getSize(memberDeclaration.getType());
                }
            }
        }

        @Override
        public boolean addField(CCompositeType composite, String fieldName) {
            String type = CTypeUtils.typeToString(composite);
            PointerTargetSet.CompositeField field = PointerTargetSet.CompositeField.of(type, fieldName);
            if (this.fields.containsKey((Object)field)) {
                return true;
            }
            PersistentSortedMap<String, PersistentList<PointerTarget>> oldTargets = this.targets;
            for (Map.Entry baseEntry : this.bases.entrySet()) {
                this.addTargets((String)baseEntry.getKey(), (CType)baseEntry.getValue(), null, 0, 0, type, fieldName);
            }
            this.fields = this.fields.putAndCopy((Object)field, (Object)true);
            return oldTargets != this.targets;
        }

        private void shallowRemoveField(CCompositeType composite, String fieldName) {
            String type = CTypeUtils.typeToString(composite);
            PointerTargetSet.CompositeField field = PointerTargetSet.CompositeField.of(type, fieldName);
            this.fields = this.fields.removeAndCopy((Object)field);
        }

        @Override
        public void addEssentialFields(List<Pair<CCompositeType, String>> fields) {
            ImmutableList typedFields = FluentIterable.from(fields).filter(this.isNewFieldPredicate).transform(typeFieldFunction).toSortedList(simpleTypedFieldsFirstComparator);
            if (typedFields.isEmpty()) {
                return;
            }
            HashSet<Triple> done = new HashSet<Triple>();
            ArrayList<Triple> currentChain = new ArrayList<Triple>();
            for (Triple field : typedFields) {
                if (done.contains(field)) continue;
                currentChain.clear();
                Triple current = field;
                block1: do {
                    currentChain.add(current);
                    for (Triple parentField : typedFields) {
                        if (done.contains(parentField) || !((CType)parentField.getThird()).equals(current.getFirst())) continue;
                        current = parentField;
                        continue block1;
                    }
                } while (current != currentChain.get(currentChain.size() - 1));
                boolean useful = false;
                for (int i = currentChain.size() - 1; i >= 0; --i) {
                    Triple f = (Triple)currentChain.get(i);
                    done.add(f);
                    useful |= this.addField((CCompositeType)f.getFirst(), (String)f.getSecond());
                }
                if (useful) continue;
                for (Triple f : currentChain) {
                    this.shallowRemoveField((CCompositeType)f.getFirst(), (String)f.getSecond());
                }
            }
        }

        private void addDeferredAllocation(String pointerVariable, boolean isZeroing, CIntegerLiteralExpression size, String baseVariable) {
            this.deferredAllocations = this.deferredAllocations.putAndCopy((Object)pointerVariable, (Object)new DeferredAllocationPool(pointerVariable, isZeroing, size, baseVariable));
        }

        @Override
        public void addTemporaryDeferredAllocation(boolean isZeroing, CIntegerLiteralExpression size, String baseVariable) {
            this.addDeferredAllocation(baseVariable, isZeroing, size, baseVariable);
        }

        @Override
        public void addDeferredAllocationPointer(String newPointerVariable, String originalPointerVariable) {
            DeferredAllocationPool newDeferredAllocationPool = ((DeferredAllocationPool)this.deferredAllocations.get((Object)originalPointerVariable)).addPointerVariable(newPointerVariable);
            for (String pointerVariable : newDeferredAllocationPool.getPointerVariables()) {
                this.deferredAllocations = this.deferredAllocations.putAndCopy((Object)pointerVariable, (Object)newDeferredAllocationPool);
            }
            assert (this.deferredAllocations.get((Object)newPointerVariable) == newDeferredAllocationPool);
        }

        @Override
        public boolean removeDeferredAllocatinPointer(String oldPointerVariable) {
            DeferredAllocationPool newDeferredAllocationPool = ((DeferredAllocationPool)this.deferredAllocations.get((Object)oldPointerVariable)).removePointerVariable(oldPointerVariable);
            this.deferredAllocations = this.deferredAllocations.removeAndCopy((Object)oldPointerVariable);
            if (!newDeferredAllocationPool.getPointerVariables().isEmpty()) {
                for (String pointerVariable : newDeferredAllocationPool.getPointerVariables()) {
                    this.deferredAllocations = this.deferredAllocations.putAndCopy((Object)pointerVariable, (Object)newDeferredAllocationPool);
                }
                return false;
            }
            return true;
        }

        @Override
        public DeferredAllocationPool removeDeferredAllocation(String allocatedPointerVariable) {
            DeferredAllocationPool deferredAllocationPool = (DeferredAllocationPool)this.deferredAllocations.get((Object)allocatedPointerVariable);
            for (String pointerVariable : deferredAllocationPool.getPointerVariables()) {
                this.deferredAllocations = this.deferredAllocations.removeAndCopy((Object)pointerVariable);
            }
            return deferredAllocationPool;
        }

        @Override
        public SortedSet<String> getDeferredAllocationVariables() {
            return this.deferredAllocations.keySet();
        }

        @Override
        public boolean isTemporaryDeferredAllocationPointer(String pointerVariable) {
            DeferredAllocationPool deferredAllocationPool = (DeferredAllocationPool)this.deferredAllocations.get((Object)pointerVariable);
            assert (deferredAllocationPool == null || deferredAllocationPool.getBaseVariables().size() >= 1) : "Inconsistent deferred alloction pool: no bases";
            return deferredAllocationPool != null && ((String)deferredAllocationPool.getBaseVariables().get(0)).equals(pointerVariable);
        }

        @Override
        public boolean isDeferredAllocationPointer(String pointerVariable) {
            return this.deferredAllocations.containsKey((Object)pointerVariable);
        }

        @Override
        public boolean isActualBase(String name) {
            return this.bases.containsKey((Object)name) && !PointerTargetSetManager.isFakeBaseType((CType)this.bases.get((Object)name));
        }

        @Override
        public boolean isPreparedBase(String name) {
            return this.bases.containsKey((Object)name);
        }

        @Override
        public boolean isBase(String name, CType type) {
            type = CTypeUtils.simplifyType(type);
            CType baseType = (CType)this.bases.get((Object)name);
            return baseType != null && baseType.equals(type);
        }

        @Override
        public SortedSet<String> getAllBases() {
            return this.bases.keySet();
        }

        @Override
        public PersistentList<PointerTarget> getAllTargets(CType type) {
            return (PersistentList)MoreObjects.firstNonNull((Object)this.targets.get((Object)CTypeUtils.typeToString(type)), (Object)PersistentLinkedList.of());
        }

        @Override
        public Iterable<PointerTarget> getMatchingTargets(CType type, PointerTargetPattern pattern) {
            return FluentIterable.from(this.getAllTargets(type)).filter((Predicate)pattern);
        }

        @Override
        public Iterable<PointerTarget> getSpuriousTargets(CType type, PointerTargetPattern pattern) {
            return FluentIterable.from(this.getAllTargets(type)).filter(Predicates.not((Predicate)pattern));
        }

        @Override
        public PointerTargetSet build() {
            PointerTargetSet result = new PointerTargetSet(this.bases, this.lastBase, this.fields, this.deferredAllocations, this.targets);
            if (result.isEmpty()) {
                return PointerTargetSet.emptyPointerTargetSet();
            }
            return result;
        }
    }
}

