/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.collect.PersistentLinkedList;
import org.sosy_lab.common.collect.PersistentList;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.common.collect.PersistentSortedMaps;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FunctionFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CToFormulaConverterWithPointerAliasing;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DeferredAllocationPool;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.DynamicMemoryHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTarget;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSetBuilder;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.TypeHandlerWithPointerAliasing;

public class PointerTargetSetManager {
    private static final String UNITED_BASE_UNION_TAG_PREFIX = "__VERIFIER_base_union_of_";
    private static final String UNITED_BASE_FIELD_NAME_PREFIX = "__VERIFIER_united_base_field";
    private static final String FAKE_ALLOC_FUNCTION_NAME = "__VERIFIER_fake_alloc";
    private final ShutdownNotifier shutdownNotifier;
    private final FormulaEncodingWithPointerAliasingOptions options;
    private final FormulaManagerView formulaManager;
    private final BooleanFormulaManagerView bfmgr;
    private final FunctionFormulaManagerView ffmgr;
    private final TypeHandlerWithPointerAliasing typeHandler;

    static final CType getFakeBaseType(int size) {
        return CTypeUtils.simplifyType(new CArrayType(false, false, CVoidType.VOID, new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.SIGNED_CHAR, BigInteger.valueOf(size))));
    }

    static final boolean isFakeBaseType(CType type) {
        return type instanceof CArrayType && ((CArrayType)type).getType() instanceof CVoidType;
    }

    private static final String getUnitedFieldBaseName(int index) {
        return UNITED_BASE_FIELD_NAME_PREFIX + index;
    }

    public PointerTargetSetManager(FormulaEncodingWithPointerAliasingOptions pOptions, FormulaManagerView pFormulaManager, TypeHandlerWithPointerAliasing pTypeHandler, ShutdownNotifier pShutdownNotifier) {
        this.options = pOptions;
        this.formulaManager = pFormulaManager;
        this.bfmgr = this.formulaManager.getBooleanFormulaManager();
        this.ffmgr = this.formulaManager.getFunctionFormulaManager();
        this.typeHandler = pTypeHandler;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public PathFormulaManagerImpl.MergeResult<PointerTargetSet> mergePointerTargetSets(PointerTargetSet pts1, PointerTargetSet pts2, SSAMap resultSSA) throws InterruptedException {
        BooleanFormula basesMergeFormula;
        String lastBase;
        if (pts1.isEmpty() && pts2.isEmpty()) {
            return PathFormulaManagerImpl.MergeResult.trivial(PointerTargetSet.emptyPointerTargetSet(), this.bfmgr);
        }
        Triple mergedBases = PersistentSortedMaps.mergeWithKeyDifferences(pts1.bases, pts2.bases, (PersistentSortedMaps.MergeConflictHandler)BaseUnitingConflictHandler.INSTANCE);
        this.shutdownNotifier.shutdownIfNecessary();
        Triple mergedFields = PersistentSortedMaps.mergeWithKeyDifferences(pts1.fields, pts2.fields, (PersistentSortedMaps.MergeConflictHandler)PersistentSortedMaps.getExceptionMergeConflictHandler());
        this.shutdownNotifier.shutdownIfNecessary();
        PersistentSortedMap<String, PersistentList<PointerTarget>> mergedTargets = PersistentSortedMaps.merge(pts1.targets, pts2.targets, PointerTargetSetManager.mergeOnConflict());
        this.shutdownNotifier.shutdownIfNecessary();
        mergedTargets = this.addAllTargets(mergedTargets, (PersistentSortedMap<String, CType>)((PersistentSortedMap)mergedBases.getSecond()), (PersistentSortedMap<PointerTargetSet.CompositeField, Boolean>)((PersistentSortedMap)mergedFields.getFirst()));
        mergedTargets = this.addAllTargets(mergedTargets, (PersistentSortedMap<String, CType>)((PersistentSortedMap)mergedBases.getFirst()), (PersistentSortedMap<PointerTargetSet.CompositeField, Boolean>)((PersistentSortedMap)mergedFields.getSecond()));
        PersistentSortedMap<String, DeferredAllocationPool> mergedDeferredAllocations = this.mergeDeferredAllocationPools(pts1, pts2);
        this.shutdownNotifier.shutdownIfNecessary();
        if (pts1.lastBase == null && pts2.lastBase == null || pts1.lastBase != null && (pts2.lastBase == null || pts1.lastBase.equals(pts2.lastBase))) {
            lastBase = pts1.lastBase;
            basesMergeFormula = this.formulaManager.getBooleanFormulaManager().makeBoolean(true);
        } else if (pts1.lastBase == null && pts2.lastBase != null) {
            lastBase = pts2.lastBase;
            basesMergeFormula = this.formulaManager.getBooleanFormulaManager().makeBoolean(true);
        } else {
            CType fakeBaseType = PointerTargetSetManager.getFakeBaseType(0);
            String fakeBaseName = DynamicMemoryHandler.makeAllocVariableName(FAKE_ALLOC_FUNCTION_NAME, fakeBaseType);
            mergedBases = Triple.of((Object)mergedBases.getFirst(), (Object)mergedBases.getSecond(), (Object)((PersistentSortedMap)mergedBases.getThird()).putAndCopy((Object)fakeBaseName, (Object)fakeBaseType));
            lastBase = fakeBaseName;
            basesMergeFormula = this.formulaManager.makeAnd(this.getNextBaseAddressInequality(fakeBaseName, pts1.bases, pts1.lastBase), this.getNextBaseAddressInequality(fakeBaseName, pts2.bases, pts2.lastBase));
        }
        PointerTargetSet resultPTS = new PointerTargetSet((PersistentSortedMap<String, CType>)((PersistentSortedMap)mergedBases.getThird()), lastBase, (PersistentSortedMap<PointerTargetSet.CompositeField, Boolean>)((PersistentSortedMap)mergedFields.getThird()), mergedDeferredAllocations, mergedTargets);
        ArrayList<Pair<CCompositeType, String>> sharedFields = new ArrayList<Pair<CCompositeType, String>>();
        BooleanFormula mergeFormula2 = this.makeSharingConstraints((PersistentSortedMap<String, CType>)((PersistentSortedMap)mergedBases.getFirst()), sharedFields, resultSSA, pts2);
        BooleanFormula mergeFormula1 = this.makeSharingConstraints((PersistentSortedMap<String, CType>)((PersistentSortedMap)mergedBases.getSecond()), sharedFields, resultSSA, pts1);
        if (!sharedFields.isEmpty()) {
            PointerTargetSetBuilder.RealPointerTargetSetBuilder resultPTSBuilder = new PointerTargetSetBuilder.RealPointerTargetSetBuilder(resultPTS, this.formulaManager, this, this.options);
            for (Pair pair : sharedFields) {
                resultPTSBuilder.addField((CCompositeType)pair.getFirst(), (String)pair.getSecond());
            }
            resultPTS = resultPTSBuilder.build();
        }
        return new PathFormulaManagerImpl.MergeResult<PointerTargetSet>(resultPTS, mergeFormula1, mergeFormula2, basesMergeFormula);
    }

    private PersistentSortedMap<String, DeferredAllocationPool> mergeDeferredAllocationPools(PointerTargetSet pts1, PointerTargetSet pts2) {
        final HashMap mergedDeferredAllocationPools = new HashMap();
        PersistentSortedMaps.MergeConflictHandler<String, DeferredAllocationPool> deferredAllocationMergingConflictHandler = new PersistentSortedMaps.MergeConflictHandler<String, DeferredAllocationPool>(){

            public DeferredAllocationPool resolveConflict(String key, DeferredAllocationPool a, DeferredAllocationPool b) {
                DeferredAllocationPool result = a.mergeWith(b);
                DeferredAllocationPool oldResult = (DeferredAllocationPool)mergedDeferredAllocationPools.get(result);
                if (oldResult == null) {
                    mergedDeferredAllocationPools.put(result, result);
                    return result;
                }
                DeferredAllocationPool newResult = oldResult.mergeWith(result);
                mergedDeferredAllocationPools.put(newResult, newResult);
                return newResult;
            }
        };
        PersistentSortedMap mergedDeferredAllocations = PersistentSortedMaps.merge(pts1.deferredAllocations, pts2.deferredAllocations, (PersistentSortedMaps.MergeConflictHandler)deferredAllocationMergingConflictHandler);
        for (DeferredAllocationPool merged : mergedDeferredAllocationPools.keySet()) {
            for (String pointerVariable : merged.getPointerVariables()) {
                mergedDeferredAllocations = mergedDeferredAllocations.putAndCopy((Object)pointerVariable, (Object)merged);
            }
        }
        return mergedDeferredAllocations;
    }

    private static <K, T> PersistentSortedMaps.MergeConflictHandler<K, PersistentList<T>> mergeOnConflict() {
        return new PersistentSortedMaps.MergeConflictHandler<K, PersistentList<T>>(){

            public PersistentList<T> resolveConflict(K key, PersistentList<T> list1, PersistentList<T> list2) {
                return DeferredAllocationPool.mergeLists(list1, list2);
            }
        };
    }

    private BooleanFormula makeSharingConstraints(PersistentSortedMap<String, CType> newBases, List<Pair<CCompositeType, String>> sharedFields, SSAMap ssa, PointerTargetSet pts) {
        BooleanFormula mergeFormula = this.bfmgr.makeBoolean(true);
        for (Map.Entry base : newBases.entrySet()) {
            if (this.options.isDynamicAllocVariableName((String)base.getKey()) || CTypeUtils.containsArray((CType)base.getValue())) continue;
            FormulaType<?> baseFormulaType = this.typeHandler.getFormulaTypeFromCType(CTypeUtils.getBaseType((CType)base.getValue()));
            mergeFormula = this.bfmgr.and(mergeFormula, this.makeSharingConstraints((Formula)this.formulaManager.makeVariable(baseFormulaType, PointerTargetSet.getBaseName((String)base.getKey())), (String)base.getKey(), (CType)base.getValue(), sharedFields, ssa, pts));
        }
        return mergeFormula;
    }

    private BooleanFormula makeSharingConstraints(Formula address, String variablePrefix, CType variableType, List<Pair<CCompositeType, String>> sharedFields, SSAMap ssa, PointerTargetSet pts) {
        assert (!CTypeUtils.containsArray(variableType)) : "Array access can't be encoded as a varaible";
        BooleanFormula result = this.bfmgr.makeBoolean(true);
        if (variableType instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)variableType;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
            int offset = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                String memberName = memberDeclaration.getName();
                CType memberType = CTypeUtils.simplifyType(memberDeclaration.getType());
                String newPrefix = variablePrefix + "$" + memberName;
                if (ssa.getIndex(newPrefix) > 0) {
                    sharedFields.add((Pair<CCompositeType, String>)Pair.of((Object)compositeType, (Object)memberName));
                    result = this.bfmgr.and(result, this.makeSharingConstraints(this.formulaManager.makePlus(address, this.formulaManager.makeNumber(this.typeHandler.getPointerType(), offset)), newPrefix, memberType, sharedFields, ssa, pts));
                }
                if (compositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
                offset += this.typeHandler.getSizeof(memberType);
            }
        } else if (ssa.getIndex(variablePrefix) > 0) {
            FormulaType<?> variableFormulaType = this.typeHandler.getFormulaTypeFromCType(variableType);
            result = this.bfmgr.and(result, this.formulaManager.makeEqual(this.makeDereferece(variableType, address, ssa), this.formulaManager.makeVariable(variableFormulaType, variablePrefix, ssa.getIndex(variablePrefix))));
        }
        return result;
    }

    private Formula makeDereferece(CType type, Formula address, SSAMap ssa) {
        String ufName = CToFormulaConverterWithPointerAliasing.getUFName(type);
        int index = ssa.getIndex(ufName);
        FormulaType<?> returnType = this.typeHandler.getFormulaTypeFromCType(type);
        return this.ffmgr.declareAndCallUninterpretedFunction(ufName, index, returnType, address);
    }

    int getSize(CType cType) {
        return this.typeHandler.getSizeof(cType);
    }

    int getOffset(CCompositeType compositeType, String memberName) {
        return this.typeHandler.getOffset(compositeType, memberName);
    }

    BooleanFormula getNextBaseAddressInequality(String newBase, PersistentSortedMap<String, CType> bases, String lastBase) {
        FormulaType<?> pointerType = this.typeHandler.getPointerType();
        Object newBaseFormula = this.formulaManager.makeVariable(pointerType, PointerTargetSet.getBaseName(newBase));
        if (lastBase != null) {
            Integer lastSize = this.typeHandler.getSizeof((CType)bases.get((Object)lastBase));
            Object rhs = this.formulaManager.makePlus(this.formulaManager.makeVariable(pointerType, PointerTargetSet.getBaseName(lastBase)), this.formulaManager.makeNumber(pointerType, lastSize.intValue()));
            return this.formulaManager.makeAnd(this.formulaManager.makeGreaterThan(rhs, this.formulaManager.makeNumber(pointerType, 0L), true), this.formulaManager.makeGreaterOrEqual(newBaseFormula, rhs, true));
        }
        return this.formulaManager.makeGreaterThan(newBaseFormula, this.formulaManager.makeNumber(pointerType, 0L), true);
    }

    @CheckReturnValue
    private static PersistentSortedMap<String, PersistentList<PointerTarget>> addToTarget(String base, CType targetType, @Nullable CType containerType, int properOffset, int containerOffset, PersistentSortedMap<String, PersistentList<PointerTarget>> targets) {
        String type = CTypeUtils.typeToString(targetType);
        PersistentList targetsForType = (PersistentList)MoreObjects.firstNonNull((Object)targets.get((Object)type), (Object)PersistentLinkedList.of());
        return targets.putAndCopy((Object)type, (Object)targetsForType.with((Object)new PointerTarget(base, containerType, properOffset, containerOffset)));
    }

    @CheckReturnValue
    PersistentSortedMap<String, PersistentList<PointerTarget>> addToTargets(String base, CType currentType, @Nullable CType containerType, int properOffset, int containerOffset, PersistentSortedMap<String, PersistentList<PointerTarget>> targets, PersistentSortedMap<PointerTargetSet.CompositeField, Boolean> fields) {
        CType cType = CTypeUtils.simplifyType(currentType);
        assert (!(cType instanceof CElaboratedType)) : "Unresolved elaborated type " + cType + " for base " + base;
        if (cType instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)cType;
            Integer length = CTypeUtils.getArrayLength(arrayType);
            if (length == null) {
                length = this.options.defaultArrayLength();
            } else if (length > this.options.maxArrayLength()) {
                length = this.options.maxArrayLength();
            }
            int offset = 0;
            for (int i = 0; i < length; ++i) {
                targets = this.addToTargets(base, arrayType.getType(), arrayType, offset, containerOffset + properOffset, targets, fields);
                offset += this.getSize(arrayType.getType());
            }
        } else if (cType instanceof CCompositeType) {
            CCompositeType compositeType = (CCompositeType)cType;
            assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
            String type = CTypeUtils.typeToString(compositeType);
            this.typeHandler.addCompositeTypeToCache(compositeType);
            int offset = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
                if (fields.containsKey((Object)PointerTargetSet.CompositeField.of(type, memberDeclaration.getName()))) {
                    targets = this.addToTargets(base, memberDeclaration.getType(), compositeType, offset, containerOffset + properOffset, targets, fields);
                }
                if (compositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
                offset += this.getSize(memberDeclaration.getType());
            }
        } else {
            targets = PointerTargetSetManager.addToTarget(base, cType, containerType, properOffset, containerOffset, targets);
        }
        return targets;
    }

    @CheckReturnValue
    private PersistentSortedMap<String, PersistentList<PointerTarget>> addAllTargets(PersistentSortedMap<String, PersistentList<PointerTarget>> targets, PersistentSortedMap<String, CType> bases, PersistentSortedMap<PointerTargetSet.CompositeField, Boolean> fields) {
        for (Map.Entry entry : bases.entrySet()) {
            String name = (String)entry.getKey();
            CType type = CTypeUtils.simplifyType((CType)entry.getValue());
            targets = this.addToTargets(name, type, null, 0, 0, targets, fields);
        }
        return targets;
    }

    private static enum BaseUnitingConflictHandler implements PersistentSortedMaps.MergeConflictHandler<String, CType>
    {
        INSTANCE;


        public CType resolveConflict(String key, CType type1, CType type2) {
            if (PointerTargetSetManager.isFakeBaseType(type1)) {
                return type2;
            }
            if (PointerTargetSetManager.isFakeBaseType(type2)) {
                return type1;
            }
            int currentFieldIndex = 0;
            ImmutableList.Builder membersBuilder = ImmutableList.builder();
            if (type1 instanceof CCompositeType) {
                CCompositeType compositeType1 = (CCompositeType)type1;
                if (compositeType1.getKind() == CComplexType.ComplexTypeKind.UNION && !compositeType1.getMembers().isEmpty() && compositeType1.getMembers().get(0).getName().equals(PointerTargetSetManager.getUnitedFieldBaseName(0))) {
                    membersBuilder.addAll(compositeType1.getMembers());
                    currentFieldIndex += compositeType1.getMembers().size();
                } else {
                    membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(compositeType1, PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex++)));
                }
            } else {
                membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(type1, PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex++)));
            }
            if (type2 instanceof CCompositeType) {
                CCompositeType compositeType2 = (CCompositeType)type2;
                if (compositeType2.getKind() == CComplexType.ComplexTypeKind.UNION && !compositeType2.getMembers().isEmpty() && compositeType2.getMembers().get(0).getName().equals(PointerTargetSetManager.getUnitedFieldBaseName(0))) {
                    for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType2.getMembers()) {
                        membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(memberDeclaration.getType(), PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex++)));
                    }
                } else {
                    membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(compositeType2, PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex++)));
                }
            } else {
                membersBuilder.add((Object)new CCompositeType.CCompositeTypeMemberDeclaration(type2, PointerTargetSetManager.getUnitedFieldBaseName(currentFieldIndex++)));
            }
            String varName = PointerTargetSetManager.UNITED_BASE_UNION_TAG_PREFIX + type1.toString().replace(' ', '_') + "_and_" + type2.toString().replace(' ', '_');
            return new CCompositeType(false, false, CComplexType.ComplexTypeKind.UNION, (List<CCompositeType.CCompositeTypeMemberDeclaration>)membersBuilder.build(), varName, varName);
        }
    }
}

