/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CSizeofVisitor;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.CTypeUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.FormulaEncodingWithPointerAliasingOptions;

public class TypeHandlerWithPointerAliasing
extends CtoFormulaTypeHandler {
    private final CSizeofVisitor sizeofVisitor;
    private final Multiset<CCompositeType> sizes = HashMultiset.create();
    private final Map<CCompositeType, Multiset<String>> offsets = new HashMap<CCompositeType, Multiset<String>>();

    public TypeHandlerWithPointerAliasing(LogManager pLogger, MachineModel pMachineModel, FormulaManagerView pFmgr, FormulaEncodingWithPointerAliasingOptions pOptions) {
        super(pLogger, pOptions, pMachineModel, pFmgr);
        this.sizeofVisitor = new CSizeofVisitor(pMachineModel, pOptions);
    }

    @Override
    public int getSizeof(CType cType) {
        if ((cType = CTypeUtils.simplifyType(cType)) instanceof CCompositeType) {
            if (this.sizes.contains((Object)cType)) {
                return this.sizes.count((Object)cType);
            }
            return cType.accept(this.sizeofVisitor);
        }
        return cType.accept(this.sizeofVisitor);
    }

    int getOffset(CCompositeType compositeType, String memberName) {
        compositeType = (CCompositeType)CTypeUtils.simplifyType(compositeType);
        assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
        Multiset<String> multiset = this.offsets.get(compositeType);
        if (multiset == null) {
            this.addCompositeTypeToCache(compositeType);
            multiset = this.offsets.get(compositeType);
            assert (multiset != null) : "Failed adding composite type to cache: " + compositeType;
        }
        return multiset.count((Object)memberName);
    }

    void addCompositeTypeToCache(CCompositeType compositeType) {
        if (this.offsets.containsKey(compositeType = (CCompositeType)CTypeUtils.simplifyType(compositeType))) {
            assert (this.sizes.contains((Object)compositeType) || Integer.valueOf(0).equals(compositeType.accept(this.sizeofVisitor))) : "Illegal state of PointerTargetSet: no size for type:" + compositeType;
            return;
        }
        Integer size = compositeType.accept(this.sizeofVisitor);
        assert (size != null) : "Can't evaluate size of a composite type: " + compositeType;
        assert (compositeType.getKind() != CComplexType.ComplexTypeKind.ENUM) : "Enums are not composite: " + compositeType;
        HashMultiset members = HashMultiset.create();
        int offset = 0;
        for (CCompositeType.CCompositeTypeMemberDeclaration memberDeclaration : compositeType.getMembers()) {
            CCompositeType memberCompositeType;
            members.setCount((Object)memberDeclaration.getName(), offset);
            CType memberType = CTypeUtils.simplifyType(memberDeclaration.getType());
            if (memberType instanceof CCompositeType) {
                memberCompositeType = (CCompositeType)memberType;
                if (!(memberCompositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT && memberCompositeType.getKind() != CComplexType.ComplexTypeKind.UNION || this.offsets.containsKey(memberCompositeType))) {
                    assert (!this.sizes.contains((Object)memberCompositeType)) : "Illegal state of PointerTargetSet: size for type:" + memberCompositeType;
                    this.addCompositeTypeToCache(memberCompositeType);
                }
            } else {
                memberCompositeType = null;
            }
            if (compositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT) continue;
            if (memberCompositeType != null) {
                offset += this.sizes.count((Object)memberCompositeType);
                continue;
            }
            offset += memberDeclaration.getType().accept(this.sizeofVisitor).intValue();
        }
        assert (compositeType.getKind() != CComplexType.ComplexTypeKind.STRUCT || offset == size) : "Incorrect sizeof or offset of the last member: " + compositeType;
        this.sizes.setCount((Object)compositeType, size.intValue());
        this.offsets.put(compositeType, (Multiset<String>)members);
    }
}

