/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessStack;

abstract class PrincessAbstractProver {
    protected PrincessStack stack;
    protected PrincessFormulaManager mgr;

    protected PrincessAbstractProver(PrincessFormulaManager pMgr, boolean useForInterpolation) {
        this.mgr = pMgr;
        this.stack = (PrincessStack)Preconditions.checkNotNull((Object)((PrincessEnvironment)this.mgr.getEnvironment()).getNewStack(useForInterpolation));
    }

    public boolean isUnsat() throws InterruptedException {
        return !this.stack.checkSat();
    }

    public abstract void pop();

    public abstract Model getModel();

    public void close() {
        Preconditions.checkNotNull((Object)this.stack);
        Preconditions.checkNotNull((Object)this.mgr);
        this.stack.close();
        this.stack = null;
        this.mgr = null;
    }
}

