/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFormulaITE;
import ap.parser.INot;
import ap.parser.ITermITE;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUtil;
import scala.Enumeration;

class PrincessBooleanFormulaManager
extends AbstractBooleanFormulaManager<IExpression, Model.TermType, PrincessEnvironment> {
    PrincessBooleanFormulaManager(PrincessFormulaCreator creator) {
        super(creator);
    }

    @Override
    public IFormula makeVariableImpl(String varName) {
        return PrincessUtil.castToFormula((IExpression)this.getFormulaCreator().makeVariable(this.getFormulaCreator().getBoolType(), varName));
    }

    @Override
    public IFormula makeBooleanImpl(boolean pValue) {
        return new IBoolLit(pValue);
    }

    @Override
    public IFormula equivalence(IExpression t1, IExpression t2) {
        return new IBinFormula(IBinJunctor.Eqv(), PrincessUtil.castToFormula(t1), PrincessUtil.castToFormula(t2));
    }

    @Override
    public boolean isTrue(IExpression t) {
        return PrincessUtil.isTrue(t);
    }

    @Override
    public boolean isFalse(IExpression t) {
        return PrincessUtil.isFalse(t);
    }

    @Override
    public IExpression ifThenElse(IExpression condition, IExpression t1, IExpression t2) {
        if (t1 instanceof IFormula) {
            return new IFormulaITE(PrincessUtil.castToFormula(condition), PrincessUtil.castToFormula(t1), PrincessUtil.castToFormula(t2));
        }
        return new ITermITE(PrincessUtil.castToFormula(condition), PrincessUtil.castToTerm(t1), PrincessUtil.castToTerm(t2));
    }

    @Override
    public IFormula not(IExpression pBits) {
        if (this.isNot(pBits)) {
            return ((INot)pBits).subformula();
        }
        return new INot(PrincessUtil.castToFormula(pBits));
    }

    @Override
    public IFormula and(IExpression t1, IExpression t2) {
        if (t1.equals(t2)) {
            return PrincessUtil.castToFormula(t1);
        }
        if (PrincessUtil.isTrue(t1)) {
            return PrincessUtil.castToFormula(t2);
        }
        if (PrincessUtil.isTrue(t2)) {
            return PrincessUtil.castToFormula(t1);
        }
        return this.simplify((IFormula)new IBinFormula(IBinJunctor.And(), PrincessUtil.castToFormula(t1), PrincessUtil.castToFormula(t2)));
    }

    @Override
    public IFormula or(IExpression t1, IExpression t2) {
        if (PrincessUtil.isFalse(t1)) {
            return PrincessUtil.castToFormula(t2);
        }
        if (PrincessUtil.isFalse(t2)) {
            return PrincessUtil.castToFormula(t1);
        }
        return this.simplify((IFormula)new IBinFormula(IBinJunctor.Or(), PrincessUtil.castToFormula(t1), PrincessUtil.castToFormula(t2)));
    }

    private IFormula simplify(IFormula f) {
        IBinFormula bin;
        if (f instanceof IBinFormula && (bin = (IBinFormula)f).f1() instanceof IBinFormula && bin.f2() instanceof IBinFormula && ((IBinFormula)bin.f1()).j().equals((Object)((IBinFormula)bin.f2()).j())) {
            Enumeration.Value operator = ((IBinFormula)f).j();
            Enumeration.Value innerOperator = ((IBinFormula)bin.f1()).j();
            IFormula s11 = ((IBinFormula)bin.f1()).f1();
            IFormula s12 = ((IBinFormula)bin.f1()).f2();
            IFormula s21 = ((IBinFormula)bin.f2()).f1();
            IFormula s22 = ((IBinFormula)bin.f2()).f2();
            if (s11.equals(s21)) {
                return new IBinFormula(innerOperator, s11, (IFormula)new IBinFormula(operator, s12, s22));
            }
            if (s11.equals(s22)) {
                return new IBinFormula(innerOperator, s11, (IFormula)new IBinFormula(operator, s12, s21));
            }
            if (s12.equals(s21)) {
                return new IBinFormula(innerOperator, s12, (IFormula)new IBinFormula(operator, s11, s22));
            }
            if (s12.equals(s22)) {
                return new IBinFormula(innerOperator, s12, (IFormula)new IBinFormula(operator, s11, s21));
            }
        }
        return f;
    }

    @Override
    public IFormula xor(IExpression t1, IExpression t2) {
        return new INot((IFormula)new IBinFormula(IBinJunctor.Eqv(), PrincessUtil.castToFormula(t1), PrincessUtil.castToFormula(t2)));
    }

    @Override
    public boolean isNot(IExpression pBits) {
        return pBits instanceof INot;
    }

    @Override
    public boolean isAnd(IExpression pBits) {
        return PrincessUtil.isAnd(pBits);
    }

    @Override
    public boolean isOr(IExpression pBits) {
        return PrincessUtil.isOr(pBits);
    }

    @Override
    public boolean isXor(IExpression pBits) {
        return PrincessUtil.isXor(pBits);
    }

    @Override
    protected boolean isEquivalence(IExpression pBits) {
        return PrincessUtil.isEquivalence(pBits);
    }

    @Override
    protected boolean isImplication(IExpression pFormula) {
        return PrincessUtil.isImplication(pFormula);
    }

    @Override
    protected boolean isIfThenElse(IExpression pBits) {
        return PrincessUtil.isIfThenElse(pBits);
    }
}

