/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.SimpleAPI;
import ap.basetypes.IdealInt;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntLit;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessStack;
import org.sosy_lab.cpachecker.util.predicates.princess.SymbolTrackingPrincessStack;
import scala.collection.mutable.ArrayBuffer;

class PrincessEnvironment {
    private final Map<String, IFormula> boolVariablesCache = new HashMap<String, IFormula>();
    private final Map<String, ITerm> intVariablesCache = new HashMap<String, ITerm>();
    private final Map<String, FunctionType> functionsCache = new HashMap<String, FunctionType>();
    private final Map<IFunction, FunctionType> declaredFunctions = new HashMap<IFunction, FunctionType>();
    private final List<Pair<IFormula, IFormula>> abbrevFormulas = new ArrayList<Pair<IFormula, IFormula>>();
    private final BiMap<IFormula, IFormula> abbrevFormulasMap = HashBiMap.create();
    @Nullable
    private final PathCounterTemplate basicLogfile;
    private static final String ABBREV = "ABBREV_";
    private static final UniqueIdGenerator abbrevIndex = new UniqueIdGenerator();
    private final SimpleAPI api;
    private final List<SymbolTrackingPrincessStack> registeredStacks = new ArrayList<SymbolTrackingPrincessStack>();

    public PrincessEnvironment(Configuration config, LogManager pLogger, PathCounterTemplate pBasicLogfile) throws InvalidConfigurationException {
        this.basicLogfile = pBasicLogfile;
        this.api = this.getNewApi(false);
    }

    PrincessStack getNewStack(boolean useForInterpolation) {
        SimpleAPI newApi = this.getNewApi(useForInterpolation);
        SymbolTrackingPrincessStack stack = new SymbolTrackingPrincessStack(this, newApi);
        for (IFormula iFormula : this.boolVariablesCache.values()) {
            stack.addSymbol(iFormula);
        }
        for (ITerm iTerm : this.intVariablesCache.values()) {
            stack.addSymbol(iTerm);
        }
        for (FunctionType functionType : this.functionsCache.values()) {
            stack.addSymbol(functionType.funcDecl);
        }
        for (Pair pair : this.abbrevFormulas) {
            stack.addAbbrev((IFormula)pair.getFirst(), (IFormula)pair.getSecond());
        }
        this.registeredStacks.add(stack);
        return stack;
    }

    private SimpleAPI getNewApi(boolean useForInterpolation) {
        SimpleAPI newApi = this.basicLogfile != null ? SimpleAPI.spawnWithLogNoSanitise((String)this.basicLogfile.getFreshPath().getAbsolutePath()) : SimpleAPI.spawnNoSanitise();
        if (useForInterpolation) {
            newApi.setConstructProofs(true);
        }
        return newApi;
    }

    void unregisterStack(SymbolTrackingPrincessStack stack) {
        assert (this.registeredStacks.contains(stack)) : "cannot remove stack, it is not registered";
        this.registeredStacks.remove(stack);
    }

    public List<IExpression> parseStringToTerms(String s) {
        throw new UnsupportedOperationException();
    }

    public IExpression makeVariable(Model.TermType type, String varname) {
        switch (type) {
            case Boolean: {
                if (this.boolVariablesCache.containsKey(varname)) {
                    return (IExpression)this.boolVariablesCache.get(varname);
                }
                IFormula var = this.api.createBooleanVariable(varname);
                for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
                    stack.addSymbol(var);
                }
                this.boolVariablesCache.put(varname, var);
                return var;
            }
            case Integer: {
                if (this.intVariablesCache.containsKey(varname)) {
                    return (IExpression)this.intVariablesCache.get(varname);
                }
                ITerm var = this.api.createConstant(varname);
                for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
                    stack.addSymbol(var);
                }
                this.intVariablesCache.put(varname, var);
                return var;
            }
        }
        throw new AssertionError((Object)("unsupported type: " + (Object)((Object)type)));
    }

    public FunctionType declareFun(String name, Model.TermType resultType, List<Model.TermType> args) {
        if (this.functionsCache.containsKey(name)) {
            FunctionType function = this.functionsCache.get(name);
            assert (function.getResultType() == resultType);
            assert (function.getArgs().equals(args));
            return function;
        }
        FunctionType type = this.declareFun0(name, resultType, args);
        this.functionsCache.put(name, type);
        return type;
    }

    private FunctionType declareFun0(String name, Model.TermType resultType, List<Model.TermType> args) {
        IFunction funcDecl = this.api.createFunction(name, args.size());
        for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
            stack.addSymbol(funcDecl);
        }
        FunctionType type = new FunctionType(funcDecl, resultType, args);
        this.declaredFunctions.put(funcDecl, type);
        return type;
    }

    public FunctionType getFunctionDeclaration(IFunction f) {
        return this.declaredFunctions.get(f);
    }

    public IExpression makeFunction(IFunction funcDecl, Model.TermType resultType, List<IExpression> args) {
        ArrayBuffer argsBuf = new ArrayBuffer();
        for (IExpression arg : args) {
            Object termArg = arg instanceof IFormula ? new ITermITE((IFormula)arg, (ITerm)new IIntLit(IdealInt.apply((int)0)), (ITerm)new IIntLit(IdealInt.apply((int)1))) : (ITerm)arg;
            argsBuf.$plus$eq(termArg);
        }
        IFunApp t = new IFunApp(funcDecl, argsBuf.toSeq());
        switch (resultType) {
            case Boolean: {
                return t;
            }
            case Integer: {
                return t;
            }
        }
        throw new AssertionError((Object)"unknown resulttype");
    }

    public IFormula abbrev(IFormula longFormula) {
        if (this.abbrevFormulasMap.inverse().containsKey((Object)longFormula)) {
            return (IFormula)this.abbrevFormulasMap.inverse().get((Object)longFormula);
        }
        String abbrevName = ABBREV + abbrevIndex.getFreshId();
        IFormula abbrev = this.api.abbrev(longFormula, abbrevName);
        this.abbrevFormulas.add((Pair<IFormula, IFormula>)Pair.of((Object)abbrev, (Object)longFormula));
        this.abbrevFormulasMap.put((Object)abbrev, (Object)longFormula);
        for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
            stack.addAbbrev(abbrev, longFormula);
        }
        return abbrev;
    }

    public String getVersion() {
        return "Princess (unknown version)";
    }

    public static class FunctionType {
        private final IFunction funcDecl;
        private final Model.TermType resultType;
        private final List<Model.TermType> args;

        FunctionType(IFunction funcDecl, Model.TermType resultType, List<Model.TermType> args) {
            this.funcDecl = funcDecl;
            this.resultType = resultType;
            this.args = ImmutableList.copyOf(args);
        }

        public IFunction getFuncDecl() {
            return this.funcDecl;
        }

        public Model.TermType getResultType() {
            return this.resultType;
        }

        public List<Model.TermType> getArgs() {
            return this.args;
        }
    }
}

