/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.parser.IExpression;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUtil;

class PrincessFormulaCreator
extends FormulaCreator<IExpression, Model.TermType, PrincessEnvironment> {
    PrincessFormulaCreator(PrincessEnvironment pEnv, Model.TermType pBoolType, Model.TermType pIntegerType) {
        super(pEnv, pBoolType, pIntegerType, null);
    }

    @Override
    public FormulaType<?> getFormulaType(IExpression pFormula) {
        if (PrincessUtil.isBoolean(pFormula)) {
            return FormulaType.BooleanType;
        }
        if (PrincessUtil.hasIntegerType(pFormula)) {
            return FormulaType.IntegerType;
        }
        throw new IllegalArgumentException("Unknown formula type");
    }

    @Override
    public IExpression makeVariable(Model.TermType type, String varName) {
        return ((PrincessEnvironment)this.getEnv()).makeVariable(type, varName);
    }

    @Override
    public Model.TermType getRationalType() {
        throw new UnsupportedOperationException("Rational theory is not supported by Princess");
    }

    @Override
    public Model.TermType getBitvectorType(int pBitwidth) {
        throw new UnsupportedOperationException("Bitvector theory is not supported by Princess");
    }

    @Override
    public Model.TermType getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by Princess");
    }

    @Override
    public Model.TermType getArrayType(Model.TermType pIndexType, Model.TermType pElementType) {
        throw new IllegalArgumentException("Princess.getArrayType(): Implement me!");
    }
}

