/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.parser.IExpression;
import com.google.common.collect.Iterables;
import java.io.IOException;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessInterpolatingProver;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessTheoremProver;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUnsafeFormulaManager;

public class PrincessFormulaManager
extends AbstractFormulaManager<IExpression, Model.TermType, PrincessEnvironment> {
    private final ShutdownNotifier shutdownNotifier;

    private PrincessFormulaManager(PrincessFormulaCreator pCreator, PrincessUnsafeFormulaManager pUnsafeManager, PrincessFunctionFormulaManager pFunctionManager, PrincessBooleanFormulaManager pBooleanManager, PrincessIntegerFormulaManager pIntegerManager, ShutdownNotifier pShutdownNotifier) {
        super(pCreator, pUnsafeManager, pFunctionManager, pBooleanManager, pIntegerManager, null, null, null, null, null);
        this.shutdownNotifier = pShutdownNotifier;
    }

    public static PrincessFormulaManager create(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, PathCounterTemplate pLogfileTemplate) throws InvalidConfigurationException {
        PrincessEnvironment env = new PrincessEnvironment(config, logger, pLogfileTemplate);
        PrincessFormulaCreator creator = new PrincessFormulaCreator(env, Model.TermType.Boolean, Model.TermType.Integer);
        PrincessUnsafeFormulaManager unsafeManager = new PrincessUnsafeFormulaManager(creator);
        PrincessFunctionFormulaManager functionTheory = new PrincessFunctionFormulaManager(creator, unsafeManager);
        PrincessBooleanFormulaManager booleanTheory = new PrincessBooleanFormulaManager(creator);
        PrincessIntegerFormulaManager integerTheory = new PrincessIntegerFormulaManager(creator, functionTheory);
        return new PrincessFormulaManager(creator, unsafeManager, functionTheory, booleanTheory, integerTheory, pShutdownNotifier);
    }

    BooleanFormula encapsulateBooleanFormula(IExpression t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public ProverEnvironment newProverEnvironment(boolean pGenerateModels, boolean pGenerateUnsatCore) {
        return new PrincessTheoremProver(this, this.shutdownNotifier);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(boolean pShared) {
        return new PrincessInterpolatingProver(this);
    }

    @Override
    public OptEnvironment newOptEnvironment() {
        throw new UnsupportedOperationException("Princess does not support optimization");
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.encapsulateBooleanFormula((IExpression)Iterables.getOnlyElement(((PrincessEnvironment)this.getEnvironment()).parseStringToTerms(pS)));
    }

    @Override
    public Appender dumpFormula(final IExpression formula) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                out.append("(assert ");
                out.append(formula.toString());
                out.append(")");
            }
        };
    }

    @Override
    public String getVersion() {
        return ((PrincessEnvironment)this.getEnvironment()).getVersion();
    }
}

