/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.parser.IExpression;
import ap.parser.IFormula;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessAbstractProver;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessModel;

class PrincessInterpolatingProver
extends PrincessAbstractProver
implements InterpolatingProverEnvironment<Integer> {
    private final List<Integer> assertedFormulas = new ArrayList<Integer>();
    private final Map<Integer, IFormula> annotatedTerms = new HashMap<Integer, IFormula>();
    private static final UniqueIdGenerator counter = new UniqueIdGenerator();

    PrincessInterpolatingProver(PrincessFormulaManager pMgr) {
        super(pMgr, true);
    }

    @Override
    public Integer push(BooleanFormula f) {
        IFormula t = (IFormula)this.mgr.extractInfo(f);
        int termIndex = counter.getFreshId();
        this.stack.push(1);
        this.stack.assertTermInPartition(t, termIndex);
        this.assertedFormulas.add(termIndex);
        this.annotatedTerms.put(termIndex, t);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        return termIndex;
    }

    @Override
    public void pop() {
        Integer removed = this.assertedFormulas.remove(this.assertedFormulas.size() - 1);
        this.annotatedTerms.remove(removed);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        this.stack.pop(1);
    }

    @Override
    public BooleanFormula getInterpolant(List<Integer> pTermNamesOfA) {
        HashSet<Integer> indizesOfA = new HashSet<Integer>(pTermNamesOfA);
        ImmutableSet indizesOfB = FluentIterable.from(this.assertedFormulas).filter(Predicates.not((Predicate)Predicates.in(indizesOfA))).toSet();
        List<IFormula> itp = this.stack.getInterpolants((List<Set<Integer>>)ImmutableList.of(indizesOfA, (Object)indizesOfB));
        assert (itp.size() == 1);
        return this.mgr.encapsulateBooleanFormula((IExpression)itp.get(0));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Integer>> pTermNamesOfA) {
        List<IFormula> itps = this.stack.getInterpolants(pTermNamesOfA);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (IFormula itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula((IExpression)itp));
        }
        return result;
    }

    @Override
    public Model getModel() {
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        ArrayList values = Lists.newArrayList(this.annotatedTerms.values());
        return PrincessModel.createModel(this.stack, values);
    }
}

