/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.SimpleAPI;
import ap.parser.IAtom;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFunApp;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessStack;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUtil;
import scala.Option;

class PrincessModel {
    PrincessModel() {
    }

    private static Model.AssignableTerm toVariable(IExpression t) {
        Model.TermType lType;
        String lName;
        if (!PrincessUtil.isVariable(t)) {
            throw new IllegalArgumentException("Given term is no variable! (" + t.toString() + ")");
        }
        if (t instanceof IAtom) {
            lName = ((IAtom)t).pred().name();
            lType = Model.TermType.Boolean;
        } else {
            IConstant v = (IConstant)t;
            lName = v.c().name();
            lType = Model.TermType.Integer;
        }
        Pair<String, Integer> lSplitName = FormulaManagerView.parseName(lName);
        if (lSplitName.getSecond() != null) {
            return new Model.Variable((String)lSplitName.getFirst(), (Integer)lSplitName.getSecond(), lType);
        }
        return new Model.Constant((String)lSplitName.getFirst(), lType);
    }

    private static Model.Function toFunction(IExpression t, PrincessEnvironment env, SimpleAPI.PartialModel partialModel) {
        if (PrincessUtil.isVariable(t)) {
            throw new IllegalArgumentException("Given term is no function! (" + t.toString() + ")");
        }
        IFunApp appTerm = (IFunApp)t;
        String lName = appTerm.fun().name();
        Model.TermType lType = env.getFunctionDeclaration(appTerm.fun()).getResultType();
        int lArity = PrincessUtil.getArity((IExpression)appTerm);
        Object[] lArguments = new Object[lArity];
        for (int lArgumentIndex = 0; lArgumentIndex < lArity; ++lArgumentIndex) {
            IExpression lArgument = PrincessUtil.getArg((IExpression)appTerm, lArgumentIndex);
            Option argumentValue = partialModel.evalExpression(lArgument);
            lArguments[lArgumentIndex] = argumentValue.isDefined() ? PrincessModel.getValue((SimpleAPI.ModelValue)argumentValue.get()) : lArgument.toString();
        }
        return new Model.Function(lName, lType, lArguments);
    }

    private static Model.AssignableTerm toAssignable(IExpression t, PrincessEnvironment env, SimpleAPI.PartialModel partialModel) {
        if (PrincessUtil.isVariable(t)) {
            return PrincessModel.toVariable(t);
        }
        return PrincessModel.toFunction(t, env, partialModel);
    }

    private static Object getValue(SimpleAPI.ModelValue value) {
        if (value instanceof SimpleAPI.BoolValue) {
            return ((SimpleAPI.BoolValue)value).v();
        }
        if (value instanceof SimpleAPI.IntValue) {
            return ((SimpleAPI.IntValue)value).v().bigIntValue();
        }
        throw new IllegalArgumentException("unhandled model value " + value + " of type " + value.getClass());
    }

    static Model createModel(PrincessStack stack, Collection<IExpression> assertedFormulas) {
        LinkedHashMap<Model.AssignableTerm, Object> model = new LinkedHashMap<Model.AssignableTerm, Object>();
        Preconditions.checkArgument((boolean)stack.checkSat(), (Object)"model is only available for SAT environments");
        SimpleAPI.PartialModel partialModel = stack.getPartialModel();
        for (IExpression lKeyTerm : PrincessUtil.getVarsAndUIFs(assertedFormulas)) {
            Option value = partialModel.evalExpression(lKeyTerm);
            if (!value.isDefined()) continue;
            Model.AssignableTerm lAssignable = PrincessModel.toAssignable(lKeyTerm, stack.getEnv(), partialModel);
            Object lValue = PrincessModel.getValue((SimpleAPI.ModelValue)value.get());
            Object existingValue = model.get(lAssignable);
            Verify.verify((existingValue == null || lValue.equals(existingValue) ? 1 : 0) != 0, (String)"Duplicate values for model entry %s: %s and %s", (Object[])new Object[]{lAssignable, existingValue, lValue});
            model.put(lAssignable, lValue);
        }
        return new Model(model);
    }
}

