/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.basetypes.IdealInt;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IIntFormula;
import ap.parser.IIntLit;
import ap.parser.IIntRelation;
import ap.parser.ITerm;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUtil;

abstract class PrincessNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<IExpression, Model.TermType, PrincessEnvironment, ParamFormulaType, ResultFormulaType> {
    PrincessNumeralFormulaManager(PrincessFormulaCreator pCreator, PrincessFunctionFormulaManager pFunctionManager) {
        super(pCreator, pFunctionManager);
    }

    @Override
    public ITerm negate(IExpression pNumber) {
        return PrincessUtil.castToTerm(pNumber).unary_$minus();
    }

    @Override
    public ITerm add(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$plus(PrincessUtil.castToTerm(pNumber2));
    }

    @Override
    public ITerm subtract(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$minus(PrincessUtil.castToTerm(pNumber2));
    }

    @Override
    public IExpression divide(IExpression pNumber1, IExpression pNumber2) {
        Object result = PrincessUtil.isNumber(pNumber2) ? PrincessUtil.castToTerm(pNumber1).$times(IdealInt.ONE().$div(((IIntLit)pNumber2).value())) : super.divide(pNumber1, pNumber2);
        return result;
    }

    @Override
    public IExpression multiply(IExpression pNumber1, IExpression pNumber2) {
        Object result = PrincessUtil.isNumber(pNumber1) || PrincessUtil.isNumber(pNumber2) ? PrincessUtil.castToTerm(pNumber1).$times(PrincessUtil.castToTerm(pNumber2)) : super.multiply(pNumber1, pNumber2);
        return result;
    }

    @Override
    public IFormula equal(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$eq$eq$eq(PrincessUtil.castToTerm(pNumber2));
    }

    @Override
    public boolean isEqual(IExpression pNumber) {
        return pNumber instanceof IIntFormula && ((IIntFormula)pNumber).rel() == IIntRelation.EqZero();
    }

    @Override
    public IFormula greaterThan(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$greater(PrincessUtil.castToTerm(pNumber2));
    }

    @Override
    public IFormula greaterOrEquals(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$greater$eq(PrincessUtil.castToTerm(pNumber2));
    }

    @Override
    public IFormula lessThan(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$less(PrincessUtil.castToTerm(pNumber2));
    }

    @Override
    public IFormula lessOrEquals(IExpression pNumber1, IExpression pNumber2) {
        return PrincessUtil.castToTerm(pNumber1).$less$eq(PrincessUtil.castToTerm(pNumber2));
    }
}

