/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.SimpleAPI;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.INot;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.time.NestedTimer;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessAbstractProver;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessModel;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUtil;
import scala.Option;

class PrincessTheoremProver
extends PrincessAbstractProver
implements ProverEnvironment {
    private final List<IExpression> assertedTerms = new ArrayList<IExpression>();
    private final ShutdownNotifier shutdownNotifier;

    PrincessTheoremProver(PrincessFormulaManager pMgr, ShutdownNotifier pShutdownNotifier) {
        super(pMgr, false);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
    }

    @Override
    public Model getModel() {
        return PrincessModel.createModel(this.stack, this.assertedTerms);
    }

    @Override
    public void pop() {
        this.assertedTerms.remove(this.assertedTerms.size() - 1);
        this.stack.pop(1);
    }

    @Override
    public Void push(BooleanFormula f) {
        IFormula t = PrincessUtil.castToFormula((IExpression)this.mgr.extractInfo(f));
        this.assertedTerms.add((IExpression)t);
        this.stack.push(1);
        this.stack.assertTerm(t);
        return null;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProverEnvironment.AllSatResult allSat(Collection<BooleanFormula> formulas, AbstractionManager.RegionCreator rmgr, Timer solveTime, NestedTimer enumTime) throws InterruptedException {
        Preconditions.checkNotNull((Object)rmgr);
        Preconditions.checkNotNull((Object)solveTime);
        Preconditions.checkNotNull((Object)enumTime);
        Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
        AllSatCallback result = new AllSatCallback(rmgr, solveTime, enumTime);
        ArrayList<IFormula> importantFormulas = new ArrayList<IFormula>(formulas.size());
        for (BooleanFormula impF : formulas) {
            importantFormulas.add(PrincessUtil.castToFormula((IExpression)this.mgr.extractInfo(impF)));
        }
        solveTime.start();
        try {
            this.stack.push(1);
            while (this.stack.checkSat()) {
                this.shutdownNotifier.shutdownIfNecessary();
                SimpleAPI.PartialModel model = this.stack.getPartialModel();
                IBoolLit newFormula = new IBoolLit(true);
                HashMap<IFormula, Boolean> partialModel = new HashMap<IFormula, Boolean>();
                for (IFormula f : importantFormulas) {
                    Option value = model.eval(f);
                    if (!value.isDefined()) continue;
                    Boolean isTrueValue = (Boolean)value.get();
                    IFormula newElement = isTrueValue != false ? f : new INot(f);
                    newFormula = new IBinFormula(IBinJunctor.And(), (IFormula)newFormula, newElement);
                    partialModel.put(f, isTrueValue);
                }
                result.callback(partialModel);
                this.stack.assertTerm((IFormula)new INot((IFormula)newFormula));
            }
            this.shutdownNotifier.shutdownIfNecessary();
            this.stack.pop(1);
        }
        finally {
            if (solveTime.isRunning()) {
                solveTime.stop();
            } else {
                enumTime.stopOuter();
            }
        }
        return result;
    }

    class AllSatCallback
    implements ProverEnvironment.AllSatResult {
        private final AbstractionManager.RegionCreator rmgr;
        private final RegionManager.RegionBuilder builder;
        private final Timer solveTime;
        private final NestedTimer enumTime;
        private Timer regionTime = null;
        private int count = 0;
        private Region formula = null;

        public AllSatCallback(AbstractionManager.RegionCreator rmgr, Timer pSolveTime, NestedTimer pEnumTime) {
            this.rmgr = rmgr;
            this.solveTime = pSolveTime;
            this.enumTime = pEnumTime;
            this.builder = rmgr.newRegionBuilder(PrincessTheoremProver.this.shutdownNotifier);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Region getResult() throws InterruptedException {
            if (this.formula == null) {
                this.enumTime.startBoth();
                try {
                    this.formula = this.builder.getResult();
                    this.builder.close();
                }
                finally {
                    this.enumTime.stopBoth();
                }
            }
            return this.formula;
        }

        public void callback(Map<IFormula, Boolean> model) {
            if (this.count == 0) {
                this.solveTime.stop();
                this.enumTime.startOuter();
                this.regionTime = this.enumTime.getCurentInnerTimer();
            }
            this.regionTime.start();
            this.builder.startNewConjunction();
            for (Map.Entry<IFormula, Boolean> f : model.entrySet()) {
                if (f.getValue().booleanValue()) {
                    this.builder.addPositiveRegion(this.rmgr.getPredicate(this.encapsulate(f.getKey())));
                    continue;
                }
                this.builder.addNegativeRegion(this.rmgr.getPredicate(this.encapsulate(f.getKey())));
            }
            this.builder.finishConjunction();
            ++this.count;
            this.regionTime.stop();
        }

        private BooleanFormula encapsulate(IFormula pT) {
            return PrincessTheoremProver.this.mgr.encapsulateBooleanFormula((IExpression)pT);
        }
    }
}

