/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.parser.BooleanCompactifier;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.PartialEvaluator;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessUtil;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

class PrincessUnsafeFormulaManager
extends AbstractUnsafeFormulaManager<IExpression, Model.TermType, PrincessEnvironment> {
    PrincessUnsafeFormulaManager(PrincessFormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    public boolean isAtom(IExpression t) {
        return PrincessUtil.isAtom(t);
    }

    @Override
    public boolean isLiteral(IExpression t) {
        return PrincessUtil.isNot(t) || this.isAtom(t);
    }

    @Override
    public int getArity(IExpression pT) {
        return PrincessUtil.getArity(pT);
    }

    @Override
    public IExpression getArg(IExpression pT, int pN) {
        return PrincessUtil.getArg(pT, pN);
    }

    @Override
    public boolean isVariable(IExpression pT) {
        return PrincessUtil.isVariable(pT);
    }

    @Override
    public boolean isUF(IExpression t) {
        return PrincessUtil.isUIF(t);
    }

    @Override
    public String getName(IExpression t) {
        if (this.isVariable(t)) {
            return t.toString();
        }
        if (this.isUF(t)) {
            return ((IFunApp)t).fun().name();
        }
        throw new IllegalArgumentException("The Term " + t + " has no name!");
    }

    @Override
    public IExpression replaceArgs(IExpression pT, List<IExpression> newArgs) {
        return PrincessUtil.replaceArgs((PrincessEnvironment)this.getFormulaCreator().getEnv(), pT, newArgs);
    }

    @Override
    public IExpression replaceName(IExpression t, String pNewName) {
        if (this.isVariable(t)) {
            boolean isBoolean = t instanceof IFormula;
            Model.TermType type = isBoolean ? Model.TermType.Boolean : Model.TermType.Integer;
            return (IExpression)this.getFormulaCreator().makeVariable(type, pNewName);
        }
        if (this.isUF(t)) {
            IFunApp fun = (IFunApp)t;
            PrincessEnvironment.FunctionType funcDecl = ((PrincessEnvironment)this.getFormulaCreator().getEnv()).getFunctionDeclaration(fun.fun());
            ImmutableList args = ImmutableList.copyOf((Collection)JavaConversions.asJavaCollection((Iterable)fun.args()));
            return this.createUIFCallImpl(fun.fun(), funcDecl.getResultType(), (List<IExpression>)args);
        }
        throw new IllegalArgumentException("The Term " + t + " has no name!");
    }

    IExpression createUIFCallImpl(IFunction funcDecl, Model.TermType resultType, List<IExpression> args) {
        IExpression ufc = ((PrincessEnvironment)this.getFormulaCreator().getEnv()).makeFunction(funcDecl, resultType, args);
        assert (PrincessUtil.isUIF(ufc));
        return ufc;
    }

    @Override
    public boolean isNumber(IExpression pT) {
        return PrincessUtil.isNumber(pT);
    }

    @Override
    protected IExpression substitute(IExpression expr, List<IExpression> substituteFrom, List<IExpression> substituteTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected IExpression simplify(IExpression f) {
        if (f instanceof IFormula) {
            f = BooleanCompactifier.apply((IFormula)((IFormula)f));
        }
        return PartialEvaluator.apply((IExpression)f);
    }

    @Override
    protected boolean isQuantification(IExpression pT) {
        return false;
    }

    @Override
    protected IExpression getQuantifiedBody(IExpression pT) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected IExpression replaceQuantifiedBody(IExpression pF, IExpression pBody) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isFreeVariable(IExpression pT) {
        return this.isVariable(pT);
    }

    @Override
    protected boolean isBoundVariable(IExpression pT) {
        return false;
    }
}

