/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFormulaITE;
import ap.parser.IFunApp;
import ap.parser.IIntLit;
import ap.parser.INot;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import scala.Enumeration;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.Seq;

class PrincessUtil {
    private PrincessUtil() {
    }

    public static ITerm castToTerm(IExpression e) {
        return (ITerm)e;
    }

    public static IFormula castToFormula(IExpression e) {
        return (IFormula)e;
    }

    public static boolean isAtom(IExpression t) {
        boolean is;
        boolean bl = is = !PrincessUtil.isAnd(t) && !PrincessUtil.isOr(t) && !PrincessUtil.isNot(t) && !PrincessUtil.isImplication(t) && !PrincessUtil.isIfThenElse(t);
        assert (is || PrincessUtil.isBoolean(t));
        return is;
    }

    public static boolean isVariable(IExpression t) {
        return t instanceof IAtom || t instanceof IConstant;
    }

    public static boolean isUIF(IExpression t) {
        return t instanceof IFunApp;
    }

    public static boolean isNumber(IExpression t) {
        return t instanceof IIntLit;
    }

    public static double toNumber(IExpression t) {
        assert (PrincessUtil.isNumber(t)) : "term is not a number: " + t;
        if (t instanceof IIntLit) {
            IdealInt value = ((IIntLit)t).value();
            return value.longValue();
        }
        throw new NumberFormatException("unknown format of numeric term: " + t);
    }

    public static boolean isBoolean(IExpression t) {
        return t instanceof IFormula;
    }

    public static boolean hasIntegerType(IExpression t) {
        return t instanceof ITerm;
    }

    public static boolean isAnd(IExpression t) {
        return PrincessUtil.isBinaryFunction(t, IBinJunctor.And());
    }

    public static boolean isOr(IExpression t) {
        return PrincessUtil.isBinaryFunction(t, IBinJunctor.Or());
    }

    public static boolean isNot(IExpression t) {
        return t instanceof INot;
    }

    public static boolean isImplication(IExpression t) {
        return false;
    }

    public static boolean isXor(IExpression t) {
        return false;
    }

    public static boolean isIfThenElse(IExpression t) {
        return t instanceof IFormulaITE || t instanceof ITermITE;
    }

    public static boolean isEquivalence(IExpression t) {
        return PrincessUtil.isBinaryFunction(t, IBinJunctor.Eqv());
    }

    private static boolean isBinaryFunction(IExpression t, Enumeration.Value val) {
        return t instanceof IBinFormula && val == ((IBinFormula)t).j();
    }

    public static int getArity(IExpression t) {
        return t.length();
    }

    public static IExpression getArg(IExpression t, int i) {
        assert (i < PrincessUtil.getArity(t)) : String.format("index %d out of bounds %d in expression %s", i, PrincessUtil.getArity(t), t);
        return t.apply(i);
    }

    public static boolean isTrue(IExpression t) {
        return t instanceof IBoolLit && ((IBoolLit)t).value();
    }

    public static boolean isFalse(IExpression t) {
        return t instanceof IBoolLit && !((IBoolLit)t).value();
    }

    public static IExpression replaceArgs(PrincessEnvironment env, IExpression t, List<IExpression> newParams) {
        return t.update((Seq)JavaConversions.asScalaBuffer(newParams));
    }

    public static Set<IExpression> getVarsAndUIFs(Collection<IExpression> exprList) {
        HashSet<IExpression> result = new HashSet<IExpression>();
        HashSet<IExpression> seen = new HashSet<IExpression>();
        ArrayDeque<IExpression> todo = new ArrayDeque<IExpression>(exprList);
        while (!todo.isEmpty()) {
            IExpression t = (IExpression)todo.removeLast();
            if (!seen.add(t)) continue;
            if (PrincessUtil.isVariable(t) || PrincessUtil.isUIF(t)) {
                result.add(t);
                continue;
            }
            if (t.length() <= 0) continue;
            Iterator it = t.iterator();
            while (it.hasNext()) {
                todo.add((IExpression)it.next());
            }
        }
        return result;
    }

    public static String prettyPrint(IExpression t) {
        return t.toString();
    }
}

