/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.princess;

import ap.SimpleAPI;
import ap.parser.IFormula;
import ap.parser.IFunction;
import ap.parser.ITerm;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessEnvironment;
import org.sosy_lab.cpachecker.util.predicates.princess.PrincessStack;
import scala.Enumeration;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

class SymbolTrackingPrincessStack
implements PrincessStack {
    private final PrincessEnvironment env;
    private final SimpleAPI api;
    private final Deque<Level> trackingStack = new ArrayDeque<Level>();

    public SymbolTrackingPrincessStack(PrincessEnvironment env, SimpleAPI api) {
        this.env = env;
        this.api = api;
    }

    @Override
    public PrincessEnvironment getEnv() {
        return this.env;
    }

    @Override
    public void push(int levels) {
        for (int i = 0; i < levels; ++i) {
            this.api.push();
            this.trackingStack.addLast(new Level());
        }
    }

    @Override
    public void pop(int levels) {
        ArrayDeque<Level> toAdd = new ArrayDeque<Level>(levels);
        for (int i = 0; i < levels; ++i) {
            this.api.pop();
            toAdd.add(this.trackingStack.removeLast());
        }
        for (Level level : toAdd) {
            this.api.addBooleanVariables(JavaConversions.asScalaIterable(level.booleanSymbols));
            this.api.addConstants(JavaConversions.asScalaIterable(level.intSymbols));
            for (IFunction iFunction : level.functionSymbols) {
                this.api.addFunction(iFunction);
            }
            for (Pair pair : level.abbreviations) {
                this.api.addAbbrev((IFormula)pair.getFirst(), (IFormula)pair.getSecond());
            }
            if (this.trackingStack.isEmpty()) continue;
            this.trackingStack.getLast().mergeWithHigher(level);
        }
    }

    @Override
    public void assertTerm(IFormula booleanFormula) {
        this.api.addAssertion(booleanFormula);
    }

    @Override
    public void assertTermInPartition(IFormula booleanFormula, int index) {
        this.api.setPartitionNumber(index);
        this.api.addAssertion(booleanFormula);
        this.api.setPartitionNumber(-1);
    }

    @Override
    public boolean checkSat() {
        Enumeration.Value result = this.api.checkSat(true);
        if (result == SimpleAPI.ProverStatus$.MODULE$.Sat()) {
            return true;
        }
        if (result == SimpleAPI.ProverStatus$.MODULE$.Unsat()) {
            return false;
        }
        throw new AssertionError((Object)("checkSat returned " + result));
    }

    @Override
    public SimpleAPI.PartialModel getPartialModel() {
        return this.api.partialModel();
    }

    @Override
    public List<IFormula> getInterpolants(List<Set<Integer>> partitions) {
        ArrayBuffer args = new ArrayBuffer();
        for (Set<Integer> partition : partitions) {
            args.$plus$eq((Object)JavaConversions.asScalaSet(partition).toSet());
        }
        Seq itps = this.api.getInterpolants(args.toSeq());
        assert (itps.length() == partitions.size() - 1) : "There should be (n-1) interpolants for n partitions";
        return ImmutableList.copyOf((Collection)JavaConversions.asJavaCollection((Iterable)itps));
    }

    @Override
    public void close() {
        this.env.unregisterStack(this);
        this.api.shutDown();
    }

    void addSymbol(IFormula f) {
        this.api.addBooleanVariable(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().booleanSymbols.add(f);
        }
    }

    void addSymbol(ITerm f) {
        this.api.addConstant(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().intSymbols.add(f);
        }
    }

    void addSymbol(IFunction f) {
        this.api.addFunction(f);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().functionSymbols.add(f);
        }
    }

    void addAbbrev(IFormula abbrev, IFormula formula) {
        this.api.addAbbrev(abbrev, formula);
        if (!this.trackingStack.isEmpty()) {
            this.trackingStack.getLast().abbreviations.add((Pair<IFormula, IFormula>)Pair.of((Object)abbrev, (Object)formula));
        }
    }

    private static class Level {
        List<IFormula> booleanSymbols = new ArrayList<IFormula>();
        List<ITerm> intSymbols = new ArrayList<ITerm>();
        List<IFunction> functionSymbols = new ArrayList<IFunction>();
        List<Pair<IFormula, IFormula>> abbreviations = new ArrayList<Pair<IFormula, IFormula>>();

        private Level() {
        }

        void mergeWithHigher(Level other) {
            this.booleanSymbols.addAll(other.booleanSymbols);
            this.intSymbols.addAll(other.intSymbols);
            this.functionSymbols.addAll(other.functionSymbols);
            this.abbreviations.addAll(other.abbreviations);
        }
    }
}

