/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.PrintWriter;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolInterpolatingProver;

class LoggingSmtInterpolInterpolatingProver
extends SmtInterpolInterpolatingProver {
    private final PrintWriter out;

    LoggingSmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr, PrintWriter pOut) {
        super(pMgr);
        this.out = (PrintWriter)Preconditions.checkNotNull((Object)pOut);
    }

    @Override
    protected void pushAndAssert(Term pTerm) {
        this.out.println("(push 1)");
        this.out.println(this.mgr.dumpFormula(pTerm));
        super.pushAndAssert(pTerm);
    }

    @Override
    public void pop() {
        this.out.println("(pop 1)");
        super.pop();
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        this.out.println("(check-sat)");
        return super.isUnsat();
    }

    @Override
    protected BooleanFormula getInterpolant(Term pTermA, Term pTermB) {
        this.out.println("(get-interpolants " + pTermA + " " + pTermB + ")");
        return super.getInterpolant(pTermA, pTermB);
    }

    @Override
    public void close() {
        this.out.close();
        super.close();
    }
}

