/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUtil;

class SmtInterpolBooleanFormulaManager
extends AbstractBooleanFormulaManager<Term, Sort, SmtInterpolEnvironment> {
    private final Theory theory;

    SmtInterpolBooleanFormulaManager(SmtInterpolFormulaCreator creator, Theory pTheory) {
        super(creator);
        this.theory = pTheory;
    }

    @Override
    public Term makeVariableImpl(String varName) {
        return (Term)this.getFormulaCreator().makeVariable(this.getFormulaCreator().getBoolType(), varName);
    }

    @Override
    public Term makeBooleanImpl(boolean pValue) {
        ApplicationTerm t = pValue ? this.theory.mTrue : this.theory.mFalse;
        return t;
    }

    @Override
    public Term equivalence(Term t1, Term t2) {
        assert (SmtInterpolUtil.isBoolean(t1) && SmtInterpolUtil.isBoolean(t2)) : "Cannot make equivalence of non-boolean terms:\nTerm 1:\n" + t1.toStringDirect() + "\nTerm 2:\n" + t2.toStringDirect();
        return this.theory.equals(new Term[]{t1, t2});
    }

    @Override
    public boolean isTrue(Term t) {
        return SmtInterpolUtil.isTrue(t);
    }

    @Override
    public boolean isFalse(Term t) {
        return SmtInterpolUtil.isFalse(t);
    }

    @Override
    public Term ifThenElse(Term condition, Term t1, Term t2) {
        return this.theory.ifthenelse(condition, t1, t2);
    }

    @Override
    public Term not(Term pBits) {
        return this.theory.not(pBits);
    }

    @Override
    public Term and(Term pBits1, Term pBits2) {
        return this.theory.and(new Term[]{pBits1, pBits2});
    }

    @Override
    protected Term andImpl(List<Term> pParams) {
        return this.theory.and(SmtInterpolUtil.toTermArray(pParams));
    }

    @Override
    public Term or(Term pBits1, Term pBits2) {
        return this.theory.or(new Term[]{pBits1, pBits2});
    }

    @Override
    protected Term orImpl(List<Term> pParams) {
        return this.theory.or(SmtInterpolUtil.toTermArray(pParams));
    }

    @Override
    public Term xor(Term pBits1, Term pBits2) {
        return this.theory.xor(pBits1, pBits2);
    }

    @Override
    public boolean isNot(Term pBits) {
        return SmtInterpolUtil.isNot(pBits);
    }

    @Override
    public boolean isAnd(Term pBits) {
        return SmtInterpolUtil.isAnd(pBits);
    }

    @Override
    public boolean isOr(Term pBits) {
        return SmtInterpolUtil.isOr(pBits);
    }

    @Override
    public boolean isXor(Term pBits) {
        return SmtInterpolUtil.isXor(pBits);
    }

    @Override
    protected boolean isEquivalence(Term pBits) {
        return SmtInterpolUtil.isEquivalence(pBits);
    }

    @Override
    protected boolean isImplication(Term pFormula) {
        return SmtInterpolUtil.isImplication(pFormula);
    }

    @Override
    protected boolean isIfThenElse(Term pBits) {
        return SmtInterpolUtil.isIfThenElse(pBits);
    }
}

