/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUtil;

class SmtInterpolFormulaCreator
extends FormulaCreator<Term, Sort, SmtInterpolEnvironment> {
    SmtInterpolFormulaCreator(SmtInterpolEnvironment env) {
        super(env, env.getBooleanSort(), env.getIntegerSort(), env.getRealSort());
    }

    @Override
    public FormulaType<?> getFormulaType(Term pFormula) {
        if (SmtInterpolUtil.isBoolean(pFormula)) {
            return FormulaType.BooleanType;
        }
        if (SmtInterpolUtil.hasIntegerType(pFormula)) {
            return FormulaType.IntegerType;
        }
        if (SmtInterpolUtil.hasRationalType(pFormula)) {
            return FormulaType.RationalType;
        }
        throw new IllegalArgumentException("Unknown formula type");
    }

    @Override
    public Term makeVariable(Sort type, String varName) {
        SmtInterpolEnvironment env = (SmtInterpolEnvironment)this.getEnv();
        env.declareFun(varName, new Sort[0], type);
        return env.term(varName, new Term[0]);
    }

    @Override
    public Sort getBitvectorType(int pBitwidth) {
        throw new UnsupportedOperationException("Bitvector theory is not supported by SmtInterpol");
    }

    @Override
    public Sort getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by SmtInterpol");
    }

    @Override
    public Sort getArrayType(Sort pIndexType, Sort pElementType) {
        throw new IllegalArgumentException("SmtInterpol.getArrayType(): Implement me!");
    }
}

