/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import com.google.common.collect.Iterables;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolBooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolIntegerFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolRationalFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUnsafeFormulaManager;

class SmtInterpolFormulaManager
extends AbstractFormulaManager<Term, Sort, SmtInterpolEnvironment> {
    private SmtInterpolFormulaManager(SmtInterpolFormulaCreator pCreator, SmtInterpolUnsafeFormulaManager pUnsafeManager, SmtInterpolFunctionFormulaManager pFunctionManager, SmtInterpolBooleanFormulaManager pBooleanManager, SmtInterpolIntegerFormulaManager pIntegerManager, SmtInterpolRationalFormulaManager pRationalManager) {
        super(pCreator, pUnsafeManager, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, null, null, null, null);
    }

    public static SmtInterpolFormulaManager create(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate smtLogfile) throws InvalidConfigurationException {
        SmtInterpolEnvironment env = new SmtInterpolEnvironment(config, logger, pShutdownNotifier, smtLogfile);
        SmtInterpolFormulaCreator creator = new SmtInterpolFormulaCreator(env);
        SmtInterpolUnsafeFormulaManager unsafeManager = new SmtInterpolUnsafeFormulaManager(creator);
        SmtInterpolFunctionFormulaManager functionTheory = new SmtInterpolFunctionFormulaManager(creator, unsafeManager);
        SmtInterpolBooleanFormulaManager booleanTheory = new SmtInterpolBooleanFormulaManager(creator, env.getTheory());
        SmtInterpolIntegerFormulaManager integerTheory = new SmtInterpolIntegerFormulaManager(creator, functionTheory);
        SmtInterpolRationalFormulaManager rationalTheory = new SmtInterpolRationalFormulaManager(creator, functionTheory);
        return new SmtInterpolFormulaManager(creator, unsafeManager, functionTheory, booleanTheory, integerTheory, rationalTheory);
    }

    @Override
    public ProverEnvironment newProverEnvironment(boolean pGenerateModels, boolean pGenerateUnsatCore) {
        return ((SmtInterpolEnvironment)this.getEnvironment()).createProver(this);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(boolean pShared) {
        return ((SmtInterpolEnvironment)this.getEnvironment()).getInterpolator(this);
    }

    @Override
    public OptEnvironment newOptEnvironment() {
        throw new UnsupportedOperationException("SMTInterpol does not support optimization");
    }

    BooleanFormula encapsulateBooleanFormula(Term t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.encapsulateBooleanFormula((Term)Iterables.getOnlyElement(((SmtInterpolEnvironment)this.getEnvironment()).parseStringToTerms(pS)));
    }

    @Override
    public Appender dumpFormula(final Term formula) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                HashSet<Term> seen = new HashSet<Term>();
                ArrayDeque<Term> todo = new ArrayDeque<Term>();
                PrintTerm termPrinter = new PrintTerm();
                todo.addLast(formula);
                while (!todo.isEmpty()) {
                    Term t = (Term)todo.removeLast();
                    while (t instanceof AnnotatedTerm) {
                        t = ((AnnotatedTerm)t).getSubterm();
                    }
                    if (!(t instanceof ApplicationTerm) || !seen.add(t)) continue;
                    ApplicationTerm term = (ApplicationTerm)t;
                    Collections.addAll(todo, term.getParameters());
                    FunctionSymbol func = term.getFunction();
                    if (func.isIntern()) continue;
                    if (func.getDefinition() == null) {
                        out.append("(declare-fun ");
                        out.append(PrintTerm.quoteIdentifier((String)func.getName()));
                        out.append(" (");
                        for (Sort paramSort : func.getParameterSorts()) {
                            termPrinter.append(out, paramSort);
                            out.append(' ');
                        }
                        out.append(") ");
                        termPrinter.append(out, func.getReturnSort());
                        out.append(")\n");
                        continue;
                    }
                    throw new IllegalArgumentException("Terms with definition are unsupported.");
                }
                out.append("(assert ");
                Term letted = new FormulaLet().let(formula);
                termPrinter.append(out, letted);
                out.append(")");
            }
        };
    }

    @Override
    public String getVersion() {
        return ((SmtInterpolEnvironment)this.getEnvironment()).getVersion();
    }

    SmtInterpolEnvironment createEnvironment() {
        assert (this.getEnvironment() != null);
        return (SmtInterpolEnvironment)this.getEnvironment();
    }
}

