/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolNumeralFormulaManager;

class SmtInterpolIntegerFormulaManager
extends SmtInterpolNumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> {
    SmtInterpolIntegerFormulaManager(SmtInterpolFormulaCreator pCreator, SmtInterpolFunctionFormulaManager pFunctionManager) {
        super(pCreator, pFunctionManager);
    }

    @Override
    public FormulaType<NumeralFormula.IntegerFormula> getFormulaType() {
        return FormulaType.IntegerType;
    }

    @Override
    protected Term makeNumberImpl(long i) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).numeral(BigInteger.valueOf(i));
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).numeral(pI);
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).numeral(pI);
    }

    @Override
    protected Term makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Term makeNumberImpl(BigDecimal pNumber) {
        return (Term)this.decimalAsInteger(pNumber);
    }

    @Override
    protected Term makeVariableImpl(String varName) {
        Sort t = (Sort)this.getFormulaCreator().getIntegerType();
        return (Term)this.getFormulaCreator().makeVariable(t, varName);
    }
}

