/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolModel;

class SmtInterpolInterpolatingProver
implements InterpolatingProverEnvironment<String> {
    protected final SmtInterpolFormulaManager mgr;
    private SmtInterpolEnvironment env;
    private final List<String> assertedFormulas;
    private final Map<String, Term> annotatedTerms;
    private static final String prefix = "term_";
    private static final UniqueIdGenerator termIdGenerator = new UniqueIdGenerator();

    SmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr) {
        this.mgr = pMgr;
        this.env = this.mgr.createEnvironment();
        this.assertedFormulas = new ArrayList<String>();
        this.annotatedTerms = new HashMap<String, Term>();
    }

    @Override
    public String push(BooleanFormula f) {
        Preconditions.checkNotNull((Object)this.env);
        Term t = (Term)this.mgr.extractInfo(f);
        String termName = prefix + termIdGenerator.getFreshId();
        Term annotatedTerm = this.env.annotate(t, new Annotation(":named", (Object)termName));
        this.pushAndAssert(annotatedTerm);
        this.assertedFormulas.add(termName);
        this.annotatedTerms.put(termName, t);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        return termName;
    }

    protected void pushAndAssert(Term annotatedTerm) {
        this.env.push(1);
        this.env.assertTerm(annotatedTerm);
    }

    @Override
    public void pop() {
        Preconditions.checkNotNull((Object)this.env);
        String removed = this.assertedFormulas.remove(this.assertedFormulas.size() - 1);
        this.annotatedTerms.remove(removed);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        this.env.pop(1);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        return !this.env.checkSat();
    }

    @Override
    public BooleanFormula getInterpolant(List<String> pTermNamesOfA) {
        Preconditions.checkNotNull((Object)this.env);
        HashSet<String> termNamesOfA = new HashSet<String>(pTermNamesOfA);
        ImmutableSet termNamesOfB = FluentIterable.from(this.assertedFormulas).filter(Predicates.not((Predicate)Predicates.in(termNamesOfA))).toSet();
        Term termA = this.buildConjunctionOfNamedTerms(termNamesOfA);
        Term termB = this.buildConjunctionOfNamedTerms((Set<String>)termNamesOfB);
        return this.getInterpolant(termA, termB);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<String>> partitionedTermNames) {
        Preconditions.checkNotNull((Object)this.env);
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        Term[] itps = this.env.getInterpolants(formulas);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    protected BooleanFormula getInterpolant(Term termA, Term termB) {
        Term[] itp = this.env.getInterpolants(new Term[]{termA, termB});
        assert (itp.length == 1);
        return this.mgr.encapsulateBooleanFormula(itp[0]);
    }

    private Term buildConjunctionOfNamedTerms(Set<String> termNames) {
        Term[] terms = new Term[termNames.size()];
        int i = 0;
        for (String termName : termNames) {
            terms[i] = this.env.term(termName, new Term[0]);
            ++i;
        }
        if (terms.length > 1) {
            return this.env.term("and", terms);
        }
        assert (terms.length != 0);
        return terms[0];
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.env);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        if (!this.assertedFormulas.isEmpty()) {
            this.env.pop(this.assertedFormulas.size());
            this.assertedFormulas.clear();
            this.annotatedTerms.clear();
        }
        this.env = null;
    }

    @Override
    public Model getModel() {
        Preconditions.checkNotNull((Object)this.env);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        return SmtInterpolModel.createSmtInterpolModel(this.env, this.annotatedTerms.values());
    }
}

