/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import com.google.common.base.Verify;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUtil;

class SmtInterpolModel {
    SmtInterpolModel() {
    }

    private static Model.TermType getType(Term t) {
        if (SmtInterpolUtil.isBoolean(t)) {
            return Model.TermType.Boolean;
        }
        if (SmtInterpolUtil.hasIntegerType(t)) {
            return Model.TermType.Integer;
        }
        if (SmtInterpolUtil.hasRationalType(t)) {
            return Model.TermType.Real;
        }
        throw new IllegalArgumentException("Given sort cannot be converted to a TermType: " + t.getSort());
    }

    private static Model.AssignableTerm toVariable(Term t) {
        if (!SmtInterpolUtil.isVariable(t)) {
            throw new IllegalArgumentException("Given term is no variable! (" + t.toString() + ")");
        }
        ApplicationTerm appTerm = (ApplicationTerm)t;
        String lName = appTerm.getFunction().getName();
        Model.TermType lType = SmtInterpolModel.getType((Term)appTerm);
        Pair<String, Integer> lSplitName = FormulaManagerView.parseName(lName);
        if (lSplitName.getSecond() != null) {
            return new Model.Variable((String)lSplitName.getFirst(), (Integer)lSplitName.getSecond(), lType);
        }
        return new Model.Constant((String)lSplitName.getFirst(), lType);
    }

    private static Model.Function toFunction(Term t, de.uni_freiburg.informatik.ultimate.logic.Model values) {
        if (SmtInterpolUtil.isVariable(t)) {
            throw new IllegalArgumentException("Given term is no function! (" + t.toString() + ")");
        }
        ApplicationTerm appTerm = (ApplicationTerm)t;
        String lName = appTerm.getFunction().getName();
        Model.TermType lType = SmtInterpolModel.getType((Term)appTerm);
        int lArity = SmtInterpolUtil.getArity((Term)appTerm);
        Object[] lArguments = new Object[lArity];
        for (int lArgumentIndex = 0; lArgumentIndex < lArity; ++lArgumentIndex) {
            Term lArgument = SmtInterpolUtil.getArg((Term)appTerm, lArgumentIndex);
            lArgument = values.evaluate(lArgument);
            lArguments[lArgumentIndex] = SmtInterpolModel.getValue(lArgument);
        }
        return new Model.Function(lName, lType, lArguments);
    }

    private static Model.AssignableTerm toAssignable(Term t, de.uni_freiburg.informatik.ultimate.logic.Model values) {
        assert (t instanceof ApplicationTerm) : "This is no ApplicationTerm: " + t.toString();
        if (SmtInterpolUtil.isVariable(t)) {
            return SmtInterpolModel.toVariable(t);
        }
        return SmtInterpolModel.toFunction(t, values);
    }

    private static Object getValue(Term value) {
        if (SmtInterpolUtil.isTrue(value)) {
            return true;
        }
        if (SmtInterpolUtil.isFalse(value)) {
            return false;
        }
        if (SmtInterpolUtil.isNumber(value)) {
            return SmtInterpolUtil.toNumber(value);
        }
        throw new IllegalArgumentException("SmtInterpol model term with expected value " + value);
    }

    static Model createSmtInterpolModel(SmtInterpolEnvironment env, Collection<Term> assertedFormulas) {
        de.uni_freiburg.informatik.ultimate.logic.Model values = env.getModel();
        LinkedHashMap<Model.AssignableTerm, Object> model = new LinkedHashMap<Model.AssignableTerm, Object>();
        for (Term lKeyTerm : SmtInterpolUtil.getVarsAndUIFs(assertedFormulas)) {
            Term lValueTerm = values.evaluate(lKeyTerm);
            Model.AssignableTerm lAssignable = SmtInterpolModel.toAssignable(lKeyTerm, values);
            Object lValue = SmtInterpolModel.getValue(lValueTerm);
            Object existingValue = model.get(lAssignable);
            Verify.verify((existingValue == null || lValue.equals(existingValue) ? 1 : 0) != 0, (String)"Duplicate values for model entry %s: %s and %s", (Object[])new Object[]{lAssignable, existingValue, lValue});
            model.put(lAssignable, lValue);
        }
        return new Model(model);
    }
}

