/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUtil;

abstract class SmtInterpolNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Term, Sort, SmtInterpolEnvironment, ParamFormulaType, ResultFormulaType> {
    private final SmtInterpolEnvironment env;

    SmtInterpolNumeralFormulaManager(SmtInterpolFormulaCreator pCreator, SmtInterpolFunctionFormulaManager pFunctionManager) {
        super(pCreator, pFunctionManager);
        this.env = (SmtInterpolEnvironment)pCreator.getEnv();
    }

    @Override
    public Term negate(Term pNumber) {
        return this.env.term("*", this.env.numeral("-1"), pNumber);
    }

    @Override
    public Term add(Term pNumber1, Term pNumber2) {
        return this.env.term("+", pNumber1, pNumber2);
    }

    @Override
    public Term subtract(Term pNumber1, Term pNumber2) {
        return this.env.term("-", pNumber1, pNumber2);
    }

    @Override
    public Term divide(Term pNumber1, Term pNumber2) {
        Term result = SmtInterpolUtil.isNumber(pNumber2) && (pNumber1.getSort().equals(pNumber1.getTheory().getRealSort()) || pNumber2.getSort().equals(pNumber1.getTheory().getRealSort())) ? this.env.term("/", pNumber1, pNumber2) : super.divide(pNumber1, pNumber2);
        return result;
    }

    @Override
    public Term multiply(Term pNumber1, Term pNumber2) {
        Term result = SmtInterpolUtil.isNumber(pNumber1) || SmtInterpolUtil.isNumber(pNumber2) ? this.env.term("*", pNumber1, pNumber2) : super.multiply(pNumber1, pNumber2);
        return result;
    }

    @Override
    protected Term modularCongruence(Term pNumber1, Term pNumber2, long pModulo) {
        return this.env.getTheory().mTrue;
    }

    @Override
    public Term equal(Term pNumber1, Term pNumber2) {
        return this.env.term("=", pNumber1, pNumber2);
    }

    @Override
    public boolean isEqual(Term pNumber) {
        return SmtInterpolUtil.isNumeralEqual(pNumber);
    }

    @Override
    public Term greaterThan(Term pNumber1, Term pNumber2) {
        return this.env.term(">", pNumber1, pNumber2);
    }

    @Override
    public Term greaterOrEquals(Term pNumber1, Term pNumber2) {
        return this.env.term(">=", pNumber1, pNumber2);
    }

    @Override
    public Term lessThan(Term pNumber1, Term pNumber2) {
        return this.env.term("<", pNumber1, pNumber2);
    }

    @Override
    public Term lessOrEquals(Term pNumber1, Term pNumber2) {
        return this.env.term("<=", pNumber1, pNumber2);
    }
}

