/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolNumeralFormulaManager;

class SmtInterpolRationalFormulaManager
extends SmtInterpolNumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula> {
    SmtInterpolRationalFormulaManager(SmtInterpolFormulaCreator pCreator, SmtInterpolFunctionFormulaManager pFunctionManager) {
        super(pCreator, pFunctionManager);
    }

    @Override
    public FormulaType<NumeralFormula.RationalFormula> getFormulaType() {
        return FormulaType.RationalType;
    }

    @Override
    protected Term makeNumberImpl(long i) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).decimal(BigDecimal.valueOf(i));
    }

    @Override
    protected Term makeNumberImpl(BigInteger pI) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).decimal(new BigDecimal(pI));
    }

    @Override
    protected Term makeNumberImpl(String pI) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).decimal(pI);
    }

    @Override
    protected Term makeNumberImpl(double pNumber) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).decimal(BigDecimal.valueOf(pNumber));
    }

    @Override
    protected Term makeNumberImpl(BigDecimal pNumber) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).decimal(pNumber);
    }

    @Override
    protected Term makeVariableImpl(String varName) {
        Sort t = (Sort)this.getFormulaCreator().getRationalType();
        return (Term)this.getFormulaCreator().makeVariable(t, varName);
    }
}

