/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.time.NestedTimer;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolModel;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUtil;

class SmtInterpolTheoremProver
implements ProverEnvironment {
    private final SmtInterpolFormulaManager mgr;
    private final ShutdownNotifier shutdownNotifier;
    private SmtInterpolEnvironment env;
    private final List<Term> assertedTerms;

    SmtInterpolTheoremProver(SmtInterpolFormulaManager pMgr, ShutdownNotifier pShutdownNotifier) {
        this.mgr = pMgr;
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.assertedTerms = new ArrayList<Term>();
        this.env = this.mgr.createEnvironment();
        Preconditions.checkNotNull((Object)this.env);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        return !this.env.checkSat();
    }

    @Override
    public Model getModel() {
        Preconditions.checkNotNull((Object)this.env);
        return SmtInterpolModel.createSmtInterpolModel(this.env, this.assertedTerms);
    }

    @Override
    public void pop() {
        Preconditions.checkNotNull((Object)this.env);
        this.assertedTerms.remove(this.assertedTerms.size() - 1);
        this.env.pop(1);
    }

    @Override
    public Void push(BooleanFormula f) {
        Preconditions.checkNotNull((Object)this.env);
        Term t = (Term)this.mgr.extractInfo(f);
        this.assertedTerms.add(t);
        this.env.push(1);
        this.env.assertTerm(t);
        return null;
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.env);
        if (!this.assertedTerms.isEmpty()) {
            this.env.pop(this.assertedTerms.size());
            this.assertedTerms.clear();
        }
        this.env = null;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkNotNull((Object)this.env);
        Term[] terms = this.env.getUnsatCore();
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>(terms.length);
        for (Term t : terms) {
            result.add(this.mgr.encapsulateBooleanFormula(t));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProverEnvironment.AllSatResult allSat(Collection<BooleanFormula> formulas, AbstractionManager.RegionCreator rmgr, Timer solveTime, NestedTimer enumTime) throws InterruptedException {
        Preconditions.checkNotNull((Object)rmgr);
        Preconditions.checkNotNull((Object)solveTime);
        Preconditions.checkNotNull((Object)enumTime);
        Preconditions.checkArgument((!formulas.isEmpty() ? 1 : 0) != 0);
        SmtInterpolEnvironment allsatEnv = this.env;
        Preconditions.checkNotNull((Object)allsatEnv);
        SmtInterpolAllSatCallback result = new SmtInterpolAllSatCallback(rmgr, solveTime, enumTime);
        Term[] importantTerms = new Term[formulas.size()];
        int i = 0;
        for (BooleanFormula impF : formulas) {
            importantTerms[i++] = (Term)this.mgr.extractInfo(impF);
        }
        solveTime.start();
        try {
            allsatEnv.push(1);
            for (Term[] model : allsatEnv.checkAllSat(importantTerms)) {
                this.shutdownNotifier.shutdownIfNecessary();
                result.callback(model);
            }
            this.shutdownNotifier.shutdownIfNecessary();
            allsatEnv.pop(1);
        }
        finally {
            if (solveTime.isRunning()) {
                solveTime.stop();
            } else {
                enumTime.stopOuter();
            }
        }
        return result;
    }

    class SmtInterpolAllSatCallback
    implements ProverEnvironment.AllSatResult {
        private final AbstractionManager.RegionCreator rmgr;
        private final RegionManager.RegionBuilder builder;
        private final Timer solveTime;
        private final NestedTimer enumTime;
        private Timer regionTime = null;
        private int count = 0;
        private Region formula = null;

        public SmtInterpolAllSatCallback(AbstractionManager.RegionCreator rmgr, Timer pSolveTime, NestedTimer pEnumTime) {
            this.rmgr = rmgr;
            this.solveTime = pSolveTime;
            this.enumTime = pEnumTime;
            this.builder = rmgr.newRegionBuilder(SmtInterpolTheoremProver.this.shutdownNotifier);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Region getResult() throws InterruptedException {
            if (this.formula == null) {
                this.enumTime.startBoth();
                try {
                    this.formula = this.builder.getResult();
                    this.builder.close();
                }
                finally {
                    this.enumTime.stopBoth();
                }
            }
            return this.formula;
        }

        public void callback(Term[] model) {
            if (this.count == 0) {
                this.solveTime.stop();
                this.enumTime.startOuter();
                this.regionTime = this.enumTime.getCurentInnerTimer();
            }
            this.regionTime.start();
            this.builder.startNewConjunction();
            for (Term t : model) {
                if (SmtInterpolUtil.isNot(t)) {
                    t = SmtInterpolUtil.getArg(t, 0);
                    this.builder.addNegativeRegion(this.rmgr.getPredicate(this.encapsulate(t)));
                    continue;
                }
                this.builder.addPositiveRegion(this.rmgr.getPredicate(this.encapsulate(t)));
            }
            this.builder.finishConjunction();
            ++this.count;
            this.regionTime.stop();
        }

        private BooleanFormula encapsulate(Term pT) {
            return SmtInterpolTheoremProver.this.mgr.encapsulateBooleanFormula(pT);
        }
    }
}

