/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolUtil;

class SmtInterpolUnsafeFormulaManager
extends AbstractUnsafeFormulaManager<Term, Sort, SmtInterpolEnvironment> {
    SmtInterpolUnsafeFormulaManager(SmtInterpolFormulaCreator pCreator) {
        super(pCreator);
    }

    static String dequote(String s) {
        return s.replace("|", "");
    }

    private static String convertQuotes(String s) {
        return s.replace("|", "\"");
    }

    @Override
    public boolean isAtom(Term t) {
        return SmtInterpolUtil.isAtom(t);
    }

    @Override
    public boolean isLiteral(Term t) {
        return SmtInterpolUtil.isNot(t) || SmtInterpolUtil.isAtom(t);
    }

    @Override
    public int getArity(Term pT) {
        return SmtInterpolUtil.getArity(pT);
    }

    @Override
    public Term getArg(Term pT, int pN) {
        return SmtInterpolUtil.getArg(pT, pN);
    }

    @Override
    public boolean isVariable(Term pT) {
        return SmtInterpolUtil.isVariable(pT);
    }

    @Override
    public boolean isUF(Term t) {
        return SmtInterpolUtil.isUIF(t);
    }

    @Override
    public String getName(Term t) {
        if (this.isVariable(t)) {
            return SmtInterpolUnsafeFormulaManager.dequote(t.toString());
        }
        if (this.isUF(t)) {
            return ((ApplicationTerm)t).getFunction().getName();
        }
        throw new IllegalArgumentException("The Term " + t + " has no name!");
    }

    @Override
    public Term replaceArgs(Term pT, List<Term> newArgs) {
        return SmtInterpolUtil.replaceArgs((SmtInterpolEnvironment)this.getFormulaCreator().getEnv(), pT, SmtInterpolUtil.toTermArray(newArgs));
    }

    @Override
    public Term replaceName(Term t, String pNewName) {
        if (this.isVariable(t)) {
            return (Term)this.getFormulaCreator().makeVariable(t.getSort(), pNewName);
        }
        if (this.isUF(t)) {
            ApplicationTerm at = (ApplicationTerm)t;
            Term[] args = at.getParameters();
            Sort[] sorts = new Sort[args.length];
            for (int i = 0; i < sorts.length; ++i) {
                sorts[i] = args[i].getSort();
            }
            ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).declareFun(pNewName, sorts, t.getSort());
            return this.createUIFCallImpl(pNewName, args);
        }
        throw new IllegalArgumentException("The Term " + t + " has no name!");
    }

    Term createUIFCallImpl(String funcDecl, Term[] args) {
        Term ufc = ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).term(funcDecl, args);
        assert (SmtInterpolUtil.isUIF(ufc));
        return ufc;
    }

    @Override
    public boolean isNumber(Term pT) {
        return SmtInterpolUtil.isNumber(pT);
    }

    @Override
    protected Term substitute(Term expr, List<Term> substituteFrom, List<Term> substituteTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term simplify(Term pF) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).simplify(pF);
    }

    @Override
    protected boolean isQuantification(Term pT) {
        return false;
    }

    @Override
    protected Term getQuantifiedBody(Term pT) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Term replaceQuantifiedBody(Term pF, Term pBody) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isFreeVariable(Term pT) {
        return this.isVariable(pT);
    }

    @Override
    protected boolean isBoundVariable(Term pT) {
        return false;
    }
}

