/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.smtInterpol;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolEnvironment;

class SmtInterpolUtil {
    private SmtInterpolUtil() {
    }

    public static boolean isAtom(Term t) {
        boolean is;
        boolean bl = is = !SmtInterpolUtil.isAnd(t) && !SmtInterpolUtil.isOr(t) && !SmtInterpolUtil.isNot(t) && !SmtInterpolUtil.isImplication(t) && !SmtInterpolUtil.isIfThenElse(t);
        assert (is || SmtInterpolUtil.isBoolean(t));
        return is;
    }

    public static boolean isVariable(Term t) {
        return !SmtInterpolUtil.isTrue(t) && !SmtInterpolUtil.isFalse(t) && t instanceof ApplicationTerm && ((ApplicationTerm)t).getParameters().length == 0 && ((ApplicationTerm)t).getFunction().getDefinition() == null;
    }

    public static boolean isUIF(Term t) {
        if (!(t instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)t;
        FunctionSymbol func = applicationTerm.getFunction();
        return applicationTerm.getParameters().length > 0 && !func.isIntern() && !func.isInterpreted();
    }

    public static boolean isNumber(Term t) {
        boolean is = false;
        if (t instanceof ConstantTerm) {
            Object value = ((ConstantTerm)t).getValue();
            if (value instanceof Number || value instanceof Rational) {
                is = true;
            }
        } else if (t instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)t;
            if ("-".equals(at.getFunction().getName()) && at.getParameters().length == 1 && SmtInterpolUtil.isNumber(at.getParameters()[0])) {
                is = true;
            } else if ("/".equals(at.getFunction().getName()) && at.getParameters().length == 2 && SmtInterpolUtil.isNumber(at.getParameters()[0]) && SmtInterpolUtil.isNumber(at.getParameters()[1])) {
                is = true;
            }
        }
        return is;
    }

    public static Object toNumber(Term t) {
        ApplicationTerm at;
        assert (SmtInterpolUtil.isNumber(t)) : "term is not a number: " + t;
        if (t instanceof ConstantTerm) {
            Object value = ((ConstantTerm)t).getValue();
            if (value instanceof Number) {
                return value;
            }
            if (value instanceof Rational) {
                Rational rat = (Rational)value;
                if (t.getSort().getName().equals("Int") && rat.isIntegral()) {
                    return rat.numerator();
                }
                return org.sosy_lab.cpachecker.util.rationals.Rational.of(rat.numerator(), rat.denominator());
            }
        } else if (t instanceof ApplicationTerm && "-".equals((at = (ApplicationTerm)t).getFunction().getName())) {
            Object value = SmtInterpolUtil.toNumber(at.getParameters()[0]);
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).negate();
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).negate();
            }
            if (value instanceof Long) {
                return -((Long)value).longValue();
            }
            if (value instanceof Integer) {
                return -((Integer)value).intValue();
            }
            if (value instanceof Double) {
                return -((Double)value).doubleValue();
            }
            if (value instanceof Float) {
                return Float.valueOf(-((Float)value).floatValue());
            }
            if (value instanceof org.sosy_lab.cpachecker.util.rationals.Rational) {
                return ((org.sosy_lab.cpachecker.util.rationals.Rational)value).negate();
            }
        }
        throw new NumberFormatException("unknown format of numeric term: " + t);
    }

    public static boolean isBoolean(Term t) {
        return t.getTheory().getBooleanSort() == t.getSort();
    }

    public static boolean hasIntegerType(Term t) {
        return t.getTheory().getNumericSort() == t.getSort();
    }

    public static boolean hasRationalType(Term t) {
        return t.getTheory().getRealSort() == t.getSort();
    }

    public static boolean isAnd(Term t) {
        return SmtInterpolUtil.isFunction(t, t.getTheory().mAnd);
    }

    public static boolean isOr(Term t) {
        return SmtInterpolUtil.isFunction(t, t.getTheory().mOr);
    }

    public static boolean isNot(Term t) {
        return SmtInterpolUtil.isFunction(t, t.getTheory().mNot);
    }

    public static boolean isImplication(Term t) {
        return SmtInterpolUtil.isFunction(t, t.getTheory().mImplies);
    }

    public static boolean isXor(Term t) {
        return SmtInterpolUtil.isFunction(t, t.getTheory().mXor);
    }

    public static boolean isIfThenElse(Term t) {
        return SmtInterpolUtil.isFunction(t, "ite");
    }

    public static boolean isEquivalence(Term t) {
        return SmtInterpolUtil.isFunction(t, "=") && SmtInterpolUtil.getArity(t) == 2 && SmtInterpolUtil.isBoolean(SmtInterpolUtil.getArg(t, 0)) && SmtInterpolUtil.isBoolean(SmtInterpolUtil.getArg(t, 1));
    }

    public static boolean isNumeralEqual(Term t) {
        return SmtInterpolUtil.isFunction(t, "=") && SmtInterpolUtil.getArity(t) == 2 && !SmtInterpolUtil.isBoolean(SmtInterpolUtil.getArg(t, 0)) && !SmtInterpolUtil.isBoolean(SmtInterpolUtil.getArg(t, 1));
    }

    public static boolean isFunction(Term t, String name) {
        return t instanceof ApplicationTerm && name.equals(((ApplicationTerm)t).getFunction().getName());
    }

    public static boolean isFunction(Term t, FunctionSymbol func) {
        return t instanceof ApplicationTerm && func == ((ApplicationTerm)t).getFunction();
    }

    public static int getArity(Term t) {
        if (t instanceof ApplicationTerm) {
            return ((ApplicationTerm)t).getParameters().length;
        }
        return 0;
    }

    public static Term getArg(Term t, int i) {
        if (t instanceof ApplicationTerm) {
            return ((ApplicationTerm)t).getParameters()[i];
        }
        return null;
    }

    public static boolean isTrue(Term t) {
        return t.getTheory().mTrue == t;
    }

    public static boolean isFalse(Term t) {
        return t.getTheory().mFalse == t;
    }

    public static Term replaceArgs(SmtInterpolEnvironment env, Term t, Term[] newParams) {
        if (t instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)t;
            Term[] oldParams = at.getParameters();
            assert (oldParams.length == newParams.length);
            for (int i = 0; i < newParams.length; ++i) {
                assert (oldParams[i].getSort() == newParams[i].getSort()) : "Cannot replace " + oldParams[i] + " with " + newParams[i] + ".";
            }
            FunctionSymbol funcSymb = at.getFunction();
            return env.term(funcSymb.getName(), funcSymb.getIndices(), null, newParams);
        }
        return t;
    }

    public static Set<Term> getVarsAndUIFs(Collection<Term> termList) {
        HashSet<Term> result = new HashSet<Term>();
        HashSet<Term> seen = new HashSet<Term>();
        ArrayDeque<Term> todo = new ArrayDeque<Term>(termList);
        while (!todo.isEmpty()) {
            Term t = (Term)todo.removeLast();
            if (!seen.add(t)) continue;
            if (SmtInterpolUtil.isVariable(t) || SmtInterpolUtil.isUIF(t)) {
                result.add(t);
            }
            if (!(t instanceof ApplicationTerm)) continue;
            Term[] params = ((ApplicationTerm)t).getParameters();
            Collections.addAll(todo, params);
        }
        return result;
    }

    static Term[] toTermArray(Collection<? extends Term> terms) {
        return terms.toArray(new Term[terms.size()]);
    }

    public static String prettyPrint(Term t) {
        StringBuilder str = new StringBuilder();
        SmtInterpolUtil.prettyPrint(t, str, 0);
        return str.toString();
    }

    private static void prettyPrint(Term t, StringBuilder str, int n) {
        for (int i = 0; i < n; ++i) {
            str.append("  ");
        }
        if (t instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)t;
            String function = at.getFunction().getName();
            if ("and".equals(function) || "or".equals(function)) {
                str.append("(").append(function).append("\n");
                for (Term child : at.getParameters()) {
                    SmtInterpolUtil.prettyPrint(child, str, n + 1);
                }
                for (int i = 0; i < n; ++i) {
                    str.append("  ");
                }
                str.append(")\n");
            } else {
                str.append(t.toStringDirect()).append("\n");
            }
        } else {
            str.append(t.toStringDirect()).append("\n");
        }
    }
}

