/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.matching.AbstractSmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResultImpl;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFormulaMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtFunctionApplicationPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtQuantificationPattern;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApiHelpers;

class Z3AstMatcher
extends AbstractSmtAstMatcher {
    private final long ctx;
    private final Z3FormulaManager fm;
    private final FormulaCreator<Long, Long, Long> fmc;

    public Z3AstMatcher(FormulaManager pMgr) {
        this.fm = (Z3FormulaManager)pMgr;
        this.ctx = (Long)this.fm.getEnvironment();
        this.fmc = this.fm.getFormulaCreator();
    }

    @Override
    protected SmtAstMatchResult internalPerform(Formula pParentFormula, Formula pRootFormula, Stack<String> pQuantifiedVariables, SmtAstPattern pP, Optional<Multimap<String, Formula>> pBindingRestrictions) {
        SmtAstMatchResultImpl result = new SmtAstMatchResultImpl();
        result.setMatchingRootFormula(pRootFormula);
        if (pP.getBindMatchTo().isPresent()) {
            String bindMatchTo = (String)pP.getBindMatchTo().get();
            result.putBoundVaribale(bindMatchTo, pRootFormula);
            result.putBoundVaribale(bindMatchTo + ".parent", pParentFormula);
            if (!bindMatchTo.contains("?") && pBindingRestrictions.isPresent()) {
                Collection variableAlreadyBoundTo = ((Multimap)pBindingRestrictions.get()).get((Object)bindMatchTo);
                assert (variableAlreadyBoundTo.size() <= 1);
                if (variableAlreadyBoundTo.size() > 0 && !variableAlreadyBoundTo.contains(pRootFormula)) {
                    return this.newMatchFailedResult(String.format("Binding of variable %s does not match!", bindMatchTo));
                }
            }
        }
        long ast = (Long)this.fm.extractInfo(pRootFormula);
        int astKind = Z3NativeApi.get_ast_kind(this.ctx, ast);
        switch (astKind) {
            case 0: 
            case 1: 
            case 2: {
                String bindMatchTo;
                int functionParameterCount;
                String functionSymbol;
                if (!(pP instanceof SmtFunctionApplicationPattern)) {
                    return this.newMatchFailedResult("No function application!");
                }
                SmtFunctionApplicationPattern fp = (SmtFunctionApplicationPattern)pP;
                if (fp.customFormulaMatcher.isPresent() && !((SmtFormulaMatcher)fp.customFormulaMatcher.get()).formulaMatches(this.fm, pRootFormula)) {
                    return this.newMatchFailedResult("Custom matcher not matched!");
                }
                if (astKind == 2) {
                    long index = Z3NativeApi.get_index_value(this.ctx, ast);
                    functionSymbol = "?" + index;
                    functionParameterCount = 0;
                } else if (astKind == 0) {
                    functionSymbol = Z3NativeApi.ast_to_string(this.ctx, ast);
                    functionParameterCount = 0;
                } else {
                    functionSymbol = Z3NativeApiHelpers.getDeclarationSymbolText(this.ctx, Z3NativeApi.get_app_decl(this.ctx, ast));
                    functionParameterCount = Z3NativeApi.get_app_num_args(this.ctx, ast);
                }
                if (functionParameterCount == 0 && pP.getBindMatchTo().isPresent() && (bindMatchTo = (String)pP.getBindMatchTo().get()).startsWith(".") && !pQuantifiedVariables.contains(functionSymbol)) {
                    return this.newMatchFailedResult("Variable not quantified");
                }
                ArrayList functionArguments = Lists.newArrayList();
                for (int i = 0; i < functionParameterCount; ++i) {
                    long argAst = Z3NativeApi.get_app_arg(this.ctx, ast, i);
                    Formula argFormula = this.encapsulateAstAsFormula(argAst);
                    functionArguments.add(argFormula);
                }
                return this.handleFunctionApplication(pRootFormula, pQuantifiedVariables, result, fp, functionSymbol, functionArguments, pBindingRestrictions);
            }
            case 3: {
                SmtQuantificationPattern.QuantifierType quantifierType;
                if (!(pP instanceof SmtQuantificationPattern)) {
                    return this.newMatchFailedResult("No function application!");
                }
                SmtQuantificationPattern qp = (SmtQuantificationPattern)pP;
                SmtQuantificationPattern.QuantifierType quantifierType2 = quantifierType = Z3NativeApi.is_quantifier_forall(this.ctx, ast) ? SmtQuantificationPattern.QuantifierType.FORALL : SmtQuantificationPattern.QuantifierType.EXISTS;
                if (qp.matchQuantificationWithType.isPresent() && !((SmtQuantificationPattern.QuantifierType)((Object)qp.matchQuantificationWithType.get())).equals((Object)quantifierType)) {
                    return this.newMatchFailedResult("Different quantifier!");
                }
                BooleanFormula bodyFormula = (BooleanFormula)this.encapsulateAstAsFormula(Z3NativeApi.get_quantifier_body(this.ctx, ast));
                ArrayList<QuantifiedVariable> boundVariables = this.getQuantifiedVariables(ast);
                int stackElementsBeforeRecursion = pQuantifiedVariables.size();
                for (QuantifiedVariable v : boundVariables) {
                    pQuantifiedVariables.push(v.getDeBruijnName());
                }
                SmtAstMatchResult r = this.handleQuantification(pRootFormula, pQuantifiedVariables, result, qp, quantifierType, boundVariables, bodyFormula, pBindingRestrictions);
                while (pQuantifiedVariables.size() > stackElementsBeforeRecursion) {
                    pQuantifiedVariables.pop();
                }
                return r;
            }
        }
        return this.newMatchFailedResult("Unknown structure (or elements) of formula!");
    }

    private ArrayList<QuantifiedVariable> getQuantifiedVariables(long ast) {
        ArrayList quantifiedVariables = Lists.newArrayList();
        int quantWeight = Z3NativeApi.get_quantifier_weight(this.ctx, ast);
        int boundCount = Z3NativeApi.get_quantifier_num_bound(this.ctx, ast);
        for (int b = 0; b < boundCount; ++b) {
            long boundVariableSort = Z3NativeApi.get_quantifier_bound_sort(this.ctx, ast, b);
            FormulaType<?> boundVariableType = ((Z3FormulaCreator)this.fmc).getFormulaTypeFromSort(boundVariableSort);
            String boundVariableName = Z3NativeApi.get_symbol_string(this.ctx, Z3NativeApi.get_quantifier_bound_name(this.ctx, ast, b));
            int deBruijnIndex = quantWeight - b;
            quantifiedVariables.add(new QuantifiedVariable(boundVariableType, boundVariableName, deBruijnIndex));
        }
        return quantifiedVariables;
    }

    private Formula encapsulateAstAsFormula(long ast) {
        Z3NativeApi.inc_ref(this.ctx, ast);
        FormulaType<?> formulaType = this.fmc.getFormulaType(ast);
        Object f = this.fmc.encapsulate(formulaType, ast);
        return f;
    }

    private SmtAstMatchResult handleQuantification(Formula pRootFormula, Stack<String> pQuantifiedVariables, SmtAstMatchResultImpl pResult, SmtQuantificationPattern pQp, SmtQuantificationPattern.QuantifierType pQuantifierType, ArrayList<QuantifiedVariable> pBoundVariables, BooleanFormula pBodyFormula, Optional<Multimap<String, Formula>> bBindingRestrictions) {
        List<BooleanFormula> bodyConjuncts = this.extractConjuncts(pBodyFormula, false);
        SmtAstMatchResult bodyMatchingResult = this.matchFormulaChildsInSequence(pRootFormula, pQuantifiedVariables, bodyConjuncts, pQp.quantorBodyMatchers, bBindingRestrictions, false);
        if (!bodyMatchingResult.matches() && bodyConjuncts.size() > 0) {
            bodyMatchingResult = this.matchFormulaChildsInSequence(pRootFormula, pQuantifiedVariables, bodyConjuncts, pQp.quantorBodyMatchers, bBindingRestrictions, true);
        }
        if (bodyMatchingResult.matches()) {
            pResult.addSubResults(bodyMatchingResult);
            return pResult;
        }
        return bodyMatchingResult;
    }

    private List<BooleanFormula> extractConjuncts(BooleanFormula pFormula, boolean pRecursive) {
        ArrayList result = Lists.newArrayList();
        long ast = (Long)this.fm.extractInfo(pFormula);
        int astKind = Z3NativeApi.get_ast_kind(this.ctx, ast);
        if (astKind == 1) {
            long decl = Z3NativeApi.get_app_decl(this.ctx, ast);
            long declKind = Z3NativeApi.get_decl_kind(this.ctx, decl);
            if (declKind == 261L) {
                int args = Z3NativeApi.get_app_num_args(this.ctx, ast);
                for (int i = 0; i < args; ++i) {
                    long argAst = Z3NativeApi.get_app_arg(this.ctx, ast, i);
                    BooleanFormula argFormula = (BooleanFormula)this.encapsulateAstAsFormula(argAst);
                    if (pRecursive) {
                        List<BooleanFormula> argFormulaChildConjuncts = this.extractConjuncts(argFormula, pRecursive);
                        result.addAll(argFormulaChildConjuncts);
                        continue;
                    }
                    result.add(argFormula);
                }
            } else {
                result.add(pFormula);
            }
        }
        return result;
    }

    @Override
    public <T1 extends Formula, T2 extends Formula> T1 substitute(T1 pF, Map<T2, T2> pFromToMapping) {
        return ((AbstractUnsafeFormulaManager)this.fm.getUnsafeFormulaManager()).substitute(pF, pFromToMapping);
    }

    protected static class QuantifiedVariable {
        final FormulaType<?> variableType;
        final String nameInFormula;
        final int deBruijnIndex;

        public QuantifiedVariable(FormulaType<?> pVariableType, String pNameInFormula, int pDeBruijnIndex) {
            this.variableType = pVariableType;
            this.nameInFormula = pNameInFormula;
            this.deBruijnIndex = pDeBruijnIndex;
        }

        public String getDeBruijnName() {
            return "?" + this.deBruijnIndex;
        }
    }
}

