/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class Z3AstMatchingTest0
extends SolverBasedTest0 {
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _al;
    private NumeralFormula.IntegerFormula _bl;
    private NumeralFormula.IntegerFormula _c1;
    private NumeralFormula.IntegerFormula _c2;
    private NumeralFormula.IntegerFormula _e1;
    private NumeralFormula.IntegerFormula _e2;
    private NumeralFormula.IntegerFormula _eX;
    private BooleanFormula _0_GEQ_al;
    private BooleanFormula _0_LESSTHAN_bl;
    private BooleanFormula _c1_times_ex_plus_e1_GEQ_0;
    private BooleanFormula _minus_c2_times_ex_plus_e2_GEQ_0;
    private Solver solver;
    private SmtAstMatcher matcher;
    private NumeralFormula.IntegerFormula _i1;
    private NumeralFormula.IntegerFormula _j1;
    private NumeralFormula.IntegerFormula _j2;
    private NumeralFormula.IntegerFormula _a1;
    private NumeralFormula.IntegerFormula _1;
    private NumeralFormula.IntegerFormula _minus1;
    private NumeralFormula.IntegerFormula _1_plus_a1;
    private BooleanFormula _not_j1_EQUALS_minus1;
    private BooleanFormula _i1_EQUALS_1_plus_a1;
    private NumeralFormula.IntegerFormula _j12_plus_a1;
    private BooleanFormula _j1_EQUALS_j2_plus_a1;
    private BooleanFormula _f_and_of_foo;
    private SmtAstPatternSelection elimPremisePattern1;
    private SmtAstPatternSelection elimPremisePattern2;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _x;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;
    private BooleanFormula _b_at_i_NOTEQ_0;
    private BooleanFormula _i_plus_1_LESSEQ_al;
    private BooleanFormula _b_at_i_plus_1_EQ_0;
    private BooleanFormula _0_EQ_b_at_i_plus_1_;
    private BooleanFormula _b_at_i_plus_1_NOTEQ_0;
    private NumeralFormula.IntegerFormula _i_plus_1;
    private BooleanFormula _b_at_i_EQ_0;
    private NumeralFormula.IntegerFormula _b_at_i;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Before
    public void setupEnvironment() throws Exception {
        this.setupMatcher();
        this.setupTestFormulas();
        this.setupTestPatterns();
    }

    @After
    public void closeEnvironment() throws Exception {
        this.solver.close();
    }

    public void setupMatcher() throws InvalidConfigurationException {
        FormulaManagerView fmv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.solver = new Solver(fmv, this.factory, this.config, TestLogManager.getInstance());
        Z3FormulaManager zfm = (Z3FormulaManager)this.mgr;
        this.matcher = this.solver.getSmtAstMatcher();
    }

    public void setupTestFormulas() throws Exception {
        this._0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        this._1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        this._minus1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-1L);
        this._al = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("al");
        this._bl = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("bl");
        this._c1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c1");
        this._c2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c2");
        this._e1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e1");
        this._e2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e2");
        this._eX = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("eX");
        this._i1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i@1");
        this._j1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("j@1");
        this._j2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("j@2");
        this._a1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a@1");
        this._c1_times_ex_plus_e1_GEQ_0 = this.imgr.greaterOrEquals(this.imgr.add(this.imgr.multiply(this._c1, this._eX), this._e1), this._0);
        this._minus_c2_times_ex_plus_e2_GEQ_0 = this.imgr.greaterOrEquals(this.imgr.add(this.imgr.multiply(this.imgr.subtract(this._0, this._c2), this._eX), this._e2), this._0);
        this._0_LESSTHAN_bl = this.imgr.lessThan(this._0, this._bl);
        this._0_GEQ_al = this.imgr.greaterOrEquals(this._0, this._al);
        this._1_plus_a1 = (NumeralFormula.IntegerFormula)this.imgr.add(this._1, this._a1);
        this._not_j1_EQUALS_minus1 = this.bmgr.not(this.imgr.equal(this._j1, this._minus1));
        this._i1_EQUALS_1_plus_a1 = this.imgr.equal(this._i1, this._1_plus_a1);
        this._j12_plus_a1 = (NumeralFormula.IntegerFormula)this.imgr.add(this._j2, this._a1);
        this._j1_EQUALS_j2_plus_a1 = this.imgr.equal(this._j1, this._j12_plus_a1);
        this._f_and_of_foo = this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{this._i1_EQUALS_1_plus_a1, this._not_j1_EQUALS_minus1, this._j1_EQUALS_j2_plus_a1}));
        this._i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        this._b = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._b_at_i_NOTEQ_0 = this.bmgr.not(this.imgr.equal((NumeralFormula)this.amgr.select(this._b, this._i), this._0));
        this._i_plus_1_LESSEQ_al = this.imgr.lessOrEquals(this.imgr.add(this._i, this._1), this._0);
        this._b_at_i_plus_1_EQ_0 = this.imgr.equal((NumeralFormula)this.amgr.select(this._b, (Formula)this.imgr.add(this._i, this._1)), this._0);
        this._0_EQ_b_at_i_plus_1_ = this.imgr.equal(this._0, (NumeralFormula)this.amgr.select(this._b, (Formula)this.imgr.add(this._i, this._1)));
    }

    public void setupTestPatterns() {
        this.elimPremisePattern1 = SmtAstPatternBuilder.withDefaultBinding("c1", this._0, SmtAstPatternBuilder.or(SmtAstPatternBuilder.match(">=", new SmtAstPattern[]{SmtAstPatternBuilder.match("+", new SmtAstPattern[]{SmtAstPatternBuilder.match("*", new SmtAstPattern[]{SmtAstPatternBuilder.matchNullaryBind("c1"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("eX")}), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e1")}), SmtAstPatternBuilder.matchNullary("0")}), SmtAstPatternBuilder.match(">=", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e1"), SmtAstPatternBuilder.matchNullary("0")})));
        this.elimPremisePattern2 = SmtAstPatternBuilder.withDefaultBinding("c2", this._0, SmtAstPatternBuilder.or(SmtAstPatternBuilder.match(">=", new SmtAstPattern[]{SmtAstPatternBuilder.match("+", new SmtAstPattern[]{SmtAstPatternBuilder.match("*", new SmtAstPattern[]{SmtAstPatternBuilder.match("-", new SmtAstPattern[]{SmtAstPatternBuilder.matchNullary("0"), SmtAstPatternBuilder.matchNullaryBind("c2")}), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("eX")}), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e2")}), SmtAstPatternBuilder.matchNullary("0")}), SmtAstPatternBuilder.match(">=", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e2"), SmtAstPatternBuilder.matchNullary("0")})));
    }

    @Test
    public void testLinearCombi1() {
        SmtAstMatchResult result1 = this.matcher.perform(this.elimPremisePattern1, this._0_GEQ_al);
        SmtAstMatchResult result2 = this.matcher.perform(this.elimPremisePattern1, this._0_LESSTHAN_bl);
        Truth.assertThat((Boolean)result1.matches()).isFalse();
        Truth.assertThat((Boolean)result2.matches()).isFalse();
    }

    @Test
    public void testLinearCombi2() {
        SmtAstMatchResult result1 = this.matcher.perform(this.elimPremisePattern1, this._minus_c2_times_ex_plus_e2_GEQ_0);
        Truth.assertThat((Boolean)result1.matches()).isTrue();
    }

    @Test
    public void testLinearCombi5() {
        SmtAstMatchResult result1 = this.matcher.perform(this.elimPremisePattern2, this._c1_times_ex_plus_e1_GEQ_0);
        Truth.assertThat((Boolean)result1.matches()).isTrue();
    }

    @Test
    public void testLinearCombi3() {
        SmtAstMatchResult result2 = this.matcher.perform(this.elimPremisePattern1, this._c1_times_ex_plus_e1_GEQ_0);
        Truth.assertThat((Boolean)result2.matches()).isTrue();
        Truth.assertThat(result2.getVariableBindings("c1")).containsExactly(new Object[]{this._c1});
        Truth.assertThat(result2.getVariableBindings("eX")).containsExactly(new Object[]{this._eX});
    }

    @Test
    public void testLinearCombi4() {
        SmtAstMatchResult result3 = this.matcher.perform(this.elimPremisePattern2, this._minus_c2_times_ex_plus_e2_GEQ_0);
        Truth.assertThat((Boolean)result3.matches()).isTrue();
    }

    @Test
    public void t1() {
        SmtAstPatternSelection p1 = SmtAstPatternBuilder.or(SmtAstPatternBuilder.match("f", SmtAstPatternBuilder.and(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e"), SmtAstPatternBuilder.match("select", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("a"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("i")}))));
        SmtAstMatchResult r = this.matcher.perform(p1, this._0_EQ_b_at_i_plus_1_);
        Truth.assertThat((Boolean)r.matches()).isTrue();
    }

    @Test
    public void t2() {
        SmtAstPatternSelection p2 = SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchBind("not", "nf", new SmtAstPattern[]{SmtAstPatternBuilder.match(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e"), SmtAstPatternBuilder.match("select", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("a"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("j")}))}));
        SmtAstMatchResult r = this.matcher.perform(p2, this._b_at_i_NOTEQ_0);
        Truth.assertThat((Boolean)r.matches()).isTrue();
        SmtAstMatchResult rz = this.matcher.perform(p2, this._0_EQ_b_at_i_plus_1_);
        Truth.assertThat((Boolean)rz.matches()).isFalse();
    }

    @Test
    public void testRotation() {
        SmtAstPatternSelection p = SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchBind(">=", "f", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("a"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("b")}));
        SmtAstMatchResult r = this.matcher.perform(p, this.imgr.lessOrEquals(this.imgr.makeNumber(1L), this.imgr.makeNumber(2L)));
        Truth.assertThat((Boolean)r.matches()).isTrue();
        SmtAstMatchResult r2 = this.matcher.perform(p, this.imgr.greaterOrEquals(this.imgr.makeNumber(2L), this.imgr.makeNumber(1L)));
        Truth.assertThat((Boolean)r2.matches()).isTrue();
    }

    @Test
    public void testSubtreeMatching1() {
        this._0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        this._1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        this._i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        this._b = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._i_plus_1 = (NumeralFormula.IntegerFormula)this.imgr.add(this._i, this._1);
        this._b_at_i = this.amgr.select(this._b, this._i);
        this._b_at_i_EQ_0 = this.imgr.equal(this._b_at_i, this._0);
        this._b_at_i_NOTEQ_0 = this.bmgr.not(this._b_at_i_EQ_0);
        this._b_at_i_plus_1_NOTEQ_0 = this.bmgr.not(this.imgr.equal((NumeralFormula)this.amgr.select(this._b, this._i_plus_1), this._0));
        SmtAstPatternSelection pattern = SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchAnyBind("f", SmtAstPatternBuilder.matchInSubtree(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("x"))));
        SmtAstMatchResult r = this.matcher.perform(pattern, this._b_at_i_EQ_0);
        Truth.assertThat((Boolean)r.matches()).isTrue();
        Truth.assertThat(r.getVariableBindings("x")).contains((Object)this._b_at_i);
        r = this.matcher.perform(pattern, this._b_at_i_NOTEQ_0);
        Truth.assertThat((Boolean)r.matches()).isTrue();
        Truth.assertThat(r.getVariableBindings("x")).contains((Object)this._b_at_i_EQ_0);
    }

    @Test
    public void testSubtreeMatching2() {
        this._0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        this._1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        this._i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        this._b = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._i_plus_1 = (NumeralFormula.IntegerFormula)this.imgr.add(this._i, this._1);
        this._b_at_i = this.amgr.select(this._b, this._i);
        this._b_at_i_EQ_0 = this.imgr.equal(this._b_at_i, this._0);
        this._b_at_i_NOTEQ_0 = this.bmgr.not(this._b_at_i_EQ_0);
        this._b_at_i_plus_1_NOTEQ_0 = this.bmgr.not(this.imgr.equal((NumeralFormula)this.amgr.select(this._b, this._i_plus_1), this._0));
        SmtAstPatternSelection pattern = SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchAnyBind("f", SmtAstPatternBuilder.matchInSubtree(SmtAstPatternBuilder.matchNullaryBind("i", "x"))));
        SmtAstMatchResult result = this.matcher.perform(pattern, this._b_at_i_plus_1_NOTEQ_0);
        Truth.assertThat((Boolean)result.matches()).isTrue();
        Truth.assertThat(result.getVariableBindings("x")).contains((Object)this._i);
    }

    @Test
    public void testSubtreeMatchingBinding1() {
        SmtAstPatternSelection pattern = SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchAnyBind("f", SmtAstPatternBuilder.matchAny(SmtAstPatternBuilder.matchInSubtree(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("i")))));
        BooleanFormula input = this.imgr.lessThan(this._i, this._al);
        SmtAstMatchResult result = this.matcher.perform(pattern, input);
        Truth.assertThat((Boolean)result.matches()).isTrue();
        Truth.assertThat(result.getVariableBindings("i")).contains((Object)this._i);
    }

    @Test
    public void testSubtreeMatchingBinding2() {
        BooleanFormula input = this.imgr.lessThan(this._i, this._al);
        SmtAstPatternSelection pattern = SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchAnyBind("f", SmtAstPatternBuilder.match("select", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgs(), SmtAstPatternBuilder.matchInSubtree(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("i"))}), SmtAstPatternBuilder.matchAnyWithAnyArgs()), SmtAstPatternBuilder.matchAnyBind("f", SmtAstPatternBuilder.matchAny(SmtAstPatternBuilder.matchInSubtree(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("i")))));
        SmtAstMatchResult result = this.matcher.perform(pattern, input);
        Truth.assertThat((Boolean)result.matches()).isTrue();
        Truth.assertThat(result.getVariableBindings("i")).contains((Object)this._i);
    }

    @Test
    public void testCommutativenesOnTopLevel() {
    }
}

