/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3IntegerFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3RationalFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3SmtLogger;

class Z3FormulaCreator
extends FormulaCreator<Long, Long, Long> {
    private final Z3SmtLogger smtLogger;
    private final Table<Long, Long, Long> allocatedArraySorts = HashBasedTable.create();

    Z3FormulaCreator(long pEnv, long pBoolType, long pIntegerType, long pRealType, Z3SmtLogger smtLogger) {
        super(pEnv, pBoolType, pIntegerType, pRealType);
        this.smtLogger = smtLogger;
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        long z3context = (Long)this.getEnv();
        long symbol = Z3NativeApi.mk_string_symbol(z3context, varName);
        long var = Z3NativeApi.mk_const(z3context, symbol, type);
        this.smtLogger.logVarDeclaration(var, type);
        return var;
    }

    @Override
    public Long extractInfo(Formula pT) {
        return Z3FormulaManager.getZ3Expr(pT);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof ArrayFormula || pFormula instanceof BitvectorFormula) {
            long term = this.extractInfo(pFormula);
            return this.getFormulaType(term);
        }
        return super.getFormulaType(pFormula);
    }

    public FormulaType<?> getFormulaTypeFromSort(Long pSort) {
        long z3context = (Long)this.getEnv();
        long sortKind = Z3NativeApi.get_sort_kind(z3context, pSort);
        if (sortKind == 1L) {
            return FormulaType.BooleanType;
        }
        if (sortKind == 2L) {
            return FormulaType.IntegerType;
        }
        if (sortKind == 5L) {
            long domainSort = Z3NativeApi.get_array_sort_domain(z3context, pSort);
            long rangeSort = Z3NativeApi.get_array_sort_range(z3context, pSort);
            return FormulaType.getArrayType(this.getFormulaTypeFromSort(domainSort), this.getFormulaTypeFromSort(rangeSort));
        }
        if (sortKind == 3L) {
            return FormulaType.RationalType;
        }
        if (sortKind == 4L) {
            return FormulaType.getBitvectorTypeWithSize(Z3NativeApi.get_bv_sort_size(z3context, pSort));
        }
        throw new IllegalArgumentException("Unknown formula type");
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long sort = Z3NativeApi.get_sort((Long)this.getEnv(), pFormula);
        return this.getFormulaTypeFromSort(sort);
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        return ((Z3ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        return ((Z3ArrayFormula)pArray).getIndexType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> ArrayFormula<TD, TR> encapsulateArray(Long pTerm, FormulaType<TD> pIndexType, FormulaType<TR> pElementType) {
        return new Z3ArrayFormula<TD, TR>((Long)this.getEnv(), pTerm, pIndexType, pElementType);
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        if (pType.isBooleanType()) {
            return (T)new Z3BooleanFormula((Long)this.getEnv(), pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new Z3IntegerFormula((Long)this.getEnv(), pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new Z3RationalFormula((Long)this.getEnv(), pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)new Z3BitvectorFormula((Long)this.getEnv(), pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new Z3ArrayFormula<Formula, Formula>((Long)this.getEnv(), pTerm, arrFt.getIndexType(), arrFt.getElementType());
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in Z3");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        return new Z3BooleanFormula((Long)this.getEnv(), pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        return new Z3BitvectorFormula((Long)this.getEnv(), pTerm);
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        Long allocatedArraySort = (Long)this.allocatedArraySorts.get((Object)pIndexType, (Object)pElementType);
        if (allocatedArraySort == null) {
            allocatedArraySort = Z3NativeApi.mk_array_sort((Long)this.getEnv(), pIndexType, pElementType);
            Z3NativeApi.inc_ref((Long)this.getEnv(), allocatedArraySort);
            this.allocatedArraySorts.put((Object)pIndexType, (Object)pElementType, (Object)allocatedArraySort);
        }
        return allocatedArraySort;
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        Preconditions.checkArgument((pBitwidth > 0 ? 1 : 0) != 0, (String)"Cannot use bitvector type with size %s", (Object[])new Object[]{pBitwidth});
        long bvSort = Z3NativeApi.mk_bv_sort((Long)this.getEnv(), pBitwidth);
        Z3NativeApi.inc_ref((Long)this.getEnv(), Z3NativeApi.sort_to_ast((Long)this.getEnv(), bvSort));
        return bvSort;
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by Z3");
    }
}

