/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import java.io.IOException;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.NativeLibraries;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3ArrayFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3AstMatcher;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BitvectorFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3Formula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3IntegerFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3InterpolatingProver;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3OptProver;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3QuantifiedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3RationalFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3SmtLogger;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3TheoremProver;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3UnsafeFormulaManager;

@Options(prefix="cpa.predicate.solver.z3")
public class Z3FormulaManager
extends AbstractFormulaManager<Long, Long, Long> {
    @Option(secure=true, description="simplify formulas when they are asserted in a solver.")
    boolean simplifyFormulas = false;
    @Option(secure=true, description="Engine to use for the optimization", values={"basic", "farkas", "symba"})
    String optimizationEngine = "basic";
    @Option(secure=true, description="Ordering for objectives in the optimization context", values={"lex", "pareto", "box"})
    String objectivePrioritizationMode = "box";
    private final Z3SmtLogger z3smtLogger;
    private Z3AstMatcher z3astMatcher;
    private static final String OPT_ENGINE_CONFIG_KEY = "optsmt_engine";
    private static final String OPT_PRIORITY_CONFIG_KEY = "priority";

    private Z3FormulaManager(Z3FormulaCreator pFormulaCreator, Z3UnsafeFormulaManager pUnsafeManager, Z3FunctionFormulaManager pFunctionManager, Z3BooleanFormulaManager pBooleanManager, Z3IntegerFormulaManager pIntegerManager, Z3RationalFormulaManager pRationalManager, Z3BitvectorFormulaManager pBitpreciseManager, Z3QuantifiedFormulaManager pQuantifiedManager, Z3ArrayFormulaManager pArrayManager, Z3SmtLogger smtLogger, Configuration config) throws InvalidConfigurationException {
        super(pFormulaCreator, pUnsafeManager, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, null, pQuantifiedManager, pArrayManager);
        config.inject((Object)this);
        this.z3smtLogger = smtLogger;
        this.z3astMatcher = new Z3AstMatcher(this);
    }

    public static synchronized Z3FormulaManager create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile) throws InvalidConfigurationException {
        ExtraOptions extraOptions = new ExtraOptions();
        config.inject((Object)extraOptions);
        if (NativeLibraries.OS.guessOperatingSystem() == NativeLibraries.OS.WINDOWS) {
            NativeLibraries.loadLibrary("libz3");
        }
        NativeLibraries.loadLibrary("z3j");
        if (extraOptions.log != null) {
            Path absolutePath = extraOptions.log.toAbsolutePath();
            try {
                Files.writeFile((Path)absolutePath, (Object)"");
                Z3NativeApi.open_log(absolutePath.toString());
            }
            catch (IOException e) {
                logger.logUserException(Level.WARNING, (Throwable)e, "Cannot write Z3 log file");
            }
        }
        long cfg = Z3NativeApi.mk_config();
        Z3NativeApi.set_param_value(cfg, "MODEL", "true");
        if (extraOptions.requireProofs) {
            Z3NativeApi.set_param_value(cfg, "PROOF", "true");
        }
        final long context = Z3NativeApi.mk_context_rc(cfg);
        pShutdownNotifier.register(new ShutdownNotifier.ShutdownRequestListener(){

            @Override
            public void shutdownRequested(String reason) {
                Z3NativeApi.interrupt(context);
            }
        });
        Z3NativeApi.del_config(cfg);
        long boolSort = Z3NativeApi.mk_bool_sort(context);
        Z3NativeApi.inc_ref(context, Z3NativeApi.sort_to_ast(context, boolSort));
        long integerSort = Z3NativeApi.mk_int_sort(context);
        Z3NativeApi.inc_ref(context, Z3NativeApi.sort_to_ast(context, integerSort));
        long realSort = Z3NativeApi.mk_real_sort(context);
        Z3NativeApi.inc_ref(context, Z3NativeApi.sort_to_ast(context, realSort));
        Z3NativeApi.set_ast_print_mode(context, 3);
        Z3SmtLogger smtLogger = new Z3SmtLogger(context, config, solverLogfile);
        smtLogger.logOption("model", "true");
        if (extraOptions.requireProofs) {
            smtLogger.logOption("proof", "true");
        }
        Z3FormulaCreator creator = new Z3FormulaCreator(context, boolSort, integerSort, realSort, smtLogger);
        Z3UnsafeFormulaManager unsafeManager = new Z3UnsafeFormulaManager(creator);
        Z3FunctionFormulaManager functionTheory = new Z3FunctionFormulaManager(creator, unsafeManager, smtLogger);
        Z3BooleanFormulaManager booleanTheory = new Z3BooleanFormulaManager(creator);
        Z3IntegerFormulaManager integerTheory = new Z3IntegerFormulaManager(creator, functionTheory);
        Z3RationalFormulaManager rationalTheory = new Z3RationalFormulaManager(creator, functionTheory);
        Z3BitvectorFormulaManager bitvectorTheory = new Z3BitvectorFormulaManager(creator);
        Z3QuantifiedFormulaManager quantifierManager = new Z3QuantifiedFormulaManager(creator);
        Z3ArrayFormulaManager arrayManager = new Z3ArrayFormulaManager(creator);
        Z3NativeApi.setInternalErrorHandler(context);
        return new Z3FormulaManager(creator, unsafeManager, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, quantifierManager, arrayManager, smtLogger, config);
    }

    @Override
    public ProverEnvironment newProverEnvironment(boolean pGenerateModels, boolean pGenerateUnsatCore) {
        return new Z3TheoremProver(this, pGenerateUnsatCore);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(boolean pShared) {
        return new Z3InterpolatingProver(this);
    }

    @Override
    public SmtAstMatcher getSmtAstMatcher() {
        return this.z3astMatcher;
    }

    @Override
    public OptEnvironment newOptEnvironment() {
        Z3OptProver out = new Z3OptProver(this);
        out.setParam(OPT_ENGINE_CONFIG_KEY, this.optimizationEngine);
        out.setParam(OPT_PRIORITY_CONFIG_KEY, this.objectivePrioritizationMode);
        return out;
    }

    @Override
    public BooleanFormula parse(String str) throws IllegalArgumentException {
        long[] sort_symbols = new long[]{};
        long[] sorts = new long[]{};
        long[] decl_symbols = new long[]{};
        long[] decls = new long[]{};
        long e = Z3NativeApi.parse_smtlib2_string((Long)this.getEnvironment(), str, sort_symbols, sorts, decl_symbols, decls);
        return this.encapsulateBooleanFormula(e);
    }

    static long getZ3Expr(Formula pT) {
        if (pT instanceof Z3Formula) {
            return ((Z3Formula)pT).getFormulaInfo();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    @Override
    public String getVersion() {
        Z3NativeApi.PointerToInt major = new Z3NativeApi.PointerToInt();
        Z3NativeApi.PointerToInt minor = new Z3NativeApi.PointerToInt();
        Z3NativeApi.PointerToInt build = new Z3NativeApi.PointerToInt();
        Z3NativeApi.PointerToInt revision = new Z3NativeApi.PointerToInt();
        Z3NativeApi.get_version(major, minor, build, revision);
        return "Z3 " + major.value + "." + minor.value + "." + build.value + "." + revision.value;
    }

    @Override
    public Appender dumpFormula(final Long expr) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                String[] lines;
                StringBuilder modified = new StringBuilder();
                String txt = Z3NativeApi.benchmark_to_smtlib_string((Long)Z3FormulaManager.this.getEnvironment(), "dumped-formula", "", "unknown", "", 0, new long[0], expr);
                for (String line : lines = txt.split("\n")) {
                    if (line.startsWith("(set-info") || line.startsWith(";") || line.startsWith("(check")) continue;
                    modified.append(line);
                    modified.append(" ");
                }
                out.append(modified.toString().replace("(assert", "\n(assert").replace("(dec", "\n(dec").trim());
            }
        };
    }

    protected BooleanFormula encapsulateBooleanFormula(long t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    Z3SmtLogger getSmtLogger() {
        return this.z3smtLogger.cloneWithNewLogfile();
    }

    @Options(prefix="cpa.predicate.solver.z3")
    public static class ExtraOptions {
        @Option(secure=true, description="Require proofs from SMT solver")
        boolean requireProofs = true;
        @Option(secure=true, description="Activate replayable logging in Z3. The log can be given as an input to the solver and replayed.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        Path log = null;
    }
}

