/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.primitives.Longs;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3SmtLogger;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3UnsafeFormulaManager;

class Z3FunctionFormulaManager
extends AbstractFunctionFormulaManager<Long, Long, Long, Long> {
    private final Z3UnsafeFormulaManager unsafeManager;
    private final long z3context;
    private final Z3SmtLogger smtLogger;

    Z3FunctionFormulaManager(Z3FormulaCreator creator, Z3UnsafeFormulaManager unsafeManager, Z3SmtLogger smtLogger) {
        super(creator, unsafeManager);
        this.z3context = (Long)creator.getEnv();
        this.unsafeManager = unsafeManager;
        this.smtLogger = smtLogger;
    }

    @Override
    protected Long createUninterpretedFunctionCallImpl(Long funcDecl, List<Long> pArgs) {
        long[] args = Longs.toArray(pArgs);
        return this.unsafeManager.createUIFCallImpl(funcDecl, args);
    }

    @Override
    protected Long declareUninterpretedFunctionImpl(String pName, Long returnType, List<Long> pArgTypes) {
        long symbol = Z3NativeApi.mk_string_symbol(this.z3context, pName);
        long[] sorts = Longs.toArray(pArgTypes);
        long func = Z3NativeApi.mk_func_decl(this.z3context, symbol, sorts, returnType);
        Z3NativeApi.inc_ref(this.z3context, func);
        this.smtLogger.logFunctionDeclaration(symbol, sorts, returnType);
        return func;
    }
}

