/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3Model;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApiConstants;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3SmtLogger;

class Z3InterpolatingProver
implements InterpolatingProverEnvironment<Long> {
    private final Z3FormulaManager mgr;
    private long z3context;
    private long z3solver;
    private final Z3SmtLogger smtLogger;
    private int level = 0;
    private List<Long> assertedFormulas = new LinkedList<Long>();

    Z3InterpolatingProver(Z3FormulaManager mgr) {
        this.mgr = mgr;
        this.z3context = (Long)mgr.getEnvironment();
        this.z3solver = Z3NativeApi.mk_solver(this.z3context);
        Z3NativeApi.solver_inc_ref(this.z3context, this.z3solver);
        this.smtLogger = mgr.getSmtLogger();
    }

    @Override
    public Long push(BooleanFormula f) {
        ++this.level;
        long e = Z3FormulaManager.getZ3Expr(f);
        Z3NativeApi.solver_push(this.z3context, this.z3solver);
        if (this.mgr.simplifyFormulas) {
            e = Z3NativeApi.simplify(this.z3context, e);
            Z3NativeApi.inc_ref(this.z3context, e);
        }
        Z3NativeApi.solver_assert(this.z3context, this.z3solver, e);
        this.assertedFormulas.add(e);
        this.smtLogger.logPush(1);
        this.smtLogger.logInterpolationAssert(e);
        return e;
    }

    @Override
    public void pop() {
        --this.level;
        this.assertedFormulas.remove(this.assertedFormulas.size() - 1);
        Z3NativeApi.solver_pop(this.z3context, this.z3solver, 1);
        this.smtLogger.logPop(1);
    }

    @Override
    public boolean isUnsat() {
        Preconditions.checkState((this.z3context != 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.z3solver != 0L ? 1 : 0) != 0);
        int result = Z3NativeApi.solver_check(this.z3context, this.z3solver);
        this.smtLogger.logCheck();
        Preconditions.checkState((result != Z3NativeApiConstants.Z3_LBOOL.Z3_L_UNDEF.status ? 1 : 0) != 0);
        return result == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status;
    }

    @Override
    public BooleanFormula getInterpolant(List<Long> formulasOfA) {
        ArrayList<Long> formulasOfB = new ArrayList<Long>();
        for (long af : this.assertedFormulas) {
            if (formulasOfA.contains(af)) continue;
            formulasOfB.add(af);
        }
        assert (formulasOfA.size() != 0);
        assert (formulasOfB.size() != 0);
        long[] groupA = Longs.toArray(formulasOfA);
        long[] groupB = Longs.toArray(formulasOfB);
        long fA = Z3NativeApi.mk_interpolant(this.z3context, Z3NativeApi.mk_and(this.z3context, groupA));
        Z3NativeApi.inc_ref(this.z3context, fA);
        long fB = Z3NativeApi.mk_and(this.z3context, groupB);
        Z3NativeApi.inc_ref(this.z3context, fB);
        Z3NativeApi.PointerToLong model = new Z3NativeApi.PointerToLong();
        Z3NativeApi.PointerToLong interpolant = new Z3NativeApi.PointerToLong();
        long conjunction = Z3NativeApi.mk_and(this.z3context, fA, fB);
        Z3NativeApi.inc_ref(this.z3context, conjunction);
        int isSat = Z3NativeApi.compute_interpolant(this.z3context, conjunction, 0L, interpolant, model);
        assert (isSat == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status) : isSat;
        Z3NativeApi.dec_ref(this.z3context, fA);
        Z3NativeApi.dec_ref(this.z3context, fB);
        Z3NativeApi.dec_ref(this.z3context, conjunction);
        return this.mgr.encapsulateBooleanFormula(Z3NativeApi.ast_vector_get(this.z3context, interpolant.value, 0));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Long>> partitionedFormulas) {
        Preconditions.checkArgument((partitionedFormulas.size() >= 2 ? 1 : 0) != 0, (Object)"at least 2 partitions needed for interpolation");
        long[] conjunctionFormulas = new long[partitionedFormulas.size()];
        for (int i = 0; i < partitionedFormulas.size(); ++i) {
            Preconditions.checkState((!partitionedFormulas.get(i).isEmpty() ? 1 : 0) != 0);
            long conjunction = Z3NativeApi.mk_and(this.z3context, Longs.toArray((Collection)partitionedFormulas.get(i)));
            Z3NativeApi.inc_ref(this.z3context, conjunction);
            conjunctionFormulas[i] = conjunction;
        }
        long[] interpolationFormulas = new long[partitionedFormulas.size()];
        interpolationFormulas[0] = conjunctionFormulas[0];
        Z3NativeApi.inc_ref(this.z3context, interpolationFormulas[0]);
        for (int i = 1; i < partitionedFormulas.size(); ++i) {
            long conjunction = Z3NativeApi.mk_and(this.z3context, Z3NativeApi.mk_interpolant(this.z3context, interpolationFormulas[i - 1]), conjunctionFormulas[i]);
            Z3NativeApi.inc_ref(this.z3context, conjunction);
            interpolationFormulas[i] = conjunction;
        }
        Z3NativeApi.PointerToLong interpolant = new Z3NativeApi.PointerToLong();
        Z3NativeApi.PointerToLong model = new Z3NativeApi.PointerToLong();
        int isSat = Z3NativeApi.compute_interpolant(this.z3context, interpolationFormulas[interpolationFormulas.length - 1], 0L, interpolant, model);
        Preconditions.checkState((isSat == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status ? 1 : 0) != 0, (String)"interpolation not possible, because SAT-check returned status '%s'", (Object[])new Object[]{isSat});
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (int i = 0; i < partitionedFormulas.size() - 1; ++i) {
            result.add(this.mgr.encapsulateBooleanFormula(Z3NativeApi.ast_vector_get(this.z3context, interpolant.value, i)));
        }
        for (long partition : conjunctionFormulas) {
            Z3NativeApi.dec_ref(this.z3context, partition);
        }
        for (long partition : interpolationFormulas) {
            Z3NativeApi.dec_ref(this.z3context, partition);
        }
        return result;
    }

    @Override
    public Model getModel() {
        return Z3Model.createZ3Model(this.mgr, this.z3context, this.z3solver);
    }

    @Override
    public void close() {
        Preconditions.checkState((this.z3context != 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.z3solver != 0L ? 1 : 0) != 0);
        while (this.level > 0) {
            this.pop();
        }
        this.assertedFormulas = null;
        Z3NativeApi.solver_dec_ref(this.z3context, this.z3solver);
        this.z3context = 0L;
        this.z3solver = 0L;
    }
}

