/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.NativeLibraries;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3Formula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3IntegerFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3InterpolatingProver;

public class Z3InterpolationTest {
    private Z3FormulaManager mgr;
    private Z3IntegerFormulaManager ifmgr;

    @Before
    public void loadZ3() throws Exception {
        NativeLibraries.loadLibrary("z3j");
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = TestLogManager.getInstance();
        this.mgr = Z3FormulaManager.create(logger, config, ShutdownNotifier.create(), null);
        this.ifmgr = (Z3IntegerFormulaManager)this.mgr.getIntegerFormulaManager();
    }

    @Test
    public void testInterpolation() throws Exception {
        try (Z3InterpolatingProver prover = new Z3InterpolatingProver(this.mgr);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("y");
            NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("z");
            prover.push((BooleanFormula)((Object)((AbstractNumeralFormulaManager)this.ifmgr).equal(y, ((AbstractNumeralFormulaManager)this.ifmgr).multiply(this.ifmgr.makeNumber(2L), x))));
            Z3Formula formula2 = (Z3Formula)((Object)((AbstractNumeralFormulaManager)this.ifmgr).equal(y, ((AbstractNumeralFormulaManager)this.ifmgr).add(this.ifmgr.makeNumber(1L), ((AbstractNumeralFormulaManager)this.ifmgr).multiply(z, this.ifmgr.makeNumber(2L)))));
            BooleanFormula interpolant = prover.getInterpolant(Collections.singletonList(formula2.getFormulaInfo()));
        }
    }
}

