/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.NativeLibraries;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3IntegerFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3OptProver;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3RationalFormulaManager;
import org.sosy_lab.cpachecker.util.rationals.Rational;

@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class Z3MaximizationTest {
    private Z3FormulaManager mgr;
    private Z3RationalFormulaManager rfmgr;
    private Z3IntegerFormulaManager ifmgr;
    private Z3BooleanFormulaManager bfmgr;

    @Before
    public void loadZ3() throws Exception {
        NativeLibraries.loadLibrary("z3j");
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = TestLogManager.getInstance();
        ShutdownNotifier shutdownNotifier = ShutdownNotifier.create();
        this.mgr = Z3FormulaManager.create(logger, config, shutdownNotifier, null);
        this.rfmgr = (Z3RationalFormulaManager)this.mgr.getRationalFormulaManager();
        this.ifmgr = (Z3IntegerFormulaManager)this.mgr.getIntegerFormulaManager();
        this.bfmgr = (Z3BooleanFormulaManager)this.mgr.getBooleanFormulaManager();
    }

    @Test
    public void testUnbounded() throws Exception {
        try (Z3OptProver prover = new Z3OptProver(this.mgr);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("x");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("obj");
            ImmutableList constraints = ImmutableList.of((Object)((AbstractNumeralFormulaManager)this.rfmgr).greaterOrEquals(x, this.rfmgr.makeNumber("10")), (Object)((AbstractNumeralFormulaManager)this.rfmgr).equal(x, obj));
            prover.addConstraint(this.bfmgr.and((List<BooleanFormula>)constraints));
            int handle = prover.maximize(obj);
            OptEnvironment.OptStatus response = prover.check();
            Assert.assertTrue((!prover.upper(handle, Rational.ZERO).isPresent() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUnfeasible() throws Exception {
        try (Z3OptProver prover = new Z3OptProver(this.mgr);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("y");
            ImmutableList constraints = ImmutableList.of((Object)((AbstractNumeralFormulaManager)this.rfmgr).lessThan(x, y), (Object)((AbstractNumeralFormulaManager)this.rfmgr).greaterThan(x, y));
            prover.addConstraint(this.bfmgr.and((List<BooleanFormula>)constraints));
            int handle = prover.maximize(x);
            OptEnvironment.OptStatus response = prover.check();
            Assert.assertEquals((Object)((Object)OptEnvironment.OptStatus.UNSAT), (Object)((Object)response));
        }
    }

    @Test
    public void testOptimal() throws Exception {
        try (Z3OptProver prover = new Z3OptProver(this.mgr);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("y");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("obj");
            ImmutableList constraints = ImmutableList.of((Object)((AbstractNumeralFormulaManager)this.rfmgr).lessOrEquals(x, this.rfmgr.makeNumber(10L)), (Object)((AbstractNumeralFormulaManager)this.rfmgr).lessOrEquals(y, this.rfmgr.makeNumber(15L)), (Object)((AbstractNumeralFormulaManager)this.rfmgr).equal(obj, ((AbstractNumeralFormulaManager)this.rfmgr).add(x, y)), (Object)((AbstractNumeralFormulaManager)this.rfmgr).greaterOrEquals(((AbstractNumeralFormulaManager)this.rfmgr).subtract(x, y), this.rfmgr.makeNumber(1L)));
            prover.addConstraint(this.bfmgr.and((List<BooleanFormula>)constraints));
            int handle = prover.maximize(obj);
            OptEnvironment.OptStatus response = prover.check();
            Assert.assertEquals((Object)((Object)OptEnvironment.OptStatus.OPT), (Object)((Object)response));
            Model model = prover.getModel();
            Assert.assertEquals((Object)"obj : Real: 19\nx : Real: 10\ny : Real: 9", (Object)model.toString());
            Assert.assertEquals((Object)Rational.ofString("19"), (Object)prover.upper(handle, Rational.ZERO).get());
        }
    }

    @Test
    public void testNonlinearity() throws Exception {
        try (Z3OptProver prover = new Z3OptProver(this.mgr);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("y");
            NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(2L);
            prover.addConstraint((BooleanFormula)((Object)((AbstractNumeralFormulaManager)this.ifmgr).lessOrEquals(x, this.ifmgr.makeNumber(10L))));
            prover.addConstraint((BooleanFormula)((Object)((AbstractNumeralFormulaManager)this.ifmgr).lessOrEquals(y, this.ifmgr.makeNumber(10L))));
            NumeralFormula.IntegerFormula z = this.ifmgr.divide(x, one);
            int handle = prover.maximize(z);
            OptEnvironment.OptStatus response = prover.check();
        }
    }

    @Test
    public void testSwitchingObjectives() throws Exception {
        try (Z3OptProver prover = new Z3OptProver(this.mgr);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("y");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rfmgr.makeVariable("obj");
            ImmutableList constraints = ImmutableList.of((Object)((AbstractNumeralFormulaManager)this.rfmgr).lessOrEquals(x, this.rfmgr.makeNumber(10L)), (Object)((AbstractNumeralFormulaManager)this.rfmgr).lessOrEquals(y, this.rfmgr.makeNumber(15L)), (Object)((AbstractNumeralFormulaManager)this.rfmgr).equal(obj, ((AbstractNumeralFormulaManager)this.rfmgr).add(x, y)), (Object)((AbstractNumeralFormulaManager)this.rfmgr).greaterOrEquals(((AbstractNumeralFormulaManager)this.rfmgr).subtract(x, y), this.rfmgr.makeNumber(1L)));
            prover.addConstraint(this.bfmgr.and((List<BooleanFormula>)constraints));
            prover.push();
            int handle = prover.maximize(obj);
            OptEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptEnvironment.OptStatus.OPT);
            Truth.assertThat((Comparable)((Comparable)prover.upper(handle, Rational.ZERO).get())).isEqualTo((Object)Rational.ofString("19"));
            prover.pop();
            prover.push();
            handle = prover.maximize(x);
            response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptEnvironment.OptStatus.OPT);
            Truth.assertThat((Comparable)((Comparable)prover.upper(handle, Rational.ZERO).get())).isEqualTo((Object)Rational.ofString("10"));
            prover.pop();
            prover.push();
            handle = prover.maximize((Formula)this.rfmgr.makeVariable("y"));
            response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptEnvironment.OptStatus.OPT);
            Truth.assertThat((Comparable)((Comparable)prover.upper(handle, Rational.ZERO).get())).isEqualTo((Object)Rational.ofString("9"));
            prover.pop();
        }
    }
}

