/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApiConstants;
import org.sosy_lab.cpachecker.util.rationals.Rational;

class Z3Model {
    Z3Model() {
    }

    private static Model.TermType toZ3Type(long z3context, long sort) {
        int sortKind = Z3NativeApi.get_sort_kind(z3context, sort);
        switch (sortKind) {
            case 1: {
                return Model.TermType.Boolean;
            }
            case 2: {
                return Model.TermType.Integer;
            }
            case 3: {
                return Model.TermType.Real;
            }
            case 4: {
                return Model.TermType.Bitvector;
            }
        }
        throw new IllegalArgumentException("Given parameter cannot be converted to a TermType!");
    }

    private static Model.Constant toVariable(long z3context, long expr) {
        long decl = Z3NativeApi.get_app_decl(z3context, expr);
        long symbol = Z3NativeApi.get_decl_name(z3context, decl);
        Preconditions.checkArgument((Z3NativeApi.get_symbol_kind(z3context, symbol) == 1 ? 1 : 0) != 0, (String)"Given symbol of expression is no stringSymbol! (%s)", (Object[])new Object[]{new LazyString(expr, z3context)});
        String lName = Z3NativeApi.get_symbol_string(z3context, symbol);
        long sort = Z3NativeApi.get_sort(z3context, expr);
        Model.TermType lType = Z3Model.toZ3Type(z3context, sort);
        Pair<String, Integer> lSplitName = FormulaManagerView.parseName(lName);
        if (lSplitName.getSecond() != null) {
            return new Model.Variable((String)lSplitName.getFirst(), (Integer)lSplitName.getSecond(), lType);
        }
        return new Model.Constant((String)lSplitName.getFirst(), lType);
    }

    private static Model.Function toFunction(long z3context, long expr) {
        long decl = Z3NativeApi.get_app_decl(z3context, expr);
        long symbol = Z3NativeApi.get_decl_name(z3context, decl);
        Preconditions.checkArgument((Z3NativeApi.get_symbol_kind(z3context, symbol) == 1 ? 1 : 0) != 0, (String)"Given symbol of expression is no stringSymbol! (%s)", (Object[])new Object[]{new LazyString(expr, z3context)});
        String lName = Z3NativeApi.get_symbol_string(z3context, symbol);
        long sort = Z3NativeApi.get_sort(z3context, expr);
        Model.TermType lType = Z3Model.toZ3Type(z3context, sort);
        int lArity = Z3NativeApi.get_app_num_args(z3context, expr);
        Object[] lArguments = new Object[lArity];
        for (int i = 0; i < lArity; ++i) {
            Object lValue;
            long arg = Z3NativeApi.get_app_arg(z3context, expr, i);
            Z3NativeApi.inc_ref(z3context, arg);
            long argSort = Z3NativeApi.get_sort(z3context, arg);
            int sortKind = Z3NativeApi.get_sort_kind(z3context, argSort);
            switch (sortKind) {
                case 2: {
                    lValue = new BigInteger(Z3NativeApi.get_numeral_string(z3context, arg));
                    break;
                }
                case 3: {
                    String s = Z3NativeApi.get_numeral_string(z3context, arg);
                    lValue = Rational.ofString(s);
                    break;
                }
                case 4: {
                    lValue = Z3Model.interpreteBitvector(z3context, arg);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("function " + Z3NativeApi.ast_to_string(z3context, expr) + " with unhandled arg " + Z3NativeApi.ast_to_string(z3context, arg));
                }
            }
            Z3NativeApi.dec_ref(z3context, arg);
            lArguments[i] = lValue;
        }
        return new Model.Function(lName, lType, lArguments);
    }

    private static Model.AssignableTerm toAssignable(long z3context, long expr) {
        Preconditions.checkArgument((boolean)Z3NativeApi.is_app(z3context, expr), (String)"Given expr is no application! (%s)", (Object[])new Object[]{new LazyString(expr, z3context)});
        if (Z3NativeApi.get_app_num_args(z3context, expr) == 0) {
            return Z3Model.toVariable(z3context, expr);
        }
        return Z3Model.toFunction(z3context, expr);
    }

    public static Model createZ3Model(Z3FormulaManager mgr, long z3context, long z3solver) {
        long z3model = Z3NativeApi.solver_get_model(z3context, z3solver);
        return Z3Model.parseZ3Model(mgr, z3context, z3model);
    }

    public static Model parseZ3Model(Z3FormulaManager mgr, long z3context, long z3model) {
        Z3NativeApi.model_inc_ref(z3context, z3model);
        mgr.getSmtLogger().logGetModel();
        ImmutableMap.Builder model = ImmutableMap.builder();
        long modelFormula = Z3NativeApi.mk_true(z3context);
        Z3NativeApi.inc_ref(z3context, modelFormula);
        int n = Z3NativeApi.model_get_num_consts(z3context, z3model);
        for (int i = 0; i < n; ++i) {
            Object lValue;
            long keyDecl = Z3NativeApi.model_get_const_decl(z3context, z3model, i);
            Z3NativeApi.inc_ref(z3context, keyDecl);
            Preconditions.checkArgument((Z3NativeApi.get_arity(z3context, keyDecl) == 0 ? 1 : 0) != 0, (Object)"declaration is no constant");
            long var = Z3NativeApi.mk_app(z3context, keyDecl, new long[0]);
            Z3NativeApi.inc_ref(z3context, var);
            long value = Z3NativeApi.model_get_const_interp(z3context, z3model, keyDecl);
            Z3NativeApi.inc_ref(z3context, value);
            long equivalence = Z3NativeApi.mk_eq(z3context, var, value);
            Z3NativeApi.inc_ref(z3context, equivalence);
            long newModelFormula = Z3NativeApi.mk_and(z3context, modelFormula, equivalence);
            Z3NativeApi.inc_ref(z3context, newModelFormula);
            Model.AssignableTerm lAssignable = Z3Model.toAssignable(z3context, var);
            switch (lAssignable.getType()) {
                case Boolean: {
                    lValue = Z3NativeApiConstants.isOP(z3context, value, 256);
                    break;
                }
                case Integer: {
                    lValue = new BigInteger(Z3NativeApi.get_numeral_string(z3context, value));
                    break;
                }
                case Real: {
                    String s = Z3NativeApi.get_numeral_string(z3context, value);
                    lValue = Rational.ofString(s);
                    break;
                }
                case Bitvector: {
                    lValue = Z3Model.interpreteBitvector(z3context, value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Z3 expr with unhandled type " + (Object)((Object)lAssignable.getType()));
                }
            }
            model.put((Object)lAssignable, lValue);
            Z3NativeApi.dec_ref(z3context, keyDecl);
            Z3NativeApi.dec_ref(z3context, value);
            Z3NativeApi.dec_ref(z3context, var);
            Z3NativeApi.dec_ref(z3context, equivalence);
            Z3NativeApi.dec_ref(z3context, modelFormula);
            modelFormula = newModelFormula;
        }
        mgr.encapsulateBooleanFormula(modelFormula);
        Z3NativeApi.model_dec_ref(z3context, z3model);
        return new Model((Map<Model.AssignableTerm, Object>)model.build());
    }

    private static Object interpreteBitvector(long z3context, long bv) {
        long argSort = Z3NativeApi.get_sort(z3context, bv);
        int sortKind = Z3NativeApi.get_sort_kind(z3context, argSort);
        Preconditions.checkArgument((sortKind == 4 ? 1 : 0) != 0);
        return Z3NativeApi.ast_to_string(z3context, bv);
    }

    private static class LazyString {
        final long value;
        final long z3context;

        LazyString(long v, long pZ3context) {
            this.value = v;
            this.z3context = pZ3context;
        }

        public String toString() {
            return Z3NativeApi.ast_to_string(this.z3context, this.value);
        }
    }
}

