/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;

public class Z3NativeApiHelpers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long applyTactic(long z3context, Long pF, String pTactic) throws InterruptedException, SolverException {
        long tactic_qe = Z3NativeApi.mk_tactic(z3context, pTactic);
        Z3NativeApi.tactic_inc_ref(z3context, tactic_qe);
        long goal = Z3NativeApi.mk_goal(z3context, true, true, false);
        Z3NativeApi.goal_inc_ref(z3context, goal);
        try {
            long l;
            Z3NativeApi.goal_assert(z3context, goal, pF);
            long applyResult = Z3NativeApi.tactic_apply(z3context, tactic_qe, goal);
            Z3NativeApi.apply_result_inc_ref(z3context, applyResult);
            try {
                long result;
                long resultSubGoal = Z3NativeApi.apply_result_get_subgoal(z3context, applyResult, 0);
                Z3NativeApi.goal_inc_ref(z3context, resultSubGoal);
                int goalResultItemCount = Z3NativeApi.goal_size(z3context, resultSubGoal);
                long[] goalResultItems = new long[Math.max(1, goalResultItemCount)];
                if (goalResultItemCount == 0) {
                    goalResultItems[0] = Z3NativeApi.mk_true(z3context);
                } else {
                    for (int i = 0; i < goalResultItemCount; ++i) {
                        long subGoalFormula = Z3NativeApi.goal_formula(z3context, resultSubGoal, i);
                        Z3NativeApi.inc_ref(z3context, subGoalFormula);
                        goalResultItems[i] = subGoalFormula;
                    }
                }
                Z3NativeApi.goal_dec_ref(z3context, resultSubGoal);
                if (goalResultItemCount > 1) {
                    result = Z3NativeApi.mk_and(z3context, goalResultItems);
                    Z3NativeApi.inc_ref(z3context, result);
                    for (int i = 0; i < goalResultItems.length; ++i) {
                        Z3NativeApi.dec_ref(z3context, goalResultItems[i]);
                    }
                } else {
                    result = goalResultItems[0];
                }
                l = result;
            }
            catch (Throwable throwable) {
                Z3NativeApi.apply_result_dec_ref(z3context, applyResult);
                throw throwable;
            }
            Z3NativeApi.apply_result_dec_ref(z3context, applyResult);
            return l;
        }
        finally {
            Z3NativeApi.goal_dec_ref(z3context, goal);
            Z3NativeApi.tactic_dec_ref(z3context, tactic_qe);
        }
    }

    public static long applyTactics(long z3context, Long pF, String ... pTactics) throws InterruptedException, SolverException {
        long overallResult = pF;
        for (String tactic : pTactics) {
            long tacticResult = Z3NativeApiHelpers.applyTactic(z3context, overallResult, tactic);
            if (overallResult != pF) {
                Z3NativeApi.dec_ref(z3context, overallResult);
            }
            overallResult = tacticResult;
        }
        return overallResult;
    }

    public static String getDeclarationSymbolText(long pContext, long pDeclaration) {
        long symbol = Z3NativeApi.get_decl_name(pContext, pDeclaration);
        switch (Z3NativeApi.get_symbol_kind(pContext, symbol)) {
            case 0: {
                return Integer.toString(Z3NativeApi.get_symbol_int(pContext, symbol));
            }
            case 1: {
                return Z3NativeApi.get_symbol_string(pContext, symbol);
            }
        }
        throw new UnsupportedOperationException("getDeclarationSymbolText: Kind of symbol not yet supported! Implement it!");
    }
}

