/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3Formula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3Model;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApiConstants;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3RationalFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3RationalFormulaManager;
import org.sosy_lab.cpachecker.util.rationals.Rational;

class Z3OptProver
implements OptEnvironment {
    private final Z3FormulaManager mgr;
    private final Z3RationalFormulaManager rfmgr;
    private static final String Z3_INFINITY_REPRESENTATION = "oo";
    private long z3context;
    private long z3optContext;

    Z3OptProver(Z3FormulaManager pMgr) {
        this.mgr = pMgr;
        this.rfmgr = (Z3RationalFormulaManager)pMgr.getRationalFormulaManager();
        this.z3context = (Long)this.mgr.getEnvironment();
        this.z3optContext = Z3NativeApi.mk_optimize(this.z3context);
        Z3NativeApi.optimize_inc_ref(this.z3context, this.z3optContext);
    }

    @Override
    public void addConstraint(BooleanFormula constraint) {
        Z3BooleanFormula z3Constraint = (Z3BooleanFormula)constraint;
        Z3NativeApi.optimize_assert(this.z3context, this.z3optContext, z3Constraint.getFormulaInfo());
    }

    @Override
    public int maximize(Formula objective) {
        Z3Formula z3Objective = (Z3Formula)objective;
        return Z3NativeApi.optimize_maximize(this.z3context, this.z3optContext, z3Objective.getFormulaInfo());
    }

    @Override
    public int minimize(Formula objective) {
        Z3Formula z3Objective = (Z3Formula)objective;
        return Z3NativeApi.optimize_minimize(this.z3context, this.z3optContext, z3Objective.getFormulaInfo());
    }

    @Override
    public OptEnvironment.OptStatus check() throws InterruptedException, SolverException {
        int status = Z3NativeApi.optimize_check(this.z3context, this.z3optContext);
        if (status == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status) {
            return OptEnvironment.OptStatus.UNSAT;
        }
        if (status == Z3NativeApiConstants.Z3_LBOOL.Z3_L_UNDEF.status) {
            return OptEnvironment.OptStatus.UNDEF;
        }
        return OptEnvironment.OptStatus.OPT;
    }

    @Override
    public void push() {
        Z3NativeApi.optimize_push(this.z3context, this.z3optContext);
    }

    @Override
    public void pop() {
        Z3NativeApi.optimize_pop(this.z3context, this.z3optContext);
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        long ast = Z3NativeApi.optimize_get_upper(this.z3context, this.z3optContext, handle);
        if (this.isInfinity(ast)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        long ast = Z3NativeApi.optimize_get_lower(this.z3context, this.z3optContext, handle);
        if (this.isInfinity(ast)) {
            return Optional.absent();
        }
        return Optional.of((Object)this.rationalFromZ3AST(this.replaceEpsilon(ast, epsilon)));
    }

    @Override
    public Model getModel() throws SolverException {
        long z3model = Z3NativeApi.optimize_get_model(this.z3context, this.z3optContext);
        return Z3Model.parseZ3Model(this.mgr, this.z3context, z3model);
    }

    void setParam(String key, String value) {
        long keySymbol = Z3NativeApi.mk_string_symbol(this.z3context, key);
        long valueSymbol = Z3NativeApi.mk_string_symbol(this.z3context, value);
        long params = Z3NativeApi.mk_params(this.z3context);
        Z3NativeApi.params_set_symbol(this.z3context, params, keySymbol, valueSymbol);
        Z3NativeApi.optimize_set_params(this.z3context, this.z3optContext, params);
    }

    public String toString() {
        return Z3NativeApi.optimize_to_string(this.z3context, this.z3optContext);
    }

    @Override
    public void close() {
        Z3NativeApi.optimize_dec_ref(this.z3context, this.z3optContext);
        this.z3context = 0L;
        this.z3optContext = 0L;
    }

    private boolean isInfinity(long ast) {
        return Z3NativeApi.ast_to_string(this.z3context, ast).contains(Z3_INFINITY_REPRESENTATION);
    }

    private long replaceEpsilon(long ast, Rational newValue) {
        Z3RationalFormula z = new Z3RationalFormula(this.z3context, ast);
        Z3Formula epsFormula = (Z3Formula)this.rfmgr.makeVariable("epsilon");
        Z3Formula out = ((AbstractUnsafeFormulaManager)this.mgr.getUnsafeFormulaManager()).substitute(z, ImmutableList.of((Object)epsFormula), ImmutableList.of((Object)((Z3Formula)this.rfmgr.makeNumber(newValue.toString()))));
        return Z3NativeApi.simplify(this.z3context, out.getFormulaInfo());
    }

    private Rational rationalFromZ3AST(long ast) {
        return Rational.ofString(Z3NativeApi.get_numeral_string(this.z3context, ast));
    }
}

