/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;

class Z3SmtLogger {
    private static final String MATHSAT5 = "MATHSAT5";
    private static final String Z3 = "Z3";
    private final Path logfile;
    private final Z3Settings settings;
    private final long z3context;
    private final HashSet<Long> declarations = Sets.newHashSet();
    private int itpIndex = 0;
    private final HashMap<Long, String> interpolationFormulas = Maps.newHashMap();

    Z3SmtLogger(long z3context, Configuration config, PathCounterTemplate logfile) throws InvalidConfigurationException {
        this(z3context, new Z3Settings(config, logfile));
    }

    private Z3SmtLogger(long pZ3context, Z3Settings pSettings) {
        this.z3context = pZ3context;
        this.settings = pSettings;
        if (this.settings.basicLogfile != null) {
            this.logfile = this.settings.basicLogfile.getFreshPath();
            this.log("", false);
        } else {
            this.logfile = null;
        }
    }

    public Z3SmtLogger cloneWithNewLogfile() {
        return new Z3SmtLogger(this.z3context, this.settings);
    }

    public void logOption(String option, String value) {
        if (this.logfile == null) {
            return;
        }
        this.logBracket("set-option :" + option + " " + value);
    }

    public void logVarDeclaration(long name, long type) {
        if (this.logfile == null) {
            return;
        }
        if (this.declarations.add(name)) {
            this.logBracket("declare-fun " + Z3NativeApi.ast_to_string(this.z3context, name) + " () " + Z3NativeApi.sort_to_string(this.z3context, type));
        }
    }

    public void logFunctionDeclaration(long symbol, long[] inputTypes, long returnType) {
        if (this.logfile == null) {
            return;
        }
        if (this.declarations.add(symbol)) {
            StringBuilder s = new StringBuilder();
            s.append("declare-fun ").append(Z3NativeApi.get_symbol_string(this.z3context, symbol)).append(" (");
            for (long it : inputTypes) {
                s.append(Z3NativeApi.sort_to_string(this.z3context, it)).append(" ");
            }
            s.append(") ").append(Z3NativeApi.sort_to_string(this.z3context, returnType));
            this.logBracket(s.toString());
        }
    }

    public void logPush(int n) {
        if (this.logfile == null) {
            return;
        }
        this.logBracket("push " + n);
    }

    public void logPop(int n) {
        if (this.logfile == null) {
            return;
        }
        this.logBracket("pop " + n);
    }

    public void logAssert(long expr) {
        this.logInterpolationAssert(expr);
    }

    public void logInterpolationAssert(long expr) {
        if (this.logfile == null) {
            return;
        }
        ++this.itpIndex;
        String formula = Z3NativeApi.ast_to_string(this.z3context, expr);
        switch (this.settings.target) {
            case "Z3": {
                this.logBracket("assert " + formula);
                break;
            }
            case "MATHSAT5": {
                String name = "itpId" + this.itpIndex;
                this.logBracket("assert (! " + formula + " :interpolation-group " + name + ")");
                this.interpolationFormulas.put(expr, name);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void logCheck() {
        if (this.logfile == null) {
            return;
        }
        this.logBracket("check-sat");
    }

    public void logGetModel() {
        if (this.logfile == null) {
            return;
        }
        this.logBracket("get-model");
    }

    public void logInterpolation(List<Long> formulasOfA, List<Long> formulasOfB, long conjunctionA, long conjunctionB) {
        if (this.logfile == null) {
            return;
        }
        StringBuilder itpQuery = new StringBuilder();
        switch (this.settings.target) {
            case "Z3": {
                itpQuery.append("get-interpolant ").append(Z3NativeApi.ast_to_string(this.z3context, conjunctionA)).append(" ").append(Z3NativeApi.ast_to_string(this.z3context, conjunctionB));
                break;
            }
            case "MATHSAT5": {
                itpQuery.append("get-interpolant (");
                for (long f : formulasOfA) {
                    Preconditions.checkArgument((boolean)this.interpolationFormulas.containsKey(f));
                    itpQuery.append(this.interpolationFormulas.get(f)).append(" ");
                }
                itpQuery.append(")");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.logCheck();
        this.logBracket(itpQuery.toString());
    }

    public void logSeqInterpolation(long[] interpolationFormulas) {
        if (this.logfile == null) {
            return;
        }
        StringBuilder itpQuery = new StringBuilder();
        switch (this.settings.target) {
            case "Z3": {
                itpQuery.append("get-interpolants ");
                for (long f : interpolationFormulas) {
                    itpQuery.append(Z3NativeApi.ast_to_string(this.z3context, f));
                }
                break;
            }
            case "MATHSAT5": {
                throw new AssertionError((Object)"not supported via SMT-input/output??");
            }
            default: {
                throw new AssertionError();
            }
        }
        this.logCheck();
        this.logBracket(itpQuery.toString());
    }

    public void logBracket(String s) {
        if (this.logfile == null) {
            return;
        }
        this.log("(" + s + ")\n", true);
    }

    private synchronized void log(String s, boolean append) {
        try {
            if (append) {
                this.logfile.asCharSink(Charset.defaultCharset(), new FileWriteMode[]{FileWriteMode.APPEND}).write((CharSequence)s);
            } else {
                this.logfile.asCharSink(Charset.defaultCharset(), new FileWriteMode[0]).write((CharSequence)s);
            }
        }
        catch (IOException e) {
            throw new AssertionError("IO-Error in smtlogfile", e);
        }
    }

    @Options(prefix="cpa.predicate.solver.z3.logger")
    private static class Z3Settings {
        @Nullable
        private final PathCounterTemplate basicLogfile;
        @Option(secure=true, description="Export solver queries in Smtlib2 format, there are small differences for different solvers, choose target-solver.", values={"Z3", "MATHSAT5"}, toUppercase=true)
        private String target = "Z3";

        private Z3Settings(Configuration config, PathCounterTemplate logfile) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.basicLogfile = logfile;
        }
    }
}

