/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.time.NestedTimer;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3Model;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApiConstants;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3SmtLogger;

class Z3TheoremProver
implements ProverEnvironment {
    private final Z3FormulaManager mgr;
    private long z3context;
    private long z3solver;
    private final Z3SmtLogger smtLogger;
    private int level = 0;
    private int track_no = 0;
    private static final String UNSAT_CORE_TEMP_VARNAME = "UNSAT_CORE_%d";
    private final Map<String, BooleanFormula> storedConstraints;

    Z3TheoremProver(Z3FormulaManager pMgr, boolean generateUnsatCore) {
        this.mgr = pMgr;
        this.z3context = (Long)this.mgr.getEnvironment();
        this.z3solver = Z3NativeApi.mk_solver(this.z3context);
        Z3NativeApi.solver_inc_ref(this.z3context, this.z3solver);
        this.smtLogger = this.mgr.getSmtLogger();
        this.storedConstraints = generateUnsatCore ? new HashMap<String, BooleanFormula>() : null;
    }

    @Override
    public Void push(BooleanFormula f) {
        ++this.track_no;
        ++this.level;
        Preconditions.checkArgument((this.z3context != 0L ? 1 : 0) != 0);
        Z3NativeApi.solver_push(this.z3context, this.z3solver);
        long e = Z3FormulaManager.getZ3Expr(f);
        if (this.mgr.simplifyFormulas) {
            e = Z3NativeApi.simplify(this.z3context, e);
            Z3NativeApi.inc_ref(this.z3context, e);
        }
        if (this.storedConstraints != null) {
            String varName = String.format(UNSAT_CORE_TEMP_VARNAME, this.track_no);
            Z3BooleanFormula t = (Z3BooleanFormula)((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeVariable(varName);
            Z3NativeApi.solver_assert_and_track(this.z3context, this.z3solver, e, t.getFormulaInfo());
            this.storedConstraints.put(varName, f);
        } else {
            Z3NativeApi.solver_assert(this.z3context, this.z3solver, e);
        }
        this.smtLogger.logPush(1);
        this.smtLogger.logAssert(e);
        return null;
    }

    @Override
    public void pop() {
        --this.level;
        Preconditions.checkArgument((Z3NativeApi.solver_get_num_scopes(this.z3context, this.z3solver) >= 1 ? 1 : 0) != 0);
        Z3NativeApi.solver_pop(this.z3context, this.z3solver, 1);
        this.smtLogger.logPop(1);
    }

    @Override
    public boolean isUnsat() {
        int result = Z3NativeApi.solver_check(this.z3context, this.z3solver);
        Preconditions.checkArgument((result != Z3NativeApiConstants.Z3_LBOOL.Z3_L_UNDEF.status ? 1 : 0) != 0);
        this.smtLogger.logCheck();
        return result == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status;
    }

    @Override
    public Model getModel() throws SolverException {
        return Z3Model.createZ3Model(this.mgr, this.z3context, this.z3solver);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        LinkedList<BooleanFormula> constraints = new LinkedList<BooleanFormula>();
        long ast_vector = Z3NativeApi.solver_get_unsat_core(this.z3context, this.z3solver);
        Z3NativeApi.ast_vector_inc_ref(this.z3context, ast_vector);
        for (int i = 0; i < Z3NativeApi.ast_vector_size(this.z3context, ast_vector); ++i) {
            long ast = Z3NativeApi.ast_vector_get(this.z3context, ast_vector, i);
            BooleanFormula f = this.mgr.encapsulateBooleanFormula(ast);
            constraints.add(this.storedConstraints.get(f.toString()));
        }
        Z3NativeApi.ast_vector_dec_ref(this.z3context, ast_vector);
        return constraints;
    }

    @Override
    public void close() {
        Preconditions.checkArgument((this.z3context != 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.z3solver != 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((Z3NativeApi.solver_get_num_scopes(this.z3context, this.z3solver) >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
        while (this.level > 0) {
            this.pop();
        }
        Z3NativeApi.solver_dec_ref(this.z3context, this.z3solver);
        this.z3context = 0L;
        this.z3solver = 0L;
    }

    @Override
    public ProverEnvironment.AllSatResult allSat(Collection<BooleanFormula> formulas, AbstractionManager.RegionCreator rmgr, Timer solveTime, NestedTimer enumTime) {
        Preconditions.checkNotNull((Object)rmgr);
        Preconditions.checkNotNull((Object)solveTime);
        Preconditions.checkNotNull((Object)enumTime);
        Preconditions.checkArgument((this.z3context != 0L ? 1 : 0) != 0);
        Z3AllSatResult result = new Z3AllSatResult(rmgr, solveTime, enumTime);
        long[] importantFormulas = new long[formulas.size()];
        int i = 0;
        for (BooleanFormula impF : formulas) {
            importantFormulas[i++] = Z3FormulaManager.getZ3Expr(impF);
        }
        solveTime.start();
        Z3NativeApi.solver_push(this.z3context, this.z3solver);
        this.smtLogger.logPush(1);
        this.smtLogger.logCheck();
        while (Z3NativeApi.solver_check(this.z3context, this.z3solver) == Z3NativeApiConstants.Z3_LBOOL.Z3_L_TRUE.status) {
            long[] valuesOfModel = new long[importantFormulas.length];
            long z3model = Z3NativeApi.solver_get_model(this.z3context, this.z3solver);
            this.smtLogger.logGetModel();
            for (int j = 0; j < importantFormulas.length; ++j) {
                long funcDecl = Z3NativeApi.get_app_decl(this.z3context, importantFormulas[j]);
                long valueOfExpr = Z3NativeApi.model_get_const_interp(this.z3context, z3model, funcDecl);
                if (Z3NativeApiConstants.isOP(this.z3context, valueOfExpr, 257)) {
                    valuesOfModel[j] = Z3NativeApi.mk_not(this.z3context, importantFormulas[j]);
                    Z3NativeApi.inc_ref(this.z3context, valuesOfModel[j]);
                    continue;
                }
                valuesOfModel[j] = importantFormulas[j];
            }
            result.callback(valuesOfModel);
            long negatedModel = Z3NativeApi.mk_not(this.z3context, Z3NativeApi.mk_and(this.z3context, valuesOfModel));
            Z3NativeApi.inc_ref(this.z3context, negatedModel);
            Z3NativeApi.solver_assert(this.z3context, this.z3solver, negatedModel);
            this.smtLogger.logAssert(negatedModel);
            this.smtLogger.logCheck();
        }
        if (solveTime.isRunning()) {
            solveTime.stop();
        } else {
            enumTime.stopOuter();
        }
        Z3NativeApi.solver_pop(this.z3context, this.z3solver, 1);
        this.smtLogger.logPop(1);
        return result;
    }

    class Z3AllSatResult
    implements ProverEnvironment.AllSatResult {
        private final AbstractionManager.RegionCreator rmgr;
        private final RegionManager.RegionBuilder builder;
        private final Timer solveTime;
        private final NestedTimer enumTime;
        private Timer regionTime = null;
        private int count = 0;
        private Region formula;

        public Z3AllSatResult(AbstractionManager.RegionCreator rmgr, Timer pSolveTime, NestedTimer pEnumTime) {
            this.rmgr = rmgr;
            this.solveTime = pSolveTime;
            this.enumTime = pEnumTime;
            this.builder = rmgr.newRegionBuilder(ShutdownNotifier.create());
        }

        @Override
        public int getCount() {
            return this.count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Region getResult() throws InterruptedException {
            if (this.formula == null) {
                this.enumTime.startBoth();
                try {
                    this.formula = this.builder.getResult();
                    this.builder.close();
                }
                finally {
                    this.enumTime.stopBoth();
                }
            }
            return this.formula;
        }

        public void callback(long[] model) {
            if (this.count == 0) {
                this.solveTime.stop();
                this.enumTime.startOuter();
                this.regionTime = this.enumTime.getCurentInnerTimer();
            }
            this.regionTime.start();
            this.builder.startNewConjunction();
            for (long t : model) {
                if (Z3NativeApiConstants.isOP(Z3TheoremProver.this.z3context, t, 265)) {
                    t = Z3NativeApi.get_app_arg(Z3TheoremProver.this.z3context, t, 0);
                    this.builder.addNegativeRegion(this.rmgr.getPredicate(Z3TheoremProver.this.mgr.encapsulateBooleanFormula(t)));
                    continue;
                }
                this.builder.addPositiveRegion(this.rmgr.getPredicate(Z3TheoremProver.this.mgr.encapsulateBooleanFormula(t)));
            }
            this.builder.finishConjunction();
            ++this.count;
            this.regionTime.stop();
        }
    }
}

