/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApi;
import org.sosy_lab.cpachecker.util.predicates.z3.Z3NativeApiConstants;

class Z3UnsafeFormulaManager
extends AbstractUnsafeFormulaManager<Long, Long, Long> {
    private final Set<Long> uifs = new HashSet<Long>();
    private final long z3context;
    private static final Collection<Integer> nonAtomicOpTypes = Sets.newHashSet((Object[])new Integer[]{261, 262, 266, 260, 265});

    Z3UnsafeFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
        this.z3context = (Long)pCreator.getEnv();
    }

    @Override
    public boolean isAtom(Long t) {
        int astKind = Z3NativeApi.get_ast_kind(this.z3context, t);
        switch (astKind) {
            case 1: {
                long decl = Z3NativeApi.get_app_decl(this.z3context, t);
                return !nonAtomicOpTypes.contains(Z3NativeApi.get_decl_kind(this.z3context, decl));
            }
        }
        return true;
    }

    @Override
    public boolean isLiteral(Long t) {
        long decl = Z3NativeApi.get_app_decl(this.z3context, t);
        int declKind = Z3NativeApi.get_decl_kind(this.z3context, decl);
        if (declKind == 265) {
            return true;
        }
        return !nonAtomicOpTypes.contains(declKind);
    }

    @Override
    public int getArity(Long t) {
        return Z3NativeApi.get_app_num_args(this.z3context, t);
    }

    @Override
    public Long getArg(Long t, int n) {
        return Z3NativeApi.get_app_arg(this.z3context, t, n);
    }

    @Override
    public boolean isVariable(Long t) {
        if (Z3NativeApiConstants.isOP(this.z3context, t, 256) || Z3NativeApiConstants.isOP(this.z3context, t, 257)) {
            return false;
        }
        int astKind = Z3NativeApi.get_ast_kind(this.z3context, t);
        return astKind == 2 || astKind == 1 && this.getArity(t) == 0;
    }

    @Override
    protected boolean isFreeVariable(Long pT) {
        if (Z3NativeApiConstants.isOP(this.z3context, pT, 256) || Z3NativeApiConstants.isOP(this.z3context, pT, 257)) {
            return false;
        }
        int astKind = Z3NativeApi.get_ast_kind(this.z3context, pT);
        return astKind == 1 && this.getArity(pT) == 0;
    }

    @Override
    protected boolean isBoundVariable(Long pT) {
        int astKind = Z3NativeApi.get_ast_kind(this.z3context, pT);
        return astKind == 2;
    }

    @Override
    public boolean isUF(Long t) {
        return Z3NativeApi.is_app(this.z3context, t) && this.uifs.contains(Z3NativeApi.get_app_decl(this.z3context, t));
    }

    @Override
    public String getName(Long t) {
        int astKind = Z3NativeApi.get_ast_kind(this.z3context, t);
        if (astKind == 2) {
            return "?" + Z3NativeApi.get_index_value(this.z3context, t);
        }
        long funcDecl = Z3NativeApi.get_app_decl(this.z3context, t);
        long symbol = Z3NativeApi.get_decl_name(this.z3context, funcDecl);
        switch (Z3NativeApi.get_symbol_kind(this.z3context, symbol)) {
            case 0: {
                return Integer.toString(Z3NativeApi.get_symbol_int(this.z3context, symbol));
            }
            case 1: {
                return Z3NativeApi.get_symbol_string(this.z3context, symbol);
            }
        }
        throw new AssertionError();
    }

    @Override
    public Long replaceArgs(Long t, List<Long> newArgs) {
        Preconditions.checkState((Z3NativeApi.get_app_num_args(this.z3context, t) == newArgs.size() ? 1 : 0) != 0);
        long[] newParams = Longs.toArray(newArgs);
        long funcDecl = Z3NativeApi.get_app_decl(this.z3context, t);
        return Z3NativeApi.mk_app(this.z3context, funcDecl, newParams);
    }

    @Override
    public Long replaceName(Long t, String pNewName) {
        if (this.isVariable(t)) {
            long sort = Z3NativeApi.get_sort(this.z3context, t);
            return (Long)this.getFormulaCreator().makeVariable(sort, pNewName);
        }
        if (this.isUF(t)) {
            int n = Z3NativeApi.get_app_num_args(this.z3context, t);
            long[] args = new long[n];
            long[] sorts = new long[n];
            for (int i = 0; i < sorts.length; ++i) {
                args[i] = Z3NativeApi.get_app_arg(this.z3context, t, i);
                Z3NativeApi.inc_ref(this.z3context, args[i]);
                sorts[i] = Z3NativeApi.get_sort(this.z3context, args[i]);
                Z3NativeApi.inc_ref(this.z3context, sorts[i]);
            }
            long symbol = Z3NativeApi.mk_string_symbol(this.z3context, pNewName);
            long retSort = Z3NativeApi.get_sort(this.z3context, t);
            long newFunc = Z3NativeApi.mk_func_decl(this.z3context, symbol, sorts, retSort);
            Z3NativeApi.inc_ref(this.z3context, newFunc);
            long uif = this.createUIFCallImpl(newFunc, args);
            for (int i = 0; i < sorts.length; ++i) {
                Z3NativeApi.dec_ref(this.z3context, args[i]);
                Z3NativeApi.dec_ref(this.z3context, sorts[i]);
            }
            return uif;
        }
        throw new IllegalArgumentException("Cannot replace name '" + pNewName + "' in term '" + Z3NativeApi.ast_to_string(this.z3context, t) + "'.");
    }

    public long createUIFCallImpl(long pNewFunc, long[] args) {
        long ufc = Z3NativeApi.mk_app(this.z3context, pNewFunc, args);
        this.uifs.add(pNewFunc);
        return ufc;
    }

    @Override
    public boolean isNumber(Long t) {
        return Z3NativeApi.is_numeral_ast(this.z3context, t);
    }

    @Override
    protected Long substitute(Long t, List<Long> changeFrom, List<Long> changeTo) {
        int size = changeFrom.size();
        Preconditions.checkState((size == changeTo.size() ? 1 : 0) != 0);
        return Z3NativeApi.substitute(this.z3context, t, size, Longs.toArray(changeFrom), Longs.toArray(changeTo));
    }

    @Override
    protected Long simplify(Long pF) {
        return Z3NativeApi.simplify(this.z3context, pF);
    }

    @Override
    protected boolean isQuantification(Long pT) {
        return 3 == Z3NativeApi.get_ast_kind(this.z3context, pT);
    }

    @Override
    protected Long getQuantifiedBody(Long pT) {
        return Z3NativeApi.get_quantifier_body(this.z3context, pT);
    }

    @Override
    protected Long replaceQuantifiedBody(Long pF, Long pBody) {
        boolean isForall = Z3NativeApi.is_quantifier_forall(this.z3context, pF);
        int boundCount = Z3NativeApi.get_quantifier_num_bound(this.z3context, pF);
        ArrayList boundVars = Lists.newArrayList();
        for (int b = 0; b < boundCount; ++b) {
            long varName = Z3NativeApi.get_quantifier_bound_name(this.z3context, pF, b);
            long varSort = Z3NativeApi.get_quantifier_bound_sort(this.z3context, pF, b);
            long var = Z3NativeApi.mk_const(this.z3context, varName, varSort);
            boundVars.add(var);
            Z3NativeApi.inc_ref(this.z3context, var);
        }
        if (isForall) {
            return Z3NativeApi.mk_forall_const(this.z3context, 0, boundVars.size(), Longs.toArray((Collection)boundVars), 0, Longs.toArray(Collections.emptyList()), pBody);
        }
        return Z3NativeApi.mk_exists_const(this.z3context, 0, boundVars.size(), Longs.toArray((Collection)boundVars), 0, Longs.toArray(Collections.emptyList()), pBody);
    }
}

