/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.rationals;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class ExtendedRational
implements Comparable<ExtendedRational> {
    private final NumberType numberType;
    private final Rational rational;
    public static final ExtendedRational INFTY = new ExtendedRational(NumberType.INFTY);
    public static final ExtendedRational NEG_INFTY = new ExtendedRational(NumberType.NEG_INFTY);
    public static final ExtendedRational NaN = new ExtendedRational(NumberType.NaN);

    public ExtendedRational(Rational pRational) {
        this.numberType = NumberType.RATIONAL;
        this.rational = pRational;
    }

    public boolean isRational() {
        return this.rational != null;
    }

    public Rational getRational() {
        if (this.rational != null) {
            return this.rational;
        }
        throw new UnsupportedOperationException("Represented number is not rational");
    }

    private ExtendedRational(NumberType pType) {
        Preconditions.checkState((pType != NumberType.RATIONAL ? 1 : 0) != 0);
        this.numberType = pType;
        this.rational = null;
    }

    public double toDouble() {
        switch (this.numberType) {
            case NEG_INFTY: {
                return Double.NEGATIVE_INFINITY;
            }
            case RATIONAL: {
                return this.rational.toDouble();
            }
            case INFTY: {
                return Double.POSITIVE_INFINITY;
            }
            case NaN: {
                return Double.NaN;
            }
        }
        throw new UnsupportedOperationException("Unexpected number type");
    }

    public String toString() {
        switch (this.numberType) {
            case RATIONAL: {
                return this.rational.toString();
            }
        }
        return Double.toString(this.toDouble());
    }

    public static ExtendedRational ofString(String s) {
        switch (s) {
            case "Infinity": {
                return INFTY;
            }
            case "-Infinity": {
                return NEG_INFTY;
            }
            case "NaN": {
                return NaN;
            }
        }
        return new ExtendedRational(Rational.ofString(s));
    }

    @Override
    public int compareTo(ExtendedRational b) {
        NumberType us = this.numberType;
        NumberType them = b.numberType;
        if (us == them) {
            if (us == NumberType.RATIONAL) {
                return this.rational.compareTo(b.rational);
            }
            return 0;
        }
        return us.ordinal() - them.ordinal();
    }

    public boolean equals(Object y) {
        if (this == y) {
            return true;
        }
        if (y == null) {
            return false;
        }
        if (y.getClass() != this.getClass()) {
            return false;
        }
        ExtendedRational b = (ExtendedRational)y;
        return this.compareTo(b) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ExtendedRational times(ExtendedRational b) {
        if (this == NaN || b == NaN) {
            return NaN;
        }
        if (this == NEG_INFTY ^ b == NEG_INFTY) {
            return NEG_INFTY;
        }
        if (this == INFTY || b == INFTY || this == NEG_INFTY && b == NEG_INFTY) {
            return INFTY;
        }
        return new ExtendedRational(this.rational.times(b.rational));
    }

    public ExtendedRational plus(ExtendedRational b) {
        if (this == NaN || b == NaN) {
            return NaN;
        }
        if (this == NEG_INFTY && b == INFTY || this == INFTY && b == NEG_INFTY) {
            return NaN;
        }
        if (this == INFTY || b == INFTY) {
            return INFTY;
        }
        if (this == NEG_INFTY || b == NEG_INFTY) {
            return NEG_INFTY;
        }
        return new ExtendedRational(this.rational.plus(b.rational));
    }

    public ExtendedRational minus(ExtendedRational b) {
        ExtendedRational a = this;
        return a.plus(b.negate());
    }

    public ExtendedRational divides(ExtendedRational b) {
        ExtendedRational a = this;
        return a.times(b.reciprocal());
    }

    public ExtendedRational reciprocal() {
        if (this == NaN) {
            return NaN;
        }
        if (this == INFTY || this == NEG_INFTY) {
            return new ExtendedRational(Rational.ZERO);
        }
        return new ExtendedRational(this.rational.reciprocal());
    }

    public ExtendedRational negate() {
        if (this == NaN) {
            return NaN;
        }
        if (this == INFTY) {
            return NEG_INFTY;
        }
        if (this == NEG_INFTY) {
            return INFTY;
        }
        return new ExtendedRational(this.rational.negate());
    }

    public static enum NumberType {
        NEG_INFTY,
        RATIONAL,
        INFTY,
        NaN;

    }
}

